/*
 * Decompiled with CFR 0.152.
 */
package org.egov.eis.repository;

import java.util.List;
import org.egov.pims.commons.Position;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface PositionMasterRepository
extends JpaRepository<Position, Long> {
    public Position findByName(String var1);

    public List<Position> findByNameContainingIgnoreCase(String var1);

    public List<Position> findAllByDeptDesig_Id(Long var1);

    @Query(value="select cr from Position cr ")
    public List<Position> findPositionByAll();

    @Query(value="select cr from Position cr where cr.deptDesig.department.id=:departmentId and cr.deptDesig.designation.id=:designationId")
    public List<Position> findPositionBydepartmentAndDesignation(@Param(value="departmentId") Long var1, @Param(value="designationId") Long var2);

    @Query(value="select cr from Position cr where cr.deptDesig.department.id=:departmentId ")
    public List<Position> findPositionBydepartment(@Param(value="departmentId") Long var1);

    @Query(value="select cr from Position cr where  cr.deptDesig.designation.id=:designationId")
    public List<Position> findPositionByDesignation(@Param(value="designationId") Long var1);

    public List<Position> findByDeptDesig_Department_IdAndDeptDesig_Designation_IdAndNameContainingIgnoreCase(Long var1, Long var2, String var3);

    @Query(value="select count(*)  from Position cr where cr.deptDesig.department.id=:departmentId and cr.deptDesig.designation.id=:designationId and cr.isPostOutsourced is true")
    public Integer getTotalOutSourcedPostsByDepartmentAndDesignation(@Param(value="departmentId") Long var1, @Param(value="designationId") Long var2);

    @Query(value="select count(*)  from Position cr where cr.deptDesig.department.id=:departmentId and cr.isPostOutsourced is true ")
    public Integer getTotalOutSourcedPostsByDepartment(@Param(value="departmentId") Long var1);

    @Query(value="select count(*)  from Position cr where  cr.deptDesig.designation.id=:designationId and cr.isPostOutsourced is true")
    public Integer getTotalOutSourcedPostsByDesignation(@Param(value="designationId") Long var1);

    @Query(value="select count(*)  from Position cr where cr.isPostOutsourced is true")
    public Integer getTotalOutSourcedPosts();

    @Query(value="select count(*)  from Position cr where cr.deptDesig.department.id=:departmentId and cr.deptDesig.designation.id=:designationId ")
    public Integer getTotalSanctionedPostsByDepartmentAndDesignation(@Param(value="departmentId") Long var1, @Param(value="designationId") Long var2);

    @Query(value="select count(*)  from Position cr where cr.deptDesig.department.id=:departmentId  ")
    public Integer getTotalSanctionedPostsByDepartment(@Param(value="departmentId") Long var1);

    @Query(value="select count(*)  from Position cr where  cr.deptDesig.designation.id=:designationId ")
    public Integer getTotalSanctionedPostsByDesignation(@Param(value="designationId") Long var1);

    @Query(value="select count(*)  from Position cr ")
    public Integer getTotalSanctionedPosts();

    @Query(value="select count(*)  from Position cr where cr.name like :name||'%' ")
    public Integer getPositionSerialNumberByName(@Param(value="name") String var1);
}

