/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pims.commons.dao;

import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.log4j.Logger;
import org.egov.commons.exception.NoSuchObjectException;
import org.egov.infra.exception.ApplicationException;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.pims.commons.Designation;
import org.hibernate.Query;
import org.hibernate.Session;

public class DesignationMasterDAO
implements Serializable {
    public static final Logger LOGGER = Logger.getLogger(DesignationMasterDAO.class.getClass());
    @PersistenceContext
    private EntityManager entityManager;

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    public void createDesignationMaster(Designation designation) throws ApplicationException {
        if (designation == null) {
            throw new ApplicationException("designation.master.null");
        }
        this.getCurrentSession().saveOrUpdate((Object)designation);
    }

    public void updateDesignationMaster(Designation designation) throws ApplicationException {
        if (designation == null) {
            throw new ApplicationException("designation.master.null");
        }
        this.getCurrentSession().saveOrUpdate((Object)designation);
    }

    public void removeDesignationMaster(Designation designation) throws ApplicationException {
        if (designation == null) {
            throw new ApplicationException("designation.master.null");
        }
        this.getCurrentSession().delete((Object)designation);
    }

    public Designation getDesignationMaster(int desigID) throws ApplicationException {
        Designation desig = null;
        if (Integer.valueOf(desigID) == null) {
            throw new ApplicationException("designation.id.null");
        }
        desig = (Designation)this.getCurrentSession().get(Designation.class, (Serializable)Integer.valueOf(desigID));
        return desig;
    }

    public Map getAllDesignationMaster() throws ApplicationException {
        Query qry = this.getCurrentSession().createQuery("from Designation DM ");
        LinkedHashMap<Long, String> retMap = new LinkedHashMap<Long, String>();
        Designation designation = null;
        Iterator iter = qry.iterate();
        while (iter.hasNext()) {
            designation = (Designation)iter.next();
            retMap.put(designation.getId(), designation.getName());
        }
        if (designation == null) {
            throw new ApplicationException("designation.notFound");
        }
        return retMap;
    }

    public boolean checkDuplication(String designationName, String className) {
        try {
            if (designationName == null) {
                throw new ApplicationException("designation.name.null");
            }
            if (className == null) {
                throw new ApplicationException("className.null");
            }
            boolean b = false;
            Query qry = this.getCurrentSession().createQuery("from " + className + " CA where trim(upper(CA.designationName)) = :designationName ");
            qry.setString("designationName", designationName);
            Iterator iter = qry.iterate();
            LOGGER.info((Object)("iter" + iter));
            if (iter.hasNext()) {
                LOGGER.info((Object)("iter" + iter.hasNext()));
                b = true;
            }
            return b;
        }
        catch (Exception e) {
            throw new ApplicationRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    public Designation getDesignationByDesignationName(String designationName) throws NoSuchObjectException {
        if (designationName == null) {
            throw new ApplicationRuntimeException("designation.name.null");
        }
        try {
            Query qry = this.getCurrentSession().createQuery("select d from  Designation d where trim(upper(d.name)) = :designationName ");
            qry.setString("designationName", designationName.toUpperCase());
            Designation desig = (Designation)qry.uniqueResult();
            if (desig == null) {
                throw new NoSuchObjectException("designation.master.notFound");
            }
            return desig;
        }
        catch (Exception e) {
            throw new ApplicationRuntimeException(e.getMessage(), (Throwable)e);
        }
    }
}

