/*
 * Decompiled with CFR 0.152.
 */
package org.egov.eis.web.controller.workflow;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.egov.eis.web.contract.WorkflowContainer;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.service.DepartmentService;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.infra.workflow.matrix.entity.WorkFlowMatrix;
import org.egov.infra.workflow.matrix.service.CustomizedWorkFlowService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;

@Controller
public abstract class GenericWorkFlowController {
    @Autowired
    protected CustomizedWorkFlowService customizedWorkFlowService;
    @Autowired
    protected DepartmentService departmentService;

    @ModelAttribute(value="approvalDepartmentList")
    public List<Department> addAllDepartments() {
        return this.departmentService.getAllDepartments();
    }

    @ModelAttribute(value="workflowcontainer")
    public WorkflowContainer getWorkflowContainer() {
        return new WorkflowContainer();
    }

    protected void prepareWorkflow(Model prepareModel, StateAware model, WorkflowContainer container) {
        prepareModel.addAttribute("approverDepartmentList", this.addAllDepartments());
        prepareModel.addAttribute("validActionList", this.getValidActions(model, container));
        prepareModel.addAttribute("nextAction", (Object)this.getNextAction(model, container));
    }

    public String getNextAction(StateAware model, WorkflowContainer container) {
        WorkFlowMatrix wfMatrix = null;
        if (null != model && null != model.getId()) {
            wfMatrix = null != model.getCurrentState() ? this.customizedWorkFlowService.getWfMatrix(model.getStateType(), container.getWorkFlowDepartment(), container.getAmountRule(), container.getAdditionalRule(), model.getCurrentState().getValue(), container.getPendingActions(), model.getCreatedDate(), container.getCurrentDesignation()) : this.customizedWorkFlowService.getWfMatrix(model.getStateType(), container.getWorkFlowDepartment(), container.getAmountRule(), container.getAdditionalRule(), "Created", container.getPendingActions(), model.getCreatedDate(), container.getCurrentDesignation());
        }
        return wfMatrix == null ? "" : wfMatrix.getNextAction();
    }

    public List<String> getValidActions(StateAware model, WorkflowContainer container) {
        List<String> validActions = Collections.emptyList();
        validActions = null == model || null == model.getId() || model.getCurrentState() == null || model != null && model.getCurrentState() != null && (model.getCurrentState().getValue().equals("Closed") || model.getCurrentState().getValue().equals("END")) ? Arrays.asList("Forward") : (null != model.getCurrentState() ? this.customizedWorkFlowService.getNextValidActions(model.getStateType(), container.getWorkFlowDepartment(), container.getAmountRule(), container.getAdditionalRule(), model.getCurrentState().getValue(), container.getPendingActions(), model.getCreatedDate(), container.getCurrentDesignation()) : this.customizedWorkFlowService.getNextValidActions(model.getStateType(), container.getWorkFlowDepartment(), container.getAmountRule(), container.getAdditionalRule(), "Created", container.getPendingActions(), model.getCreatedDate(), container.getCurrentDesignation()));
        return validActions;
    }
}

