/*
 * Decompiled with CFR 0.152.
 */
package org.egov.eis.entity;

import java.lang.reflect.Field;
import org.egov.eis.entity.Employee;

public class EmployeeBuilder {
    private final Employee employee = new Employee();
    private static long count = 0L;

    public EmployeeBuilder() {
        ++count;
    }

    public Employee build() {
        return this.employee;
    }

    public EmployeeBuilder withCode(String code) {
        this.employee.setCode(code);
        return this;
    }

    public EmployeeBuilder withUserName(String userName) {
        this.employee.setUsername(userName);
        return this;
    }

    public EmployeeBuilder withName(String name) {
        this.employee.setName(name);
        return this;
    }

    public EmployeeBuilder withId(long id) {
        try {
            Field idField = this.employee.getClass().getSuperclass().getDeclaredField("id");
            idField.setAccessible(true);
            idField.set(this.employee, id);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public EmployeeBuilder withDefaults() {
        if (null == this.employee.getId()) {
            this.withId(count);
        }
        if (null == this.employee.getName()) {
            this.withName("test-employee-" + count);
            this.withCode("test-" + this.employee.getName());
        }
        return this;
    }

    public EmployeeBuilder withDbDefaults() {
        if (null == this.employee.getName()) {
            this.withName("test-employee-" + count);
            this.withCode("test-" + this.employee.getName());
        }
        return this;
    }
}

