/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pims.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.commons.EgwStatus;
import org.egov.commons.dao.EgwStatusHibernateDAO;
import org.egov.commons.service.EntityTypeService;
import org.egov.commons.utils.EntityType;
import org.egov.eis.entity.EmployeeView;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.script.service.ScriptService;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infstr.services.Page;
import org.egov.infstr.services.PersistenceService;
import org.egov.pims.model.PersonalInformation;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;

public class PersonalInformationService
extends PersistenceService<PersonalInformation, Integer>
implements EntityTypeService {
    private static final String ACTIVEEMPSBYLOGGEDINUSER = "EMPVIEW-ACTIVE-EMPS-BYLOGGEDINUSER";
    private final String PERSONALINFOBYIDS = "PERSONALINFO-BYIDS";
    private final String PERSONALINFOEMPCODESTARTSWITH = "PERSONALINFO-EMPCODE-STARTSWITH";
    private final String EMPVIEWBYLOGGEDINUSER = "EMPVIEW-EMPS-BYLOGGEDINUSER";
    private final String EMPVIEWDEPTIDSLOGGEDINUSER = "EMPVIEW-DEPTIDS-LOGGEDINUSER";
    private static final String EMPVIEWACTIVEEMPS = "EMPVIEW-ACTIVE-EMPS";
    private static final String EMPVIEWEMPSLASTASSPRD = "EMPVIEW-EMPS-LASTASSPRD";
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private AppConfigValueService appConfigValuesService;
    @Autowired
    private EgwStatusHibernateDAO egwStatusHibernateDAO;
    private ScriptService scriptService;

    public PersonalInformationService() {
        super(PersonalInformation.class);
    }

    public PersonalInformationService(Class<PersonalInformation> type) {
        super(type);
    }

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    public ScriptService getScriptService() {
        return this.scriptService;
    }

    public void setScriptService(ScriptService scriptService) {
        this.scriptService = scriptService;
    }

    public List<EntityType> getAllActiveEntities(Integer employeeId) {
        ArrayList<EntityType> entities = new ArrayList<EntityType>();
        entities.addAll(this.findAllByNamedQuery("ACTIVE_EMPLOYEES", new Object[0]));
        return entities;
    }

    public List<EntityType> filterActiveEntities(String filterKey, int maxRecords, Integer accountDetailTypeId) {
        Integer pageSize = maxRecords > 0 ? Integer.valueOf(maxRecords) : null;
        ArrayList<EntityType> entities = new ArrayList<EntityType>();
        Page pg = this.findPageByNamedQuery("ACTIVE_EMPLOYEES_STARTSWITH", 0, pageSize, new Object[]{filterKey + "%", filterKey + "%"});
        entities.addAll(pg.getList());
        return entities;
    }

    public List<PersonalInformation> getActiveEmpListByUserLogin(Integer userid, String autoValue, int maxRecords) {
        Integer pageSize = maxRecords > 0 ? Integer.valueOf(maxRecords) : null;
        autoValue = autoValue + "%";
        String filterByDept = this.appConfigValuesService.getAppConfigValue("EIS-PAYROLL", "FILTERBYDEPT", "false");
        if (filterByDept != null && filterByDept.toUpperCase().equals("YES")) {
            List deptIdList = this.getDeptsForLoggedInUser(userid);
            if (deptIdList.isEmpty()) {
                return Collections.emptyList();
            }
            List personalinfoIdList = this.findPageByNamedQuery(ACTIVEEMPSBYLOGGEDINUSER, 0, maxRecords, new Object[]{autoValue, deptIdList}).getList();
            return personalinfoIdList;
        }
        return this.findPageByNamedQuery(EMPVIEWACTIVEEMPS, 0, pageSize, new Object[]{autoValue}).getList();
    }

    public List<PersonalInformation> getEmpListByUserLogin(Integer userid, String autoValue, int maxRecords) {
        Integer pageSize = maxRecords > 0 ? Integer.valueOf(maxRecords) : null;
        autoValue = autoValue + "%";
        String filterByDept = this.appConfigValuesService.getAppConfigValue("EIS-PAYROLL", "FILTERBYDEPT", "false");
        if (filterByDept != null && filterByDept.toUpperCase().equals("YES")) {
            List deptIdList = this.getDeptsForLoggedInUser(userid);
            if (deptIdList.isEmpty()) {
                return Collections.emptyList();
            }
            List personalinfoIdList = this.findPageByNamedQuery("EMPVIEW-EMPS-BYLOGGEDINUSER", 0, pageSize, new Object[]{autoValue, autoValue, deptIdList}).getList();
            return personalinfoIdList;
        }
        return this.findPageByNamedQuery(EMPVIEWEMPSLASTASSPRD, 0, pageSize, new Object[]{autoValue, autoValue}).getList();
    }

    private List getDeptsForLoggedInUser(Integer userId) {
        List deptList = this.findPageByNamedQuery("EMPVIEW-DEPTIDS-LOGGEDINUSER", 0, null, new Object[]{userId, userId}).getList();
        ArrayList<Integer> deptListInt = new ArrayList<Integer>();
        for (BigDecimal deptId : deptList) {
            if (deptId == null) continue;
            deptListInt.add(deptId.intValue());
        }
        return deptListInt;
    }

    public List<EmployeeView> getAllActiveEmployeesEmpViewByPrimaryAssignment(String filterKey, int maxRecords) {
        Integer pageSize = maxRecords > 0 ? Integer.valueOf(maxRecords) : null;
        ArrayList<EmployeeView> personalInfEntities = new ArrayList<EmployeeView>();
        Page pg = this.findPageByNamedQuery("ALLACTIVE-EMPS-EMPVIEW", 0, pageSize, new Object[]{filterKey + "%"});
        personalInfEntities.addAll(pg.getList());
        return personalInfEntities;
    }

    public List<PersonalInformation> getEmployeesByStatus(Integer statusid, Date fromDate, Date toDate) {
        List employeeList;
        Criteria criteria = null;
        try {
            criteria = this.getCriteriaForEmpSearchByStatus(statusid, fromDate, toDate);
            employeeList = criteria.list();
        }
        catch (HibernateException he) {
            throw new ApplicationRuntimeException("Exception:" + he.getMessage(), (Throwable)he);
        }
        catch (Exception he) {
            throw new ApplicationRuntimeException("Exception:" + he.getMessage(), (Throwable)he);
        }
        return employeeList;
    }

    public Page getEmployeesByStatus(Integer statusid, Date fromDate, Date toDate, Integer pageNumber, Integer pageSize) {
        Criteria criteria = null;
        criteria = this.getCriteriaForEmpSearchByStatus(statusid, fromDate, toDate);
        return new Page(criteria, pageNumber, pageSize);
    }

    public int getTotalCountOfEmployeesByStatus(Integer statusid, Date fromDate, Date toDate) {
        Criteria criteria = null;
        int totalSize = 0;
        try {
            criteria = this.getCriteriaForEmpSearchByStatus(statusid, fromDate, toDate);
            criteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
            criteria.setProjection(Projections.rowCount());
            if (criteria.uniqueResult() != null) {
                totalSize = ((Long)criteria.uniqueResult()).intValue();
            }
        }
        catch (HibernateException he) {
            throw new ApplicationRuntimeException("Exception:" + he.getMessage(), (Throwable)he);
        }
        catch (Exception he) {
            throw new ApplicationRuntimeException("Exception:" + he.getMessage(), (Throwable)he);
        }
        return totalSize;
    }

    private Criteria getCriteriaForEmpSearchByStatus(Integer statusid, Date fromDate, Date toDate) {
        EgwStatus egwStatus = this.egwStatusHibernateDAO.findById(statusid, false);
        DetachedCriteria detachCriteriaPersonalInfo = DetachedCriteria.forClass(PersonalInformation.class, (String)"emp");
        if (egwStatus.getModuletype().equals("Employee") && egwStatus.getDescription().equalsIgnoreCase("Employed")) {
            detachCriteriaPersonalInfo.createAlias("emp.egpimsAssignment", "assPrd").add((Criterion)Restrictions.and((Criterion)Restrictions.le((String)"assPrd.fromDate", (Object)toDate), (Criterion)Restrictions.or((Criterion)Restrictions.ge((String)"assPrd.toDate", (Object)toDate), (Criterion)Restrictions.isNull((String)"assPrd.toDate"))));
        } else if (egwStatus.getModuletype().equals("Employee") && egwStatus.getDescription().equalsIgnoreCase("Retired")) {
            detachCriteriaPersonalInfo.add(Restrictions.between((String)"emp.retirementDate", (Object)fromDate, (Object)toDate));
        } else if (egwStatus.getModuletype().equals("Employee") && egwStatus.getDescription().equalsIgnoreCase("Deceased")) {
            detachCriteriaPersonalInfo.add(Restrictions.between((String)"emp.deathDate", (Object)fromDate, (Object)toDate));
        }
        return detachCriteriaPersonalInfo.getExecutableCriteria(this.getCurrentSession());
    }

    public List<EmployeeView> getListOfEmployeeViewBasedOnCriteria(HashMap<String, Object> criteriaParams, Integer pageNo, Integer pageSize) {
        ArrayList<EmployeeView> employeeList = new ArrayList();
        try {
            Criteria criteria = this.getCurrentSession().createCriteria(EmployeeView.class);
            for (Map.Entry<String, Object> entry : criteriaParams.entrySet()) {
                if ("departmentId".equals(entry.getKey())) {
                    criteria.createAlias("deptId", "department").add((Criterion)Restrictions.eq((String)"department.id", (Object)entry.getValue()));
                }
                if ("designationId".equals(entry.getKey())) {
                    criteria.createAlias("desigId", "designation").add((Criterion)Restrictions.eq((String)"designation.designationId", (Object)entry.getValue()));
                }
                if ("isPrimary".equals(entry.getKey())) {
                    criteria.add((Criterion)Restrictions.eq((String)"isPrimary", (Object)entry.getValue()));
                }
                Date asOnDate = "asOnDate".equals(entry.getKey()) ? (Date)entry.getValue() : DateUtils.today();
                criteria.add((Criterion)Restrictions.and((Criterion)Restrictions.le((String)"fromDate", (Object)asOnDate), (Criterion)Restrictions.ge((String)"toDate", (Object)asOnDate)));
            }
            criteria.addOrder(Order.asc((String)"id"));
            employeeList = new Page(criteria, pageNo, pageSize).getList();
        }
        catch (Exception e) {
            throw new ApplicationRuntimeException("Error occured in searching for employees", (Throwable)e);
        }
        return employeeList;
    }

    public List<EmployeeView> getListOfEmployeeViewBasedOnListOfDesignationAndOtherCriteria(HashMap<String, Object> criteriaParams, Integer pageNo, Integer pageSize) {
        ArrayList<EmployeeView> employeeList = new ArrayList();
        try {
            Criteria criteria = this.getCurrentSession().createCriteria(EmployeeView.class);
            for (Map.Entry<String, Object> entry : criteriaParams.entrySet()) {
                if ("departmentId".equals(entry.getKey())) {
                    criteria.createAlias("deptId", "department").add((Criterion)Restrictions.eq((String)"department.id", (Object)entry.getValue()));
                }
                if ("designationId".equals(entry.getKey())) {
                    criteria.createAlias("desigId", "designation").add(Restrictions.in((String)"designation.designationId", (Collection)((List)entry.getValue())));
                }
                if ("isPrimary".equals(entry.getKey())) {
                    criteria.add((Criterion)Restrictions.eq((String)"isPrimary", (Object)entry.getValue()));
                }
                if ("employeeName".equals(entry.getKey()) && entry.getValue() != null && !"".equals(entry.getValue())) {
                    criteria.add(Restrictions.ilike((String)"employeeName", (String)entry.getValue().toString(), (MatchMode)MatchMode.ANYWHERE));
                }
                if ("isActive".equals(entry.getKey()) && entry.getValue() != null && !"".equals(entry.getValue())) {
                    criteria.add((Criterion)Restrictions.eq((String)"isActive", (Object)Integer.valueOf(entry.getValue().toString())));
                }
                if ("employeeCode".equals(entry.getKey())) {
                    criteria.add(Restrictions.in((String)"employeeCode", (Collection)((List)entry.getValue())));
                }
                Date asOnDate = "asOnDate".equals(entry.getKey()) ? (Date)entry.getValue() : DateUtils.today();
                criteria.add((Criterion)Restrictions.and((Criterion)Restrictions.le((String)"fromDate", (Object)asOnDate), (Criterion)Restrictions.ge((String)"toDate", (Object)asOnDate)));
            }
            criteria.addOrder(Order.asc((String)"id"));
            employeeList = new Page(criteria, pageNo, pageSize).getList();
        }
        catch (Exception e) {
            throw new ApplicationRuntimeException("Error occured in searching for employees", (Throwable)e);
        }
        return employeeList;
    }

    public List getAssetCodesForProjectCode(Integer accountdetailkey) throws ValidationException {
        return null;
    }

    public List<? extends EntityType> validateEntityForRTGS(List<Long> idsList) throws ValidationException {
        return null;
    }

    public List<? extends EntityType> getEntitiesById(List<Long> idsList) throws ValidationException {
        return null;
    }
}

