/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pims.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.egov.commons.exception.NoSuchObjectException;
import org.egov.eis.entity.Assignment;
import org.egov.eis.entity.EmployeeView;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infstr.services.EISServeable;
import org.egov.infstr.services.PersistenceService;
import org.egov.pims.commons.Designation;
import org.egov.pims.commons.Position;
import org.egov.pims.dao.PersonalInformationDAO;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="eisService")
public class EisUtilService
implements EISServeable {
    private static final Logger LOGGER = Logger.getLogger(EisUtilService.class);
    private final String EMPVIEWDEPTIDSLOGGEDINUSER = "EMPVIEW-DEPTIDS-LOGGEDINUSER";
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    @Autowired
    private BoundaryService boundaryService;
    @Autowired
    private PersonalInformationDAO personalInformationDAO;
    @Autowired
    private AppConfigValueService appConfigValuesService;

    public List<Position> getPositionsForUser(Long user, Date date) {
        ArrayList<Position> positionList = new ArrayList();
        try {
            String mainStr = "";
            mainStr = "select distinct(a.position) from Assignment a where a.employee.id =?";
            if (date == null) {
                date = new Date();
            }
            mainStr = mainStr + " and ((a.toDate is null and a.fromDate<= ?) or (a.fromDate <= ? and a.toDate >= ?))";
            positionList = this.persistenceService.findAllBy(mainStr, new Object[]{user, date, date, date});
        }
        catch (Exception e) {
            LOGGER.error((Object)("Exception while getting the getPositionsForUser=" + e.getMessage()));
            throw new ApplicationRuntimeException(e.getMessage(), (Throwable)e);
        }
        return positionList;
    }

    public Position getPrimaryPositionForUser(Long userId, Date date) {
        Position position = null;
        try {
            String mainStr = "";
            mainStr = "select a.position from Assignment a where a.primary=true";
            if (userId != null && userId != 0L) {
                mainStr = mainStr + " and a.oldEmployee.userMaster.id =?";
            }
            if (date == null) {
                date = new Date();
            }
            mainStr = mainStr + " and ((a.toDate is null and a.fromDate<= ?) or (a.fromDate <= ? and a.toDate >= ?))";
            position = (Position)this.persistenceService.find(mainStr, new Object[]{userId, date, date, date});
        }
        catch (Exception e) {
            LOGGER.error((Object)("Exception while getting the getPrimaryPositionForUser=" + e.getMessage()));
            throw new ApplicationRuntimeException(e.getMessage(), (Throwable)e);
        }
        return position;
    }

    public User getUserForPosition(Long positionId, Date date) {
        User user = null;
        try {
            String mainStr = "";
            mainStr = "select emp.userMaster from EmployeeView emp where emp.position.id = ?";
            if (date == null) {
                date = new Date();
            }
            mainStr = mainStr + " and ((emp.toDate is null and emp.fromDate<= ?) or (emp.fromDate <= ? and emp.toDate >= ?))";
            user = (User)this.persistenceService.find(mainStr, new Object[]{positionId, date, date, date});
        }
        catch (Exception e) {
            LOGGER.error((Object)("Exception while getting the getUserForPosition=" + e.getMessage()));
            throw new ApplicationRuntimeException(e.getMessage(), (Throwable)e);
        }
        return user;
    }

    public List<EmployeeView> getEmployeeInfoList(HashMap paramMap) {
        List empInfoList = new ArrayList();
        Integer departmentId = paramMap.get("departmentId") != null ? Integer.valueOf(Integer.parseInt((String)paramMap.get("departmentId"))) : null;
        Integer designationId = paramMap.get("designationId") != null ? Integer.valueOf(Integer.parseInt((String)paramMap.get("designationId"))) : null;
        Integer functionaryId = paramMap.get("functionaryId") != null ? Integer.valueOf(Integer.parseInt((String)paramMap.get("functionaryId"))) : null;
        String code = (String)paramMap.get("code");
        String name = (String)paramMap.get("name");
        Integer status = paramMap.get("status") != null ? Integer.valueOf(Integer.parseInt((String)paramMap.get("status"))) : null;
        Integer empType = paramMap.get("empType") != null ? Integer.valueOf(Integer.parseInt((String)paramMap.get("empType"))) : null;
        String searchAll = (String)paramMap.get("searchAll");
        Long boundaryId = paramMap.get("boundaryId") != null ? Long.valueOf((String)paramMap.get("boundaryId")) : null;
        Long userId = paramMap.get("userId") != null ? Long.valueOf((String)paramMap.get("userId")) : null;
        List roleList = paramMap.get("roleList") != null ? (List)paramMap.get("roleList") : new ArrayList();
        List userList = new ArrayList();
        if (boundaryId != null && boundaryId != 0L) {
            Boundary boundary = null;
            boundary = this.boundaryService.getBoundaryById(boundaryId);
            if (boundary.getParent() != null) {
                try {
                    userList = this.getListOfUsersForGivenBoundaryId(boundaryId);
                }
                catch (NoSuchObjectException e) {
                    LOGGER.error((Object)e);
                }
            }
        }
        if ("Y".equalsIgnoreCase(searchAll)) {
            empInfoList = this.persistenceService.findAllBy("from EmployeeView", new Object[0]);
        } else {
            String mainStr = "from EmployeeView ev where";
            if (code != null && !code.equals("")) {
                mainStr = mainStr + " upper(trim(ev.employeeCode)) = :employeeCode and ";
            }
            if (departmentId != null && departmentId != 0) {
                mainStr = mainStr + " ev.department.id= :deptId and ";
            }
            if (designationId != null && designationId != 0) {
                mainStr = mainStr + " ev.designation.id = :designationId and ";
            }
            if (functionaryId != null && functionaryId != 0) {
                mainStr = mainStr + " ev.functionary.id = :functionaryId and ";
            }
            if (empType != null && empType != 0) {
                mainStr = mainStr + " ev.employeeType.id=:employeeType and";
            }
            if (boundaryId != null && boundaryId.intValue() != 0 && !userList.isEmpty()) {
                mainStr = mainStr + " ev.userMaster in(:userObjList) and ";
            }
            if (userId != null && userId.intValue() != 0) {
                mainStr = mainStr + " ev.userMaster.id =:userId and ";
            }
            if (!roleList.isEmpty()) {
                mainStr = mainStr + "ev.userMaster.id in(select userRole.user.id from UserRole userRole where ((userRole.fromDate <= current_date and userRole.toDate >= current_date) or (userRole.fromDate <= current_date and userRole.toDate is null)) and userRole.role.roleName in(:roleList) ) and";
            }
            if (name != null && !name.equals("")) {
                mainStr = mainStr + " trim(upper(ev.employeeName))  like '%" + name.trim().toUpperCase() + "%' and ";
            }
            if (status != null && status != 0) {
                mainStr = mainStr + " ev.employeeStatus.id = :employeeStatus and ";
            }
            mainStr = status != null && status != 0 && designationId != null && designationId == 0 ? mainStr + " ((ev.toDate is null and ev.fromDate <= current_date ) OR (ev.fromDate <= current_date AND ev.toDate > current_date)) and ev.employeeStatus.id = :employeeStatus " : (status != null && status == 0 && designationId != null && designationId != 0 ? mainStr + " ((ev.toDate is null and ev.fromDate <= current_date ) OR (ev.fromDate <= current_date AND ev.toDate > current_date)) " : (code != null && !code.equals("") ? mainStr + "  ((ev.toDate IS NULL AND ev.fromDate <= current_date) OR (ev.fromDate <= current_date AND ev.toDate > current_date)  OR (ev.fromDate IN (SELECT MAX (evn.fromDate)  FROM EmployeeView  evn    WHERE evn.id = ev.id AND NOT EXISTS  (SELECT evn2.id FROM EmployeeView evn2 WHERE evn2.id = ev.id AND  ((evn2.toDate  IS NULL AND evn2.fromDate <= current_date) OR (evn2.fromDate <= current_date AND evn2.toDate > current_date)) )))) " : (status != null && status != 0 || designationId != null && designationId == 0 ? mainStr + "  ((ev.toDate IS NULL AND ev.fromDate <= current_date) OR (ev.fromDate <= current_date AND ev.toDate > current_date)  OR (ev.fromDate IN (SELECT MAX (evn.fromDate)  FROM EmployeeView  evn    WHERE evn.id = ev.id AND NOT EXISTS  (SELECT evn2.id FROM EmployeeView evn2 WHERE evn2.id = ev.id AND  ((evn2.toDate  IS NULL AND evn2.fromDate <= current_date) OR (evn2.fromDate <= current_date AND evn2.toDate > current_date)) )))) " : mainStr + " ((ev.toDate is null and ev.fromDate <= current_date ) OR (ev.fromDate <= current_date AND ev.toDate > current_date)) ")));
            mainStr = mainStr + " and ev.userActive='1' ";
            Query qry = null;
            qry = this.persistenceService.getSession().createQuery(mainStr);
            LOGGER.info((Object)("qryqryqryqry" + qry.toString()));
            if (code != null && !code.equals("")) {
                qry.setString("employeeCode", code);
            }
            if (departmentId != null && departmentId != 0) {
                qry.setInteger("deptId", departmentId.intValue());
            }
            if (designationId != null && designationId != 0) {
                qry.setInteger("designationId", designationId.intValue());
            }
            if (functionaryId != null && functionaryId != 0) {
                qry.setInteger("functionaryId", functionaryId.intValue());
            }
            if (status != null && status != 0) {
                qry.setInteger("employeeStatus", status.intValue());
            }
            if (boundaryId != null && boundaryId.intValue() != 0 && !userList.isEmpty()) {
                qry.setParameterList("userObjList", userList);
            }
            if (userId != null && userId.intValue() != 0) {
                qry.setLong("userId", userId.longValue());
            }
            if (!roleList.isEmpty()) {
                qry.setParameterList("roleList", roleList);
            }
            if (empType != null && empType != 0) {
                qry.setInteger("employeeType", empType.intValue());
            }
            empInfoList = qry.list();
        }
        return empInfoList;
    }

    public List<Position> getUniquePositionList(HashMap<String, String> paramMap, Date date) {
        Integer fundId;
        ArrayList<Position> positionList = new ArrayList();
        Integer departmentId = paramMap.get("departmentId") != null ? Integer.valueOf(Integer.parseInt(paramMap.get("departmentId"))) : null;
        Integer designationId = paramMap.get("designationId") != null ? Integer.valueOf(Integer.parseInt(paramMap.get("designationId"))) : null;
        Integer functionaryId = paramMap.get("functionaryId") != null ? Integer.valueOf(Integer.parseInt(paramMap.get("functionaryId"))) : null;
        Integer functionId = paramMap.get("functionId") != null ? Integer.valueOf(Integer.parseInt(paramMap.get("functionId"))) : null;
        Integer n = fundId = paramMap.get("fundId") != null ? Integer.valueOf(Integer.parseInt(paramMap.get("fundId"))) : null;
        if (date == null) {
            date = new Date();
        }
        String qryString = "select distinct(ass.position) from Assignment ass where ";
        if (departmentId != null && departmentId != 0) {
            qryString = qryString + " ass.deptId.id= :deptId and ";
        }
        if (designationId != null && designationId != 0) {
            qryString = qryString + " ass.desigId.designationId = :designationId and ";
        }
        if (functionaryId != null && functionaryId != 0) {
            qryString = qryString + " ass.functionary.id = :functionaryId and ";
        }
        if (functionId != null && functionId != 0) {
            qryString = qryString + " ass.functionId.id = :functionId and ";
        }
        if (fundId != null && fundId != 0) {
            qryString = qryString + " ass.fundId.id = :fundId and ";
        }
        qryString = qryString + " ass.id in (select asprd.id from Assignment asprd where asprd.fromDate <= :date and asprd.toDate >= :date)";
        Query qry = null;
        LOGGER.info((Object)("qryqryqryqryString--------" + qryString));
        qry = this.persistenceService.getSession().createQuery(qryString);
        LOGGER.info((Object)("qryqryqryqry----" + qry.toString()));
        if (departmentId != null && departmentId != 0) {
            qry.setInteger("deptId", departmentId.intValue());
        }
        if (designationId != null && designationId != 0) {
            qry.setInteger("designationId", designationId.intValue());
        }
        if (functionaryId != null && functionaryId != 0) {
            qry.setInteger("functionaryId", functionaryId.intValue());
        }
        if (functionId != null && functionId != 0) {
            qry.setInteger("functionId", functionId.intValue());
        }
        if (fundId != null && fundId != 0) {
            qry.setInteger("fundId", fundId.intValue());
        }
        qry.setDate("date", date);
        positionList = qry.list();
        return positionList;
    }

    public List getListOfUsersByBoundaryId(Long boundaryId) throws NoSuchObjectException {
        return null;
    }

    public List getListOfUsersForGivenBoundaryId(Long boundaryId) throws NoSuchObjectException {
        List listOfUserByBoundary = this.personalInformationDAO.getListOfUsersForGivenBoundaryId(boundaryId);
        return listOfUserByBoundary;
    }

    @Deprecated
    public List<Designation> getAllDesignationByDept(Integer departmentId, Date givenDate) {
        ArrayList<Designation> designationMstrObj = new ArrayList();
        Date userGivenDate = givenDate == null ? new Date() : givenDate;
        Long deptId = departmentId.longValue();
        Criteria criteria = this.persistenceService.getSession().createCriteria(Assignment.class, "assign").createAlias("assign.department", "department").add((Criterion)Restrictions.eq((String)"department.id", (Object)deptId)).add((Criterion)Restrictions.and((Criterion)Restrictions.le((String)"assign.fromDate", (Object)userGivenDate), (Criterion)Restrictions.ge((String)"assign.toDate", (Object)userGivenDate)));
        ProjectionList projections = Projections.projectionList().add((Projection)Projections.property((String)"assign.designation"));
        criteria.setProjection((Projection)projections);
        criteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
        designationMstrObj = criteria.list();
        return designationMstrObj;
    }

    public List<User> getUsersByDeptAndDesig(Integer deptId, Integer desigId, Date date) {
        date = date == null ? new Date() : date;
        Long dept = deptId.longValue();
        Long desig = desigId.longValue();
        Criteria criteria = this.persistenceService.getSession().createCriteria(EmployeeView.class, "view").add((Criterion)Restrictions.eq((String)"view.department.id", (Object)dept)).add((Criterion)Restrictions.eq((String)"view.designation.id", (Object)desig)).add((Criterion)Restrictions.le((String)"view.fromDate", (Object)date)).add((Criterion)Restrictions.or((Criterion)Restrictions.ge((String)"view.toDate", (Object)date), (Criterion)Restrictions.isNull((String)"view.toDate"))).add(Restrictions.isNotNull((String)"view.userName"));
        ProjectionList projections = Projections.projectionList().add((Projection)Projections.property((String)"view.employee"));
        criteria.setProjection((Projection)projections);
        criteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
        return criteria.list();
    }

    public List<Assignment> getPrimartAssignmentForGivenDateRange(Integer empId, Date fromDate, Date toDate) {
        ArrayList<Assignment> assignmentObj = new ArrayList();
        Criteria criteria = this.persistenceService.getSession().createCriteria(EmployeeView.class, "emp").add((Criterion)Restrictions.eq((String)"emp.primary", (Object)true)).add((Criterion)Restrictions.eq((String)"emp.id", (Object)empId)).add((Criterion)Restrictions.and((Criterion)Restrictions.le((String)"emp.fromDate", (Object)fromDate), (Criterion)Restrictions.ge((String)"emp.toDate", (Object)fromDate)));
        if (toDate != null) {
            criteria.add((Criterion)Restrictions.and((Criterion)Restrictions.le((String)"emp.fromDate", (Object)toDate), (Criterion)Restrictions.ge((String)"emp.toDate", (Object)toDate)));
        }
        ProjectionList projections = Projections.projectionList().add((Projection)Projections.property((String)"emp.assignment"));
        criteria.setProjection((Projection)projections);
        criteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
        assignmentObj = criteria.list();
        return assignmentObj;
    }

    public List<Department> getDeptsForUser() {
        String filterByDept = this.appConfigValuesService.getAppConfigValue("EIS-PAYROLL", "FILTERBYDEPT", "NO");
        List deptlist = null;
        if (filterByDept != null && filterByDept.toUpperCase().equals("YES")) {
            List deptList = this.persistenceService.findPageByNamedQuery("EMPVIEW-DEPTIDS-LOGGEDINUSER", Integer.valueOf(0), null, new Object[]{ApplicationThreadLocals.getUserId().intValue(), ApplicationThreadLocals.getUserId().intValue()}).getList();
            if (deptList.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<Integer> deptListInt = new ArrayList<Integer>();
            for (BigDecimal deptId : deptList) {
                if (deptId == null) continue;
                deptListInt.add(deptId.intValue());
            }
            deptlist = this.persistenceService.getSession().createCriteria(Department.class).add(Restrictions.in((String)"id", deptListInt)).list();
        } else {
            deptlist = this.persistenceService.getSession().createCriteria(Department.class).list();
        }
        return deptlist;
    }

    public boolean isValidWorkflowUser(Position owner) {
        boolean validuser = false;
        List<Position> positions = this.getPositionsForUser((long)ApplicationThreadLocals.getUserId(), new Date());
        if (positions.contains(owner)) {
            validuser = true;
        }
        return validuser;
    }

    public List<HashMap> getListOfDrawingOfficers(List<Long> desigList, Date assignDate, String codeOrName) {
        ArrayList<HashMap> results = new ArrayList<HashMap>();
        if (null == assignDate) {
            assignDate = new Date();
        }
        Query query = this.getQueryForDrawingOfficer(desigList, null, assignDate, codeOrName);
        List tmpList = query.list();
        int i = 0;
        for (Object[] objArray : tmpList) {
            HashMap<String, Object> temp = new HashMap<String, Object>();
            temp.put("empid", objArray[0]);
            temp.put("empname", objArray[1]);
            temp.put("empcode", objArray[2]);
            temp.put("doid", objArray[3]);
            temp.put("doname", objArray[4]);
            temp.put("docode", objArray[5]);
            results.add(i, temp);
            ++i;
        }
        return results;
    }

    private Query getQueryForDrawingOfficer(List<Long> desigList, Integer doId, Date assignDate, String codeOrName) {
        StringBuffer qry = new StringBuffer("select distinct eee.id as empid,eee.name as empname,eee.code as empcode, do.id as doid,do.name as doname,do.code as docode from eg_eis_employeeinfo eee inner join eg_position pos on pos.id = eee.pos_id inner join eg_drawingofficer do on do.id = pos.id_drawing_officer  where eee.isactive=1 and pos.id_drawing_officer is not null  and :enteredDate between eee.from_date and eee.to_date ");
        if (null != desigList && !desigList.isEmpty()) {
            qry.append(" and eee.designationid in (:desList) ");
        }
        if (null != codeOrName && !codeOrName.isEmpty()) {
            qry.append(" and (lower(do.name) like lower(:enteredString) or lower(do.code) like lower(:enteredString)         or lower(eee.name) like lower(:enteredString) or lower(eee.code) like lower(:enteredString)) ");
        }
        if (null != doId) {
            qry.append(" and do.id=:doId ");
        }
        qry.append(" order by eee.name ");
        SQLQuery query = this.persistenceService.getSession().createSQLQuery(qry.toString());
        query.setDate("enteredDate", assignDate);
        if (null != desigList && !desigList.isEmpty()) {
            query.setParameterList("desList", desigList);
        }
        if (null != doId) {
            query.setInteger("doId", doId.intValue());
        }
        if (null != codeOrName && !codeOrName.isEmpty()) {
            query.setString("enteredString", "%" + codeOrName + "%");
        }
        return query;
    }
}

