/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pims.commons.service;

import java.util.Date;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.eis.entity.Assignment;
import org.egov.infstr.services.PersistenceService;
import org.egov.pims.commons.Position;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.Subqueries;

public class PositionService
extends PersistenceService<Position, Integer> {
    @PersistenceContext
    private EntityManager entityManager;

    public PositionService() {
        super(Position.class);
    }

    public PositionService(Class<Position> type) {
        super(type);
    }

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    public Criteria getVacantPositionCriteria(Date fromDate, Date toDate, Integer designationMasterId) {
        DetachedCriteria detachAssignmentPrd = DetachedCriteria.forClass(Assignment.class, (String)"assignment");
        detachAssignmentPrd.add((Criterion)Restrictions.and((Criterion)Restrictions.le((String)"assignment.fromDate", (Object)fromDate), (Criterion)Restrictions.or((Criterion)Restrictions.ge((String)"assignment.toDate", (Object)toDate), (Criterion)Restrictions.isNull((String)"assignment.toDate")))).setProjection((Projection)Projections.property((String)"assignment.id"));
        DetachedCriteria detachAssignment = DetachedCriteria.forClass(Assignment.class, (String)"assignment");
        detachAssignment.add(Subqueries.propertyIn((String)"assignment.id", (DetachedCriteria)detachAssignmentPrd));
        detachAssignment.add((Criterion)Restrictions.eq((String)"assignment.isPrimary", (Object)Character.valueOf('Y')));
        detachAssignment.setProjection(Projections.distinct((Projection)Projections.property((String)"assignment.position.id")));
        Criteria criteria = this.getCurrentSession().createCriteria(Position.class, "position");
        if (designationMasterId != null && !designationMasterId.equals("0")) {
            criteria.add((Criterion)Restrictions.eq((String)"position.deptDesig.designation.id", (Object)designationMasterId));
        }
        criteria.add(Subqueries.propertyNotIn((String)"position.id", (DetachedCriteria)detachAssignment));
        criteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
        criteria.addOrder(Order.asc((String)"position.name"));
        return criteria;
    }
}

