/*
 * Decompiled with CFR 0.152.
 */
package org.egov.eis.web.actions.workflow;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.infra.workflow.matrix.entity.WorkFlowMatrix;
import org.egov.infra.workflow.matrix.service.CustomizedWorkFlowService;

public abstract class GenericWorkFlowAction
extends BaseFormAction {
    private static final long serialVersionUID = 1L;
    private static final String FORWARD = "Forward";
    protected CustomizedWorkFlowService customizedWorkFlowService;
    protected String workFlowAction;
    protected String approverComments;
    protected String currentState;
    protected String currentDesignation;
    protected String additionalRule;
    protected BigDecimal amountRule;
    protected String workFlowDepartment;
    protected String pendingActions;
    protected String approverName;
    protected String approverDepartment;
    protected String approverDesignation;
    protected Long approverPositionId;

    public abstract StateAware getModel();

    public void prepare() {
        super.prepare();
        this.addDropdownData("approverDepartmentList", this.persistenceService.findAllBy("from Department order by name", new Object[0]));
        this.addDropdownData("approverList", Collections.EMPTY_LIST);
        this.addDropdownData("designationList", Collections.EMPTY_LIST);
    }

    protected BigDecimal getAmountRule() {
        return null;
    }

    protected String getAdditionalRule() {
        return null;
    }

    protected String getWorkFlowDepartment() {
        return null;
    }

    public List<String> getValidActions() {
        List<String> validActions = Collections.emptyList();
        if (null == this.getModel() || null == this.getModel().getId() || this.getModel().getCurrentState() == null || this.getModel().getCurrentState().getValue().endsWith("NEW") || this.getModel() != null && this.getModel().getCurrentState() != null && (this.getModel().getCurrentState().getValue().equals("Closed") || this.getModel().getCurrentState().getValue().equals("END"))) {
            validActions = Arrays.asList(FORWARD);
        } else if (this.getModel().getCurrentState() != null) {
            validActions = this.customizedWorkFlowService.getNextValidActions(this.getModel().getStateType(), this.getWorkFlowDepartment(), this.getAmountRule(), this.getAdditionalRule(), this.getModel().getCurrentState().getValue(), this.getPendingActions(), this.getModel().getCreatedDate());
        }
        return validActions;
    }

    public String getNextAction() {
        WorkFlowMatrix wfMatrix = null;
        if (this.getModel().getId() != null) {
            wfMatrix = this.getModel().getCurrentState() != null ? this.customizedWorkFlowService.getWfMatrix(this.getModel().getStateType(), this.getWorkFlowDepartment(), this.getAmountRule(), this.getAdditionalRule(), this.getModel().getCurrentState().getValue(), this.getPendingActions(), this.getModel().getCreatedDate()) : this.customizedWorkFlowService.getWfMatrix(this.getModel().getStateType(), this.getWorkFlowDepartment(), this.getAmountRule(), this.getAdditionalRule(), "Created", this.getPendingActions(), this.getModel().getCreatedDate());
        }
        return wfMatrix == null ? "" : wfMatrix.getNextAction();
    }

    public void setCustomizedWorkFlowService(CustomizedWorkFlowService customizedWorkFlowService) {
        this.customizedWorkFlowService = customizedWorkFlowService;
    }

    public void setWorkFlowAction(String workFlowAction) {
        this.workFlowAction = workFlowAction;
    }

    protected String getPendingActions() {
        return null;
    }

    public String getApproverComments() {
        return this.approverComments;
    }

    public void setApproverComments(String approverComments) {
        this.approverComments = approverComments;
    }

    public String getCurrentState() {
        return this.currentState;
    }

    public void setCurrentState(String currentState) {
        this.currentState = currentState;
    }

    public String getCurrentDesignation() {
        return this.currentDesignation;
    }

    public void setCurrentDesignation(String currentDesignation) {
        this.currentDesignation = currentDesignation;
    }

    public String getApproverName() {
        return this.approverName;
    }

    public void setApproverName(String approverName) {
        this.approverName = approverName;
    }

    public String getApproverDepartment() {
        return this.approverDepartment;
    }

    public void setApproverDepartment(String approverDepartment) {
        this.approverDepartment = approverDepartment;
    }

    public String getApproverDesignation() {
        return this.approverDesignation;
    }

    public void setApproverDesignation(String approverDesignation) {
        this.approverDesignation = approverDesignation;
    }

    public Long getApproverPositionId() {
        return this.approverPositionId;
    }

    public void setApproverPositionId(Long approverPositionId) {
        this.approverPositionId = approverPositionId;
    }

    public String getWorkFlowAction() {
        return this.workFlowAction;
    }

    public void setAdditionalRule(String additionalRule) {
        this.additionalRule = additionalRule;
    }

    public void setAmountRule(BigDecimal amountRule) {
        this.amountRule = amountRule;
    }

    public void setWorkFlowDepartment(String workFlowDepartment) {
        this.workFlowDepartment = workFlowDepartment;
    }

    public void setPendingActions(String pendingActions) {
        this.pendingActions = pendingActions;
    }
}

