/*
 * Decompiled with CFR 0.152.
 */
package org.egov.eis.entity;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.text.SimpleDateFormat;
import org.egov.eis.entity.Employee;

public class EmployeeAdaptor
implements JsonSerializer<Employee> {
    private int sl = 1;

    public JsonElement serialize(Employee employee, Type type, JsonSerializationContext jsc) {
        JsonObject jsonObject = new JsonObject();
        SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");
        jsonObject.addProperty("slno", (Number)this.sl++);
        jsonObject.addProperty("name", employee.getName());
        jsonObject.addProperty("code", employee.getCode());
        jsonObject.addProperty("department", employee.getAssignments().isEmpty() ? "" : employee.getAssignments().get(0).getDepartment().getName());
        jsonObject.addProperty("designation", employee.getAssignments().isEmpty() ? "" : employee.getAssignments().get(0).getDesignation().getName());
        jsonObject.addProperty("position", employee.getAssignments().isEmpty() ? "" : employee.getAssignments().get(0).getPosition().getName());
        jsonObject.addProperty("daterange", employee.getAssignments().isEmpty() ? "" : formatter.format(employee.getAssignments().get(0).getFromDate()) + " - " + formatter.format(employee.getAssignments().get(0).getToDate()));
        return jsonObject;
    }
}

