/*
 * Decompiled with CFR 0.152.
 */
package org.egov.eis.service;

import org.egov.builder.entities.DepartmentBuilder;
import org.egov.eis.entity.DeptDesigBuilder;
import org.egov.eis.entity.DesignationBuilder;
import org.egov.eis.repository.DeptDesigRepository;
import org.egov.eis.service.DeptDesigService;
import org.egov.infra.admin.master.entity.Department;
import org.egov.pims.commons.DeptDesig;
import org.egov.pims.commons.Designation;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@Ignore
public class DeptDesigServiceTest {
    @Mock
    private DeptDesigRepository deptDesigRepository;
    private DeptDesigService deptDesigService;
    Designation designation;
    Department department;
    DeptDesig deptDesig;

    @Before
    public void before() {
        MockitoAnnotations.initMocks((Object)this);
        this.deptDesigService = new DeptDesigService(this.deptDesigRepository);
        this.sampleDeptDesig();
    }

    private void sampleDeptDesig() {
        this.designation = new DesignationBuilder().withName("test-desig").withId(1L).build();
        this.department = new DepartmentBuilder().withName("test-dept").withCode("test-code").withId(Long.valueOf(1L)).build();
        this.deptDesig = new DeptDesigBuilder().withDesignation(this.designation).withDepartment(this.department).withSanctionedPosts(5).withOutsourcedPosts(2).build();
        this.deptDesigService.create(this.deptDesig);
    }

    @Test
    public void createDeptDesig() {
        Assert.assertNotNull((Object)this.deptDesig);
    }

    @Test
    public void getByDeptAndDesig() {
        Mockito.when((Object)this.deptDesigRepository.findByDepartment_IdAndDesignation_Id(this.department.getId(), this.designation.getId())).thenReturn((Object)this.deptDesig);
        Integer sancPosts = this.deptDesigService.findByDepartmentAndDesignation(this.department.getId(), this.designation.getId()).getSanctionedPosts();
        Assert.assertEquals((Object)sancPosts, (Object)5);
    }
}

