/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pims.commons.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.log4j.Logger;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.admin.master.service.UserService;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.pims.commons.Designation;
import org.egov.pims.commons.Position;
import org.egov.pims.commons.dao.PositionMasterDAO;
import org.egov.pims.commons.service.EisCommonsService;
import org.egov.pims.dao.PersonalInformationHibernateDAO;
import org.egov.pims.model.PersonalInformation;
import org.egov.pims.utils.EisManagersUtill;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.type.IntegerType;
import org.hibernate.type.Type;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="eisCommonsService")
public class EisCommonsServiceImpl
implements EisCommonsService {
    private static final Logger logger = Logger.getLogger(EisCommonsServiceImpl.class);
    @Autowired
    private UserService userService;
    @Autowired
    private PositionMasterDAO positionMasterDAO;
    @Autowired
    private PersonalInformationHibernateDAO pimsDao;
    @Autowired
    private AppConfigValueService appConfigValuesService;
    @PersistenceContext
    private EntityManager entityManager;
    private static final String STR_EXCEPTION = "Exception:";

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    @Override
    public void updatePosition(Position position) {
        try {
            this.positionMasterDAO.updatePosition(position);
        }
        catch (Exception e) {
            throw new ApplicationRuntimeException("Exception in deleting Installment." + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public Position getPositionById(Integer positionId) {
        Position pos = null;
        logger.info((Object)("InsidegetPositionById :  positionId=" + positionId));
        try {
            if (positionId != null) {
                pos = this.positionMasterDAO.getPosition(positionId);
            }
            return pos;
        }
        catch (Exception e) {
            throw new ApplicationRuntimeException("Exception in deleting Installment." + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public Position getPositionByUserId(Long userId) {
        Position userPosition = null;
        Date currentDate = new Date();
        try {
            String mainStr = "";
            mainStr = " select POS_ID from EG_EIS_EMPLOYEEINFO ev where ev.USER_ID = :userid and ((ev.to_Date is null and ev.from_Date <= :thisDate )  OR (ev.from_Date <= :thisDate AND ev.to_Date >= :thisDate)) and ev.IS_PRIMARY ='Y'";
            SQLQuery qry = this.getCurrentSession().createSQLQuery(mainStr).addScalar("POS_ID", (Type)IntegerType.INSTANCE);
            qry.setLong("userid", userId.longValue());
            qry.setDate("thisDate", currentDate);
            List retList = qry.list();
            if (retList != null && !retList.isEmpty()) {
                Integer posId2 = null;
                for (Integer posId2 : retList) {
                }
                if (posId2 != null) {
                    userPosition = this.getPositionById(posId2);
                }
            }
        }
        catch (HibernateException he) {
            throw new ApplicationRuntimeException(STR_EXCEPTION + he.getMessage(), (Throwable)he);
        }
        catch (Exception he) {
            throw new ApplicationRuntimeException(STR_EXCEPTION + he.getMessage(), (Throwable)he);
        }
        return userPosition;
    }

    @Override
    public Position getPositionForUserByIdAndDate(Integer userId, Date assignDate) {
        Position userPosition = null;
        try {
            String mainStr = "";
            mainStr = " select POS_ID from EG_EIS_EMPLOYEEINFO ev where ev.USER_ID = :userid and ((ev.to_Date is null and ev.from_Date <= :thisDate ) OR (ev.from_Date <= :thisDate AND ev.to_Date > :thisDate))";
            SQLQuery qry = this.getCurrentSession().createSQLQuery(mainStr).addScalar("POS_ID", (Type)IntegerType.INSTANCE);
            qry.setInteger("userid", userId.intValue());
            qry.setDate("thisDate", assignDate);
            List retList = qry.list();
            if (retList != null && !retList.isEmpty()) {
                Integer posId2 = null;
                for (Integer posId2 : retList) {
                }
                if (posId2 != null) {
                    userPosition = this.getPositionById(posId2);
                }
            }
        }
        catch (HibernateException he) {
            throw new ApplicationRuntimeException(STR_EXCEPTION + he.getMessage(), (Throwable)he);
        }
        catch (Exception he) {
            throw new ApplicationRuntimeException(STR_EXCEPTION + he.getMessage(), (Throwable)he);
        }
        return userPosition;
    }

    @Override
    public User getUserforPosition(Position pos) {
        User uerImpl = null;
        try {
            String mainStr = "";
            mainStr = " select \tUSER_ID  from EG_EIS_EMPLOYEEINFO ev  where ev.POS_ID = :pos and ((ev.to_Date is null and ev.from_Date <= SYSDATE ) OR (ev.from_Date <= SYSDATE AND ev.to_Date > SYSDATE))";
            SQLQuery qry = this.getCurrentSession().createSQLQuery(mainStr).addScalar("USER_ID", (Type)IntegerType.INSTANCE);
            if (pos != null) {
                qry.setEntity("pos", (Object)pos);
            }
            if (qry.list() != null && !qry.list().isEmpty()) {
                for (Long userId : qry.list()) {
                    uerImpl = this.userService.getUserById(userId);
                }
            }
        }
        catch (HibernateException he) {
            throw new ApplicationRuntimeException(STR_EXCEPTION + he.getMessage(), (Throwable)he);
        }
        catch (Exception he) {
            throw new ApplicationRuntimeException(STR_EXCEPTION + he.getMessage(), (Throwable)he);
        }
        return uerImpl;
    }

    @Override
    public Boolean isEmployeeAutoGenerateCodeYesOrNo() {
        String employeeAutoGenCodeYesOrNo = this.appConfigValuesService.getAppConfigValue("Employee", "EMPAUTOGENERATECODE", "no");
        boolean autoGenCode = false;
        if ("yes".equalsIgnoreCase(employeeAutoGenCodeYesOrNo)) {
            autoGenCode = true;
        }
        return autoGenCode;
    }

    @Override
    public Boolean checkEmpCode(String empCode) {
        boolean checkEmpCode = false;
        Query qry = null;
        try {
            String main = "from PersonalInformation where employeeCode=:employeeCode";
            qry = this.getCurrentSession().createQuery(main);
            qry.setString("employeeCode", empCode);
            if (qry.list() != null && !qry.list().isEmpty()) {
                checkEmpCode = true;
            }
        }
        catch (HibernateException he) {
            throw new ApplicationRuntimeException(STR_EXCEPTION + he.getMessage(), (Throwable)he);
        }
        catch (Exception he) {
            throw new ApplicationRuntimeException(STR_EXCEPTION + he.getMessage(), (Throwable)he);
        }
        return checkEmpCode;
    }

    @Override
    public Position getPositionByName(String positionName) {
        Query qry = null;
        try {
            String main = "from Position where name=:positionName";
            qry = this.getCurrentSession().createQuery(main);
            if (positionName != null && !positionName.equals("")) {
                qry.setString("positionName", positionName);
            }
            return (Position)qry.uniqueResult();
        }
        catch (HibernateException he) {
            throw new ApplicationRuntimeException(STR_EXCEPTION + he.getMessage(), (Throwable)he);
        }
        catch (Exception he) {
            throw new ApplicationRuntimeException(STR_EXCEPTION + he.getMessage(), (Throwable)he);
        }
    }

    @Override
    public Position getCurrentPositionByUser(User user) {
        Position position = null;
        try {
            if (null != user) {
                PersonalInformation personalInfo = EisManagersUtill.getEmployeeService().getEmpForUserId(user.getId());
                position = EisManagersUtill.getEmployeeService().getPositionforEmp(personalInfo.getIdPersonalInformation());
            }
        }
        catch (Exception e) {
            throw new ApplicationRuntimeException("Exception in getCurrentPositionByUser :" + e.getMessage(), (Throwable)e);
        }
        return position;
    }

    @Override
    public User getUserForPosition(Integer posId, Date date) {
        User user = null;
        try {
            String mainStr = "";
            mainStr = " select USER_ID from EG_EIS_EMPLOYEEINFO ev where ev.pos_id = :posId and ((ev.to_Date is null and ev.from_Date <= :thisDate ) OR (ev.from_Date <= :thisDate AND ev.to_Date > :thisDate))";
            SQLQuery qry = this.getCurrentSession().createSQLQuery(mainStr).addScalar("USER_ID", (Type)IntegerType.INSTANCE);
            qry.setInteger("posId", posId.intValue());
            qry.setDate("thisDate", date);
            List retList = qry.list();
            if (retList != null && !retList.isEmpty()) {
                Long userId2 = null;
                for (Long userId2 : retList) {
                }
                if (userId2 != null) {
                    user = this.userService.getUserById(userId2);
                }
            }
        }
        catch (HibernateException he) {
            throw new ApplicationRuntimeException(STR_EXCEPTION + he.getMessage(), (Throwable)he);
        }
        catch (Exception he) {
            throw new ApplicationRuntimeException(STR_EXCEPTION + he.getMessage(), (Throwable)he);
        }
        return user;
    }

    @Override
    public List<Designation> getDesigantionBasedOnFuncDept(Integer deptId, Integer functionaryId) throws Exception {
        Object employeeList = null;
        ArrayList<Designation> desgMstr = new ArrayList();
        try {
            String mainStr = "";
            String subQry = " from EmployeeView ev ";
            if (deptId != null && deptId != 0 && functionaryId == 0) {
                subQry = subQry + " where ev.deptId = :deptId ";
            } else if (functionaryId != null && functionaryId != 0 && deptId == 0) {
                subQry = subQry + " where ev.functionary =:functionaryId";
            } else if (deptId != null && deptId != 0 && functionaryId != null && functionaryId != 0) {
                subQry = subQry + " where ev.deptId = :deptId and ev.functionary =:functionaryId";
            }
            subQry = "select distinct ev.desigId.designationId " + subQry;
            mainStr = "from Designation dm   where dm.id in( " + subQry + "  ) ";
            Query query = this.getCurrentSession().createQuery(mainStr);
            if (deptId != null && deptId != 0) {
                query.setInteger("deptId", deptId.intValue());
            }
            if (functionaryId != null && functionaryId != 0) {
                query.setInteger("functionaryId", functionaryId.intValue());
            }
            desgMstr = query.list();
        }
        catch (Exception e) {
            throw new ApplicationRuntimeException(e.getMessage(), (Throwable)e);
        }
        return desgMstr;
    }

    @Override
    public PersonalInformation getTempAssignedEmployeeByDeptDesigFunctionaryDate(Integer deptId, Integer desigId, Integer functionaryId, Date onDate) throws Exception {
        return this.pimsDao.getTempAssignedEmployeeByDeptDesigFunctionaryDate(deptId, desigId, functionaryId, onDate);
    }
}

