/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pims.dao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.log4j.Logger;
import org.egov.commons.exception.NoSuchObjectException;
import org.egov.commons.exception.TooManyValuesException;
import org.egov.eis.entity.Jurisdiction;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.pims.dao.PersonalInformationDAO;
import org.egov.pims.model.PersonalInformation;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class PersonalInformationHibernateDAO
implements PersonalInformationDAO {
    private static final Logger LOGGER = Logger.getLogger(PersonalInformationHibernateDAO.class);
    private static final String STR_CURRDATE = "currDate";
    @Autowired
    private BoundaryService boundaryService;
    @PersistenceContext
    private EntityManager entityManager;

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    @Override
    public PersonalInformation getPersonalInformationByID(Integer idPersonalInformation) {
        Query qry = this.getCurrentSession().createQuery("from PersonalInformation P where P.idPersonalInformation =:idPersonalInformation ");
        qry.setInteger("idPersonalInformation", idPersonalInformation.intValue());
        return (PersonalInformation)qry.uniqueResult();
    }

    @Override
    public Map getAllPIMap() {
        try {
            Query qry = this.getCurrentSession().createQuery("from PersonalInformation P order by P.idPersonalInformation");
            LinkedHashMap<Integer, String> retMap = new LinkedHashMap<Integer, String>();
            Iterator iter = qry.iterate();
            while (iter.hasNext()) {
                PersonalInformation egpimsPersonalInformation = (PersonalInformation)iter.next();
                retMap.put(egpimsPersonalInformation.getIdPersonalInformation(), egpimsPersonalInformation.getEmployeeCode());
            }
            return retMap;
        }
        catch (Exception e) {
            throw new ApplicationRuntimeException("Hibernate Exception : " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public PersonalInformation getPersonalInformationByUserId(Long userId) {
        Query qry = this.getCurrentSession().createQuery("from PersonalInformation P where P.userMaster.id =:userId ");
        qry.setLong("userId", userId.longValue());
        return (PersonalInformation)qry.uniqueResult();
    }

    @Override
    public void deleteLangKnownForEmp(PersonalInformation personalInformation) {
        SQLQuery qry = this.getCurrentSession().createSQLQuery("delete  from EGEIS_LANG_KNOWN B where B.id = :id ");
        qry.setInteger("id", personalInformation.getIdPersonalInformation().intValue());
    }

    @Override
    public List getListOfPersonalInformationByEmpIdsList(List empIdsList) {
        List list = null;
        if (empIdsList != null && !empIdsList.isEmpty()) {
            Query qry = this.getCurrentSession().createQuery("from PersonalInformation per where per.idPersonalInformation in (:empIdsList) order by per.employeeCode");
            if (empIdsList.size() <= 1000) {
                qry.setParameterList("empIdsList", (Collection)empIdsList);
                list = qry.list();
                return list;
            }
            int noOfSublists = empIdsList.size() / 1000;
            int remainingItems = empIdsList.size() % 1000;
            int initialVal = 0;
            ArrayList listFinal = new ArrayList();
            for (int i = 1; i <= noOfSublists; ++i) {
                qry.setParameterList("empIdsList", empIdsList.subList(initialVal, i * 1000));
                list = qry.list();
                listFinal.addAll(list);
                initialVal = i * 1000;
            }
            qry.setParameterList("empIdsList", empIdsList.subList(initialVal, initialVal + remainingItems));
            list = qry.list();
            listFinal.addAll(list);
            return listFinal;
        }
        return list;
    }

    public List getListOfUsersByBoundaryId(Long boundaryId) throws NoSuchObjectException {
        ArrayList userObjList = new ArrayList();
        List bndryObjList = this.boundaryService.getParentBoundariesByBoundaryId(boundaryId);
        Date currDate = new Date();
        if (!bndryObjList.isEmpty()) {
            Query qry = this.getCurrentSession().createQuery("select J FROM JurisdictionValues JurVal, Jurisdiction J  where JurVal.boundary in (:bndryObjList) and JurVal.userJurLevel.id=J.id and JurVal.isHistory='N' and J.user.active=true and ((JurVal.toDate IS NULL and JurVal.fromDate <= :currDate) OR (JurVal.fromDate <= :currDate and JurVal.toDate >= :currDate)) ");
            qry.setParameterList("bndryObjList", (Collection)bndryObjList);
            qry.setDate(STR_CURRDATE, currDate);
            Iterator iter = qry.iterate();
            while (iter.hasNext()) {
                Jurisdiction jurisdiction = (Jurisdiction)((Object)iter.next());
            }
        }
        return userObjList;
    }

    @Override
    public List getListOfUsersForGivenBoundaryId(Long boundaryId) throws NoSuchObjectException {
        ArrayList userObjList = new ArrayList();
        List<Boundary> bndryObjList = new ArrayList();
        bndryObjList = this.boundaryService.getChildBoundariesByBoundaryId(boundaryId);
        Boundary bnd = this.boundaryService.getBoundaryById(boundaryId);
        if (bnd != null) {
            bndryObjList.add(bnd);
        }
        Date currDate = new Date();
        if (!bndryObjList.isEmpty()) {
            Query qry = this.getCurrentSession().createQuery("select J FROM JurisdictionValues JurVal, Jurisdiction J  where JurVal.boundary in (:bndryObjList) and JurVal.userJurLevel.id=J.id and JurVal.isHistory='N' and J.user.active=true and ((JurVal.toDate IS NULL and JurVal.fromDate <= :currDate) OR (JurVal.fromDate <= :currDate and JurVal.toDate >= :currDate)) ");
            qry.setParameterList("bndryObjList", bndryObjList);
            qry.setDate(STR_CURRDATE, currDate);
            Iterator iter = qry.iterate();
            while (iter.hasNext()) {
                Jurisdiction jurisdiction = (Jurisdiction)((Object)iter.next());
            }
        }
        return userObjList;
    }

    @Override
    public PersonalInformation getEmployee(Integer deptId, Integer designationId, Long boundaryId) throws TooManyValuesException, NoSuchObjectException {
        PersonalInformation personalInformation = null;
        Query qry1 = null;
        try {
            List userList = new ArrayList();
            Date currDate = new Date();
            if (boundaryId != null && boundaryId != 0L) {
                userList = this.getListOfUsersByBoundaryId(boundaryId);
            }
            if (userList.isEmpty()) {
                throw new NoSuchObjectException("user.Obj.null");
            }
            qry1 = this.getCurrentSession().createQuery("select P from PersonalInformation P, Assignment A where P.idPersonalInformation=A.employee.idPersonalInformation and  A.deptId.id=:deptId and A.desigId.designationId=:designationId and  A.isPrimary = 'N' and  P.userMaster in (:userObjList) and ((A.toDate IS NULL and A.fromDate <= :currDate) OR (A.fromDate <= :currDate and A.toDate >= :currDate))");
            qry1.setInteger("deptId", deptId.intValue());
            qry1.setInteger("designationId", designationId.intValue());
            qry1.setParameterList("userObjList", userList);
            qry1.setDate(STR_CURRDATE, currDate);
            List empList = qry1.list();
            if (empList.size() == 0) {
                qry1 = this.getCurrentSession().createQuery("select P from PersonalInformation P, Assignment A where P.idPersonalInformation=A.employee.idPersonalInformation and  A.deptId.id=:deptId and A.desigId.designationId=:designationId and  A.isPrimary = 'Y' and  P.userMaster in (:userObjList) and ((A.toDate IS NULL and A.fromDate <= :currDate) OR (A.fromDate <= :currDate and A.toDate >= :currDate))");
                qry1.setInteger("deptId", deptId.intValue());
                qry1.setInteger("designationId", designationId.intValue());
                qry1.setParameterList("userObjList", userList);
                qry1.setDate(STR_CURRDATE, currDate);
                empList = qry1.list();
                if (empList.isEmpty()) {
                    throw new NoSuchObjectException("personalinformation.object.notFound");
                }
                if (empList.size() > 1) {
                    throw new TooManyValuesException("personalinformation.object.Foundmorethanone");
                }
                if (empList.size() == 1) {
                    personalInformation = (PersonalInformation)empList.get(0);
                }
            } else {
                if (empList.size() > 1) {
                    throw new TooManyValuesException("tempAssigned.personalinformation.object.Foundmorethanone");
                }
                if (empList.size() == 1) {
                    personalInformation = (PersonalInformation)empList.get(0);
                }
            }
            return personalInformation;
        }
        catch (Exception e) {
            throw new ApplicationRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public PersonalInformation getEmployeeByFunctionary(Long deptId, Long designationId, Long boundaryId, Integer functionaryId) throws TooManyValuesException, NoSuchObjectException {
        PersonalInformation personalInformation = null;
        Query qry1 = null;
        try {
            List userList = new ArrayList();
            Date currDate = new Date();
            if (boundaryId != null && boundaryId != 0L) {
                userList = this.getListOfUsersByBoundaryId(boundaryId);
            }
            if (userList.isEmpty()) {
                throw new NoSuchObjectException("user.Obj.null");
            }
            qry1 = this.getCurrentSession().createQuery("select P from PersonalInformation P, Assignment A where P.idPersonalInformation=A.employee.idPersonalInformation and  A.deptId.id=:deptId and A.desigId.designationId=:designationId and A.functionary.id=:functionaryId and  A.isPrimary = 'N' and  P.userMaster in (:userObjList) and ((A.toDate IS NULL and A.fromDate <= :currDate) OR (A.fromDate <= :currDate and A.toDate >= :currDate))");
            qry1.setLong("deptId", deptId.longValue());
            qry1.setLong("designationId", designationId.longValue());
            qry1.setInteger("functionaryId", functionaryId.intValue());
            qry1.setParameterList("userObjList", userList);
            qry1.setDate(STR_CURRDATE, currDate);
            List empList = qry1.list();
            if (empList.size() == 0) {
                qry1 = this.getCurrentSession().createQuery("select P from PersonalInformation P, Assignment A where P.idPersonalInformation=A.employee.idPersonalInformation and  A.deptId.id=:deptId and A.desigId.designationId=:designationId and A.functionary.id=:functionaryId and  A.isPrimary = 'Y' and  P.userMaster in (:userObjList) and ((A.toDate IS NULL and A.fromDate <= :currDate) OR (A.fromDate <= :currDate and A.toDate >= :currDate))");
                qry1.setLong("deptId", deptId.longValue());
                qry1.setLong("designationId", designationId.longValue());
                qry1.setInteger("functionaryId", functionaryId.intValue());
                qry1.setParameterList("userObjList", userList);
                qry1.setDate(STR_CURRDATE, currDate);
                empList = qry1.list();
                if (empList.size() == 0) {
                    throw new NoSuchObjectException("personalinformation.object.notFound");
                }
                if (empList.size() > 1) {
                    throw new TooManyValuesException("personalinformation.object.Foundmorethanone");
                }
                if (empList.size() == 1) {
                    personalInformation = (PersonalInformation)empList.get(0);
                }
            } else {
                if (empList.size() > 1) {
                    throw new TooManyValuesException("personalinformation.object.Foundmorethanone");
                }
                if (empList.size() == 1) {
                    personalInformation = (PersonalInformation)empList.get(0);
                }
            }
            return personalInformation;
        }
        catch (Exception e) {
            throw new ApplicationRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public PersonalInformation getTempAssignedEmployeeByDeptDesigFunctionaryDate(Integer deptId, Integer desigId, Integer functionaryId, Date onDate) throws Exception {
        PersonalInformation tempAssignedEemployee = null;
        LOGGER.info((Object)"Inside temp assigned emp API-----------");
        List listEmployee = null;
        Query qry = this.getCurrentSession().createQuery("select A.employee from Assignment A where A.deptId.id=:deptId and A.desigId.designationId=:desigId and A.functionary.id=:functionaryId and A.isPrimary = 'N' and ((A.toDate IS NULL and A.fromDate <= :onDate) OR (A.fromDate <= :onDate and A.toDate >= :onDate))");
        qry.setInteger("deptId", deptId.intValue());
        qry.setInteger("desigId", desigId.intValue());
        qry.setInteger("functionaryId", functionaryId.intValue());
        qry.setDate("onDate", onDate);
        LOGGER.info((Object)("Inside temp assigned emp API query-----------" + qry.getQueryString()));
        listEmployee = qry.list();
        if (listEmployee.size() == 0) {
            throw new NoSuchObjectException("tempAssigned.personalinformation.object.notFound");
        }
        if (listEmployee.size() > 1) {
            throw new TooManyValuesException("tempAssigned.personalinformation.object.Foundmorethanone");
        }
        if (listEmployee.size() == 1) {
            tempAssignedEemployee = (PersonalInformation)listEmployee.get(0);
        }
        return tempAssignedEemployee;
    }

    @Override
    public List getAllDesignationByDept(Integer deptId) throws TooManyValuesException, NoSuchObjectException {
        List desgMstr = null;
        try {
            Query qry = this.getCurrentSession().createQuery("from Designation dm where dm.deptId =:deptId");
            qry.setInteger("deptId", deptId.intValue());
            LOGGER.info((Object)("QUERY TEST-----------" + qry.getQueryString()));
            desgMstr = qry.list();
        }
        catch (Exception e) {
            throw new ApplicationRuntimeException("system.error", (Throwable)e);
        }
        return desgMstr;
    }

    @Override
    public List getAllActiveUsersByGivenDesg(Integer desgId) {
        List userList = null;
        try {
            Query qry = this.getCurrentSession().createQuery("from User u where u.id in (select ev.userMaster.id from EmployeeView ev where ev.desigId.designationId =:desgId) and u.active=true ");
            qry.setInteger("desgId", desgId.intValue());
            userList = qry.list();
        }
        catch (RuntimeException e) {
            throw new ApplicationRuntimeException("Exception while getting users for given designation", (Throwable)e);
        }
        return userList;
    }

    @Override
    public List<PersonalInformation> getAllEmpByGrade(Integer gradeId) throws Exception {
        List listEmployee = null;
        Query qry = this.getCurrentSession().createQuery("select distinct A.employee from Assignment A where A.gradeId.id=:gradeId ");
        qry.setInteger("gradeId", gradeId.intValue());
        listEmployee = qry.list();
        return listEmployee;
    }

    @Override
    public List getListOfUsersNotMappedToEmp() {
        Query qry = this.getCurrentSession().createQuery("from User UI where id not in(select userMaster.id from PersonalInformation  where  userMaster.id is not null) order by UI.userName");
        return qry.list();
    }

    @Override
    @Transactional
    public void create(PersonalInformation egpimsPersonalInformation) {
        this.getCurrentSession().save((Object)egpimsPersonalInformation);
    }

    @Override
    @Transactional
    public void update(PersonalInformation egpimsPersonalInformation) {
        this.getCurrentSession().update((Object)egpimsPersonalInformation);
    }
}

