/*
 * Decompiled with CFR 0.152.
 */
package org.egov.eis.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.lang3.StringUtils;
import org.egov.commons.CFunction;
import org.egov.commons.Functionary;
import org.egov.commons.Fund;
import org.egov.commons.service.EntityTypeService;
import org.egov.commons.utils.EntityType;
import org.egov.eis.entity.Assignment;
import org.egov.eis.entity.Employee;
import org.egov.eis.entity.EmployeeSearchDTO;
import org.egov.eis.entity.HeadOfDepartments;
import org.egov.eis.entity.Jurisdiction;
import org.egov.eis.entity.enums.EmployeeStatus;
import org.egov.eis.repository.AssignmentRepository;
import org.egov.eis.repository.EmployeeRepository;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.service.DesignationService;
import org.egov.eis.service.PositionMasterService;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.entity.Role;
import org.egov.infra.admin.master.repository.UserRepository;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.admin.master.service.RoleService;
import org.egov.infra.admin.master.service.UserService;
import org.egov.infra.config.properties.ApplicationProperties;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.workflow.service.StateHistoryService;
import org.egov.infra.workflow.service.StateService;
import org.egov.pims.commons.Designation;
import org.egov.pims.commons.Position;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.CriteriaSpecification;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class EmployeeService
implements EntityTypeService {
    private final EmployeeRepository employeeRepository;
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private AssignmentRepository assignmentRepository;
    @Autowired
    private PasswordEncoder passwordEncoder;
    @Autowired
    private ApplicationProperties applicationProperties;
    @Autowired
    private BoundaryService boundaryService;
    @Autowired
    private UserService userService;
    @Autowired
    private DesignationService designationService;
    @Autowired
    private AssignmentService assignmentService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private StateService stateService;
    @Autowired
    private StateHistoryService stateHistoryService;
    @Autowired
    private PositionMasterService positionMasterService;

    @Autowired
    public EmployeeService(EmployeeRepository employeeRepository) {
        this.employeeRepository = employeeRepository;
    }

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    public List<CFunction> getAllFunctions() {
        return this.getCurrentSession().createQuery("from CFunction where isactive = true AND isnotleaf=false order by upper(name)").list();
    }

    public List<Functionary> getAllFunctionaries() {
        return this.getCurrentSession().createQuery("from Functionary where isactive=true order by upper(name)").list();
    }

    public List<Fund> getAllFunds() {
        return this.getCurrentSession().createQuery("from Fund where isactive = true and isNotLeaf!=true order by upper(name)").list();
    }

    public List<Fund> getAllGrades() {
        return this.getCurrentSession().createQuery("from GradeMaster order by name").list();
    }

    public List<EntityType> getAllActiveEntities(Integer employeeId) {
        ArrayList<EntityType> entities = new ArrayList<EntityType>();
        List<Employee> employees = this.getAllEmployees();
        entities.addAll(employees);
        return entities;
    }

    @Transactional
    public void create(Employee employee) {
        employee.updateNextPwdExpiryDate(this.applicationProperties.userPasswordExpiryInDays());
        employee.setPassword(this.passwordEncoder.encode((CharSequence)"12345678"));
        List user = new ArrayList();
        employee.setAssignments(employee.getAssignments().parallelStream().filter(assignment -> assignment.getPosition() != null).collect(Collectors.toList()));
        for (Assignment assign : employee.getAssignments()) {
            assign.setEmployee(employee);
            assign.setDepartment(assign.getDepartment());
            Set<Role> roles = this.designationService.getRolesByDesignation(assign.getDesignation().getName());
            for (Role role : roles) {
                user = this.userService.getUsersByUsernameAndRolename(employee.getUsername(), this.roleService.getRoleByName(role.getName()).getName());
                if (!assign.getFromDate().before(new Date()) || !assign.getToDate().after(new Date()) || !user.isEmpty() && user != null) continue;
                employee.addRole(this.roleService.getRoleByName(role.getName()));
            }
            for (HeadOfDepartments hod : assign.getDeptSet()) {
                hod.setAssignment(assign);
            }
        }
        employee.setJurisdictions(employee.getJurisdictions().parallelStream().filter(Jurisdictions -> Jurisdictions.getBoundaryType() != null && Jurisdictions.getBoundary() != null).collect(Collectors.toList()));
        for (Jurisdiction jurisdiction : employee.getJurisdictions()) {
            jurisdiction.setEmployee(employee);
            jurisdiction.setBoundaryType(jurisdiction.getBoundaryType());
            jurisdiction.setBoundary(jurisdiction.getBoundary());
        }
        employee.getRoles().add(this.roleService.getRoleByName("Employee"));
        this.employeeRepository.save((Object)employee);
    }

    @Transactional
    public void createEmployeeData(Employee employee) {
        employee.updateNextPwdExpiryDate(this.applicationProperties.userPasswordExpiryInDays());
        employee.setPassword(this.passwordEncoder.encode((CharSequence)"12345678"));
        employee.getRoles().add(this.roleService.getRoleByName("Employee"));
        this.employeeRepository.save((Object)employee);
    }

    @Transactional
    public void update(Employee employee) {
        for (Assignment assign : employee.getAssignments()) {
            assign.setEmployee(employee);
            assign.setDepartment(assign.getDepartment());
            for (HeadOfDepartments hod : assign.getDeptSet()) {
                hod.setAssignment(assign);
            }
        }
        for (Jurisdiction jurisdiction : employee.getJurisdictions()) {
            jurisdiction.setEmployee(employee);
            jurisdiction.setBoundaryType(jurisdiction.getBoundaryType());
            jurisdiction.setBoundary(jurisdiction.getBoundary());
        }
        this.employeeRepository.saveAndFlush((Object)employee);
    }

    @Transactional
    public void addOrRemoveUserRole() {
        List<Employee> employee = this.getAllEmployees();
        for (Employee emp : employee) {
            Set userRole = this.userService.getRolesByUsername(emp.getUsername());
            Set<Role> expiredRoleList = this.assignmentService.getRolesForExpiredAssignmentsByEmpId(emp.getId());
            Set<Role> activeRoleList = this.assignmentService.getRolesForActiveAssignmentsByEmpId(emp.getId());
            expiredRoleList.removeAll(activeRoleList);
            userRole.removeAll(expiredRoleList);
            userRole.addAll(activeRoleList);
            emp.setRoles(userRole);
            this.employeeRepository.save((Object)emp);
        }
    }

    public List<Employee> searchEmployees(EmployeeSearchDTO searchParams) {
        Criteria criteria = this.getCurrentSession().createCriteria(Assignment.class, "assignment").createAlias("assignment.employee", "employee");
        if (null != searchParams.getCode() && !searchParams.getCode().isEmpty()) {
            criteria.add((Criterion)Restrictions.eq((String)"employee.code", (Object)searchParams.getCode()));
        }
        if (null != searchParams.getName() && !searchParams.getName().isEmpty()) {
            criteria.add((Criterion)Restrictions.eq((String)"employee.name", (Object)searchParams.getName()));
        }
        if (null != searchParams.getAadhaar() && !searchParams.getAadhaar().isEmpty()) {
            criteria.add((Criterion)Restrictions.eq((String)"employee.aadhaar", (Object)searchParams.getAadhaar()));
        }
        if (null != searchParams.getMobileNumber() && !searchParams.getMobileNumber().isEmpty()) {
            criteria.add((Criterion)Restrictions.eq((String)"employee.mobileNumber", (Object)searchParams.getMobileNumber()));
        }
        if (null != searchParams.getPan() && !searchParams.getPan().isEmpty()) {
            criteria.add((Criterion)Restrictions.eq((String)"employee.pan", (Object)searchParams.getPan()));
        }
        if (null != searchParams.getEmail() && !searchParams.getEmail().isEmpty()) {
            criteria.add((Criterion)Restrictions.eq((String)"employee.emailId", (Object)searchParams.getEmail()));
        }
        if (null != searchParams.getStatus() && !searchParams.getStatus().isEmpty()) {
            criteria.add((Criterion)Restrictions.eq((String)"employee.employeeStatus", (Object)((Object)EmployeeStatus.valueOf(searchParams.getStatus()))));
        }
        if (null != searchParams.getEmployeeType() && !searchParams.getEmployeeType().isEmpty()) {
            criteria.createAlias("employee.employeeType", "employeeType");
            criteria.add((Criterion)Restrictions.eq((String)"employeeType.name", (Object)searchParams.getEmployeeType()));
        }
        if (null != searchParams.getDepartment() && !searchParams.getDepartment().isEmpty()) {
            criteria.createAlias("assignment.department", "department");
            criteria.add((Criterion)Restrictions.eq((String)"department.name", (Object)searchParams.getDepartment()));
        }
        if (null != searchParams.getDesignation() && !searchParams.getDesignation().isEmpty()) {
            criteria.createAlias("assignment.designation", "designation");
            criteria.add((Criterion)Restrictions.eq((String)"designation.name", (Object)searchParams.getDesignation()));
        }
        if (null != searchParams.getFunctionary() && !searchParams.getFunctionary().isEmpty()) {
            criteria.createAlias("assignment.functionary", "functionary");
            criteria.add((Criterion)Restrictions.eq((String)"functionary.name", (Object)searchParams.getFunctionary()));
        }
        if (null != searchParams.getFunction() && !searchParams.getFunction().isEmpty()) {
            criteria.createAlias("assignment.function", "function");
            criteria.add((Criterion)Restrictions.eq((String)"function.name", (Object)searchParams.getFunction()));
        }
        ProjectionList projections = Projections.projectionList().add((Projection)Projections.property((String)"assignment.employee"));
        criteria.setProjection((Projection)projections);
        criteria.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
        return criteria.list();
    }

    @Transactional
    public void delete(Employee employee) {
        this.employeeRepository.delete((Object)employee);
    }

    public Employee getEmployeeById(Long id) {
        return (Employee)((Object)this.employeeRepository.findOne(id));
    }

    public Employee getEmployeeByCode(String code) {
        return this.employeeRepository.findByCode(code);
    }

    public List<Employee> getEmployeesByStatus(EmployeeStatus status) {
        return this.employeeRepository.findByEmployeeStatus(status);
    }

    public List<Employee> getEmployeesByType(Long id) {
        return this.employeeRepository.findByEmployeeType_Id(id);
    }

    public Employee getEmployeeByUserName(String userName) {
        return this.employeeRepository.findByUsername(userName);
    }

    public List<Employee> findByDepartmentDesignationAndBoundary(Long deptId, Long desigId, Long boundaryId) {
        HashSet<Long> bndIds = new HashSet<Long>();
        List boundaries = this.boundaryService.findActiveChildrenWithParent(boundaryId);
        boundaries.forEach(bndry -> bndIds.add(bndry.getId()));
        return this.employeeRepository.findByDepartmentDesignationAndBoundary(deptId, desigId, bndIds);
    }

    public List<Employee> getEmployeesForPosition(Long posId) {
        HashSet<Employee> employees = new HashSet<Employee>();
        List<Assignment> assignList = this.assignmentRepository.getAssignmentsForPosition(posId);
        for (Assignment assign : assignList) {
            employees.add(assign.getEmployee());
        }
        return new ArrayList<Employee>(employees);
    }

    public Employee getPrimaryAssignmentEmployeeForPos(Long posId) {
        return this.assignmentRepository.getPrimaryAssignmentForPosition(posId).getEmployee();
    }

    public Employee getEmployeeForPositionAndDate(Long posId, Date givenDate) {
        return this.assignmentRepository.getPrimaryAssignmentForPositionAndDate(posId, givenDate).getEmployee();
    }

    public List<Employee> getAllEmployees() {
        return this.employeeRepository.findAll();
    }

    public List<? extends EntityType> filterActiveEntities(String filterKey, int maxRecords, Integer accountDetailTypeId) {
        return this.employeeRepository.findByNameLikeOrCodeLike(filterKey + "%", filterKey + "%");
    }

    public List getAssetCodesForProjectCode(Integer accountdetailkey) throws ValidationException {
        return null;
    }

    public List<? extends EntityType> validateEntityForRTGS(List<Long> idsList) throws ValidationException {
        return null;
    }

    public List<? extends EntityType> getEntitiesById(List<Long> idsList) throws ValidationException {
        return null;
    }

    public String generateUserNameByDeptDesig(Department department, Designation designation) {
        String name = department.getCode() + designation.getCode();
        name = name + (this.userRepository.getUserSerialNumberByName(name) + 1);
        return name;
    }

    public List<Employee> findEmployeeByCodeLike(String code) {
        return this.employeeRepository.findEmployeeByCodeLike(code);
    }

    public List<Employee> findActiveEmployeeByCodeLike(String code) {
        return this.employeeRepository.findActiveEmployeeByCodeLike(code);
    }

    public String validatePosition(Employee employee, String removedassignIds) {
        boolean positionExistsInWF = false;
        boolean positionExistsInWFHistory = false;
        List<Position> updatedPositionList = this.positionMasterService.getPositionsForEmployee(employee.getId());
        if (StringUtils.isNotBlank((CharSequence)removedassignIds)) {
            String[] deletedAssignIds = removedassignIds.split(",");
            for (String assignId : deletedAssignIds) {
                Assignment assignment2 = this.assignmentService.getAssignmentById(Long.valueOf(assignId));
                if (assignment2 != null && !((Object)((Object)assignment2)).equals("")) {
                    positionExistsInWF = this.stateService.isPositionUnderWorkflow(assignment2.getPosition().getId());
                    positionExistsInWFHistory = this.stateHistoryService.isPositionUnderWorkflowHistory(assignment2.getPosition().getId());
                }
                if (!positionExistsInWF && !positionExistsInWFHistory) continue;
                return assignment2.getPosition().getName();
            }
        }
        this.assignmentService.removeDeletedAssignments(employee, removedassignIds);
        employee.setAssignments(employee.getAssignments().parallelStream().filter(assignment -> assignment.getPosition() != null).collect(Collectors.toList()));
        List user = new ArrayList();
        for (Assignment assign : employee.getAssignments()) {
            Set<Role> roles = this.designationService.getRolesByDesignation(assign.getDesignation().getName());
            for (Role role : roles) {
                user = this.userService.getUsersByUsernameAndRolename(employee.getUsername(), this.roleService.getRoleByName(role.getName()).getName());
                if (!assign.getFromDate().before(new Date()) || !assign.getToDate().after(new Date()) || !user.isEmpty()) continue;
                employee.addRole(this.roleService.getRoleByName(role.getName()));
            }
        }
        employee.setJurisdictions(employee.getJurisdictions().parallelStream().filter(Jurisdictions -> Jurisdictions.getBoundaryType() != null && Jurisdictions.getBoundary() != null).collect(Collectors.toList()));
        this.getCurrentSession().evict((Object)employee);
        Employee updatedEmployee = this.getEmployeeById(employee.getId());
        List<Position> oldPositionList = this.positionMasterService.getPositionsForEmployee(updatedEmployee.getId());
        oldPositionList.removeAll(updatedPositionList);
        for (Position position : oldPositionList) {
            positionExistsInWF = this.stateService.isPositionUnderWorkflow(position.getId());
            positionExistsInWFHistory = this.stateHistoryService.isPositionUnderWorkflowHistory(position.getId());
            if (!positionExistsInWF && !positionExistsInWFHistory) continue;
            return position.getName();
        }
        return "";
    }

    public Boolean validateEmployeeCode(Employee employee) {
        String employeeCode = employee.getCode().replaceFirst("^0+(?!$)", "");
        List<Employee> employeeList = this.findActiveEmployeeByCodeLike(employeeCode);
        if (!employeeList.isEmpty()) {
            for (Employee emp : employeeList) {
                String empCode = emp.getCode().replaceFirst("^0+(?!$)", "");
                if (emp.getCode().equals(employee.getCode()) || !employeeCode.equals(empCode) || emp.getId().equals(employee.getId())) continue;
                return true;
            }
        }
        return false;
    }
}

