/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pims.model;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.egov.commons.EgwStatus;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.pims.commons.Designation;
import org.egov.pims.commons.Position;

@Entity
@Table(name="EGEIS_POST_CREATION")
@SequenceGenerator(name="SEQ_EGEIS_POST_CREATION", sequenceName="SEQ_EGEIS_POST_CREATION", allocationSize=1)
public class EmpPosition
extends StateAware {
    public static final String SEQ_EMPPOSITION = "SEQ_EGEIS_POST_CREATION";
    private static final long serialVersionUID = 9220002621595085170L;
    @Id
    @GeneratedValue(generator="SEQ_EGEIS_POST_CREATION", strategy=GenerationType.SEQUENCE)
    private Long id;
    @NotNull(message="postname.required")
    @Column(name="POST_NAME", nullable=false)
    private String postName;
    @NotNull(message="desig.required")
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    @JoinColumn(name="DESIG_ID")
    private Designation desigId;
    @NotNull(message="dept.required")
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    @JoinColumn(name="DEPT_ID")
    private Department deptId;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="STATUS")
    private EgwStatus status;
    @Column(name="QUALIFY_DETAILS")
    private String qualificationDetails;
    private String remarks;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST})
    @JoinColumn(name="POSITION_ID")
    private Position position;

    public String getPostName() {
        return this.postName;
    }

    public void setPostName(String postName) {
        this.postName = postName;
    }

    public Designation getDesigId() {
        return this.desigId;
    }

    public void setDesigId(Designation desigId) {
        this.desigId = desigId;
    }

    public Department getDeptId() {
        return this.deptId;
    }

    public void setDeptId(Department deptId) {
        this.deptId = deptId;
    }

    public EgwStatus getStatus() {
        return this.status;
    }

    public void setStatus(EgwStatus status) {
        this.status = status;
    }

    public String getQualificationDetails() {
        return this.qualificationDetails;
    }

    public void setQualificationDetails(String qualificationDetails) {
        this.qualificationDetails = qualificationDetails;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public Position getPosition() {
        return this.position;
    }

    public void setPosition(Position position) {
        this.position = position;
    }

    public String getStateDetails() {
        return "" + this.getDeptId().getName() + "-" + this.getDesigId().getName() + "-" + this.getPostName();
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }
}

