/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pims.commons.dao;

import java.io.Serializable;
import java.util.Iterator;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.log4j.Logger;
import org.egov.infra.exception.ApplicationException;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.pims.commons.Position;
import org.hibernate.Query;
import org.hibernate.Session;
import org.springframework.stereotype.Repository;

@Repository
public class PositionMasterDAO
implements Serializable {
    public static final Logger LOGGER = Logger.getLogger(PositionMasterDAO.class.getClass());
    @PersistenceContext
    private EntityManager entityManager;

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    public void createPositionMaster(Position position) {
        this.getCurrentSession().save((Object)position);
    }

    public void updatePosition(Position position) {
        this.getCurrentSession().saveOrUpdate((Object)position);
    }

    public void removePosition(Position position) {
        try {
            if (position == null) {
                throw new ApplicationException("position.master.null");
            }
            this.getCurrentSession().delete((Object)position);
        }
        catch (Exception e) {
            throw new ApplicationRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    public Position getPosition(int posId) {
        try {
            Position desig = null;
            desig = (Position)this.getCurrentSession().get(Position.class, (Serializable)Integer.valueOf(posId));
            return desig;
        }
        catch (Exception e) {
            throw new ApplicationRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    public boolean checkDuplication(String positionName, String className) {
        try {
            boolean b = false;
            Query qry = this.getCurrentSession().createQuery("from " + className + " CA where trim(upper(CA.position)) = :positionName ");
            qry.setString("positionName", positionName);
            Iterator iter = qry.iterate();
            LOGGER.info((Object)("iter" + iter));
            if (iter.hasNext()) {
                LOGGER.info((Object)("iter" + iter.hasNext()));
                b = true;
            }
            return b;
        }
        catch (Exception e) {
            throw new ApplicationRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    public Integer getPositionIdByPositionName(String positionName) {
        try {
            Integer positionId = 0;
            Query qry = this.getCurrentSession().createQuery("from position where trim(upper(name)) = :positionName ");
            qry.setString("positionName", positionName);
            Iterator iter = qry.iterate();
            LOGGER.info((Object)("iter" + iter));
            if (iter.hasNext()) {
                positionId = (Integer)iter.next();
            }
            return positionId;
        }
        catch (Exception e) {
            throw new ApplicationRuntimeException(e.getMessage(), (Throwable)e);
        }
    }
}

