/*
 * Decompiled with CFR 0.152.
 */
package org.egov.eis.repository;

import java.util.List;
import java.util.Set;
import org.egov.eis.entity.Employee;
import org.egov.eis.entity.enums.EmployeeStatus;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface EmployeeRepository
extends JpaRepository<Employee, Long> {
    public Employee findByCode(String var1);

    public List<Employee> findByEmployeeStatus(EmployeeStatus var1);

    public List<Employee> findByEmployeeType_Id(Long var1);

    public Employee findByUsername(String var1);

    @Query(value=" select distinct EMP from Employee EMP inner join EMP.assignments ASSIGN inner join fetch EMP.jurisdictions as JRDN  where ASSIGN.department.id=:deptId and ASSIGN.designation.id=:desigId and ASSIGN.fromDate<=current_date and ASSIGN.toDate>=current_date  and JRDN.boundary.id in :boundaryIds")
    public List<Employee> findByDepartmentDesignationAndBoundary(@Param(value="deptId") Long var1, @Param(value="desigId") Long var2, @Param(value="boundaryIds") Set<Long> var3);

    public List<Employee> findByNameLikeOrCodeLike(String var1, String var2);

    public Employee findByName(String var1);

    @Query(value="from Employee  where  upper(code) like '%'||upper(:code)||'%' order by id")
    public List<Employee> findEmployeeByCodeLike(@Param(value="code") String var1);

    @Query(value="from Employee  where  upper(code) like '%'||upper(:code)||'%'  and active=true order by id")
    public List<Employee> findActiveEmployeeByCodeLike(@Param(value="code") String var1);
}

