/*
 * Decompiled with CFR 0.152.
 */
package org.egov.eis.entity;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.egov.commons.CFunction;
import org.egov.commons.Functionary;
import org.egov.commons.Fund;
import org.egov.eis.entity.Employee;
import org.egov.eis.entity.HeadOfDepartments;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.pims.commons.Designation;
import org.egov.pims.commons.Position;
import org.egov.pims.model.GradeMaster;

@Entity
@Table(name="egeis_assignment")
@SequenceGenerator(name="SEQ_EGEIS_ASSIGNMENT", sequenceName="SEQ_EGEIS_ASSIGNMENT", allocationSize=1)
public class Assignment
extends AbstractAuditable {
    public static final String SEQ_ASSIGNMENT = "SEQ_EGEIS_ASSIGNMENT";
    private static final long serialVersionUID = -2720951718725134740L;
    @Id
    @GeneratedValue(generator="SEQ_EGEIS_ASSIGNMENT", strategy=GenerationType.SEQUENCE)
    private Long id;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="position")
    private Position position;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="functionary")
    private Functionary functionary;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="fund")
    private Fund fund;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="function")
    private CFunction function;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="designation")
    private Designation designation;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="department")
    private Department department;
    @Column(name="isprimary")
    private boolean primary;
    @NotNull
    private Date fromDate;
    @NotNull
    private Date toDate;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="grade")
    private GradeMaster grade;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="employee")
    private Employee employee;
    @OneToMany(mappedBy="assignment", orphanRemoval=true, fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    private List<HeadOfDepartments> deptSet = new ArrayList<HeadOfDepartments>(0);

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Designation getDesignation() {
        return this.designation;
    }

    public void setDesignation(Designation designation) {
        this.designation = designation;
    }

    public Functionary getFunctionary() {
        return this.functionary;
    }

    public void setFunctionary(Functionary functionary) {
        this.functionary = functionary;
    }

    public CFunction getFunction() {
        return this.function;
    }

    public void setFunction(CFunction function) {
        this.function = function;
    }

    public Fund getFund() {
        return this.fund;
    }

    public void setFund(Fund fund) {
        this.fund = fund;
    }

    public GradeMaster getGrade() {
        return this.grade;
    }

    public void setGrade(GradeMaster gradeId) {
        this.grade = gradeId;
    }

    public boolean getPrimary() {
        return this.primary;
    }

    public void setPrimary(boolean primary) {
        this.primary = primary;
    }

    public Position getPosition() {
        return this.position;
    }

    public void setPosition(Position position) {
        this.position = position;
    }

    public Department getDepartment() {
        return this.department;
    }

    public void setDepartment(Department department) {
        this.department = department;
    }

    public Date getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(Date fromDate) {
        this.fromDate = fromDate;
    }

    public Date getToDate() {
        return this.toDate;
    }

    public void setToDate(Date toDate) {
        this.toDate = toDate;
    }

    public Employee getEmployee() {
        return this.employee;
    }

    public void setEmployee(Employee employee) {
        this.employee = employee;
    }

    public List<HeadOfDepartments> getDeptSet() {
        return this.deptSet;
    }

    public void setDeptSet(List<HeadOfDepartments> deptSet) {
        this.deptSet.clear();
        if (deptSet != null) {
            this.deptSet.addAll(deptSet);
        }
    }
}

