/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pims.service;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.log4j.Logger;
import org.egov.commons.Accountdetailkey;
import org.egov.commons.Accountdetailtype;
import org.egov.commons.EgwStatus;
import org.egov.commons.dao.AccountdetailkeyHibernateDAO;
import org.egov.commons.dao.AccountdetailtypeHibernateDAO;
import org.egov.commons.dao.EgwStatusHibernateDAO;
import org.egov.commons.exception.NoSuchObjectException;
import org.egov.commons.exception.TooManyValuesException;
import org.egov.eis.entity.Assignment;
import org.egov.eis.entity.EmployeeView;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.exception.ApplicationException;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infstr.services.PersistenceService;
import org.egov.pims.commons.Designation;
import org.egov.pims.commons.Position;
import org.egov.pims.dao.AssignmentDAO;
import org.egov.pims.dao.GenericMasterDAO;
import org.egov.pims.dao.PersonalInformationDAO;
import org.egov.pims.model.EmployeeNamePoJo;
import org.egov.pims.model.GenericMaster;
import org.egov.pims.model.LangKnown;
import org.egov.pims.model.PersonalInformation;
import org.egov.pims.model.SearchEmpDTO;
import org.egov.pims.model.ServiceHistory;
import org.egov.pims.service.EisUtilService;
import org.egov.pims.service.EmployeeServiceOld;
import org.egov.pims.utils.EisManagersUtill;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.type.IntegerType;
import org.hibernate.type.Type;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EmployeeServiceImpl
implements EmployeeServiceOld {
    private static final Logger logger = Logger.getLogger(EmployeeServiceImpl.class);
    private EisUtilService eisService;
    private PersistenceService persistenceService;
    private PersonalInformationDAO personalInformationDAO;
    private AssignmentDAO assignmentDAO;
    private AppConfigValueService appConfigValuesService;
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private EgwStatusHibernateDAO egwStatusHibernateDAO;
    @Autowired
    private AccountdetailtypeHibernateDAO accountdetailtypeHibernateDAO;
    @Autowired
    private AccountdetailkeyHibernateDAO accountdetailkeyHibernateDAO;
    @Autowired
    private GenericMasterDAO genericMasterDAO;
    private static final Logger LOGGER = Logger.getLogger(EmployeeServiceImpl.class);
    List appliedDisiplinaryApplications = new ArrayList();
    List rejectedDisiplinaryApplications = new ArrayList();
    List approvedDisiplinaryApplications = new ArrayList();

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    public PersistenceService getPersistenceService() {
        return this.persistenceService;
    }

    public void setPersistenceService(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    @Override
    @Deprecated
    public List searchEmployee(Integer departmentId, Integer designationId, String code, String name, String searchAll) throws Exception {
        List employeeList = null;
        try {
            String mainStr = "from EmployeeView ev where";
            if (code != null && !code.equals("")) {
                mainStr = mainStr + " upper(trim(ev.employeeCode)) = :employeeCode and ";
            }
            if (departmentId != 0) {
                mainStr = mainStr + " ev.deptId.id= :deptId and ";
            }
            if (designationId != 0) {
                mainStr = mainStr + " ev.desigId.designationId = :designationId and ";
            }
            if (name != null && !name.equals("")) {
                mainStr = mainStr + " trim(upper(ev.employeeName))  like '%" + name.trim().toUpperCase() + "%' and ";
            }
            mainStr = searchAll.equals("false") && designationId != 0 ? mainStr + " ((ev.toDate is null and ev.fromDate <= SYSDATE ) OR (ev.fromDate <= SYSDATE AND ev.toDate > SYSDATE)) and ev.isActive = '1' " : (searchAll.equals("true") && designationId != 0 ? mainStr + " ((ev.toDate is null and ev.fromDate <= SYSDATE ) OR (ev.fromDate <= SYSDATE AND ev.toDate > SYSDATE)) " : (code != null && !code.equals("") ? mainStr + "  ((ev.toDate IS NULL AND ev.fromDate <= SYSDATE) OR (ev.fromDate <= SYSDATE AND ev.toDate > SYSDATE)  OR (ev.fromDate IN (SELECT MAX (evn.fromDate)  FROM EmployeeView  evn    WHERE evn.id = ev.id AND NOT EXISTS  (SELECT evn2.id FROM EmployeeView evn2 WHERE evn2.id = ev.id AND  ((evn2.toDate  IS NULL AND evn2.fromDate <= SYSDATE) OR (evn2.fromDate <= SYSDATE AND evn2.toDate > SYSDATE)) )))) " : (searchAll.equals("true") && designationId == 0 ? mainStr + "  ((ev.toDate IS NULL AND ev.fromDate <= SYSDATE) OR (ev.fromDate <= SYSDATE AND ev.toDate > SYSDATE)  OR (ev.fromDate IN (SELECT MAX (evn.fromDate)  FROM EmployeeView  evn    WHERE evn.id = ev.id AND NOT EXISTS  (SELECT evn2.id FROM EmployeeView evn2 WHERE evn2.id = ev.id AND  ((evn2.toDate  IS NULL AND evn2.fromDate <= SYSDATE) OR (evn2.fromDate <= SYSDATE AND evn2.toDate > SYSDATE)) )))) " : mainStr + " ((ev.toDate is null and ev.fromDate <= SYSDATE ) OR (ev.fromDate <= SYSDATE AND ev.toDate > SYSDATE)) ")));
            Query qry = null;
            qry = this.getCurrentSession().createQuery(mainStr);
            LOGGER.info((Object)("qryqryqryqry" + qry.toString()));
            if (code != null && !code.equals("")) {
                qry.setString("employeeCode", code.trim().toUpperCase());
            }
            if (departmentId != 0) {
                qry.setLong("deptId", departmentId.longValue());
            }
            if (designationId != 0) {
                qry.setInteger("designationId", designationId.intValue());
            }
            employeeList = qry.list();
        }
        catch (HibernateException he) {
            LOGGER.error((Object)he);
            throw new ApplicationRuntimeException("Exception:" + he.getMessage(), (Throwable)he);
        }
        catch (Exception he) {
            LOGGER.error((Object)he);
            throw new ApplicationRuntimeException("Exception:" + he.getMessage(), (Throwable)he);
        }
        return employeeList;
    }

    @Override
    public List searchEmployee(Integer departmentId, Integer designationId, String code, String name, Integer status) throws Exception {
        List employeeList = null;
        try {
            String mainStr = "from EmployeeView ev where ev.isPrimary='Y' and ";
            if (code != null && !code.equals("")) {
                mainStr = mainStr + " upper(trim(ev.employeeCode)) = :employeeCode and ";
            }
            if (departmentId != 0) {
                mainStr = mainStr + " ev.deptId.id= :deptId and ";
            }
            if (designationId != 0) {
                mainStr = mainStr + " ev.desigId.designationId = :designationId and ";
            }
            if (name != null && !name.equals("")) {
                mainStr = mainStr + " trim(upper(ev.employeeName))  like '%" + name.trim().toUpperCase() + "%' and ";
            }
            if (status != 0) {
                mainStr = mainStr + " ev.employeeStatus.id = :employeeStatus and ";
            }
            mainStr = status != 0 && designationId == 0 ? mainStr + " ((ev.toDate is null and ev.fromDate <= SYSDATE ) OR (ev.fromDate <= SYSDATE AND ev.toDate > SYSDATE)) and ev.employeeStatus.id = :employeeStatus " : (status == 0 && designationId != 0 ? mainStr + " ((ev.toDate is null and ev.fromDate <= SYSDATE ) OR (ev.fromDate <= SYSDATE AND ev.toDate > SYSDATE)) " : (code != null && !code.equals("") ? mainStr + "  ((ev.toDate IS NULL AND ev.fromDate <= SYSDATE) OR (ev.fromDate <= SYSDATE AND ev.toDate > SYSDATE)  OR (ev.fromDate IN (SELECT MAX (evn.fromDate)  FROM EmployeeView  evn    WHERE evn.id = ev.id AND NOT EXISTS  (SELECT evn2.id FROM EmployeeView evn2 WHERE evn2.id = ev.id AND  ((evn2.toDate  IS NULL AND evn2.fromDate <= SYSDATE) OR (evn2.fromDate <= SYSDATE AND evn2.toDate > SYSDATE)) )))) " : (status != 0 || designationId == 0 ? mainStr + "  ((ev.toDate IS NULL AND ev.fromDate <= SYSDATE) OR (ev.fromDate <= SYSDATE AND ev.toDate > SYSDATE)  OR (ev.fromDate IN (SELECT MAX (evn.fromDate)  FROM EmployeeView  evn    WHERE evn.id = ev.id AND NOT EXISTS  (SELECT evn2.id FROM EmployeeView evn2 WHERE evn2.id = ev.id AND  ((evn2.toDate  IS NULL AND evn2.fromDate <= SYSDATE) OR (evn2.fromDate <= SYSDATE AND evn2.toDate > SYSDATE)) )))) " : mainStr + " ((ev.toDate is null and ev.fromDate <= SYSDATE ) OR (ev.fromDate <= SYSDATE AND ev.toDate > SYSDATE)) ")));
            Query qry = null;
            qry = this.getCurrentSession().createQuery(mainStr);
            LOGGER.info((Object)("qryqryqryqry" + qry.toString()));
            if (code != null && !code.equals("")) {
                qry.setString("employeeCode", code.trim().toUpperCase());
            }
            if (departmentId != 0) {
                qry.setInteger("deptId", departmentId.intValue());
            }
            if (designationId != 0) {
                qry.setInteger("designationId", designationId.intValue());
            }
            if (status != 0) {
                qry.setInteger("employeeStatus", status.intValue());
            }
            employeeList = qry.list();
        }
        catch (HibernateException he) {
            LOGGER.error((Object)he);
            throw new ApplicationRuntimeException("Exception:" + he.getMessage(), (Throwable)he);
        }
        catch (Exception he) {
            LOGGER.error((Object)he);
            throw new ApplicationRuntimeException("Exception:" + he.getMessage(), (Throwable)he);
        }
        return employeeList;
    }

    @Override
    public List searchEmployee(Integer departmentId, Integer designationId, Integer functionaryId, String code, String name, Integer status) throws Exception {
        List employeeList = null;
        try {
            String mainStr = "from EmployeeView ev where  ";
            if (code != null && !code.equals("")) {
                mainStr = mainStr + " upper(trim(ev.employeeCode)) = :employeeCode and ";
            }
            if (departmentId != 0) {
                mainStr = mainStr + " ev.deptId.id= :deptId and ";
            }
            if (designationId != 0) {
                mainStr = mainStr + " ev.desigId.designationId = :designationId and ";
            }
            if (functionaryId != 0) {
                mainStr = mainStr + " ev.functionary.id = :functionaryId and ";
            }
            if (name != null && !name.equals("")) {
                mainStr = mainStr + " trim(upper(ev.employeeName))  like '%" + name.trim().toUpperCase() + "%' and ";
            }
            if (status != 0) {
                mainStr = mainStr + " ev.employeeStatus.id = :employeeStatus and ";
            }
            mainStr = status != 0 && designationId == 0 ? mainStr + " ((ev.toDate is null and ev.fromDate <= SYSDATE ) OR (ev.fromDate <= SYSDATE AND ev.toDate > SYSDATE)) and ev.employeeStatus.id = :employeeStatus " : (status == 0 && designationId != 0 ? mainStr + " ((ev.toDate is null and ev.fromDate <= SYSDATE ) OR (ev.fromDate <= SYSDATE AND ev.toDate > SYSDATE)) " : (code != null && !code.equals("") ? mainStr + "  ((ev.toDate IS NULL AND ev.fromDate <= SYSDATE) OR (ev.fromDate <= SYSDATE AND ev.toDate > SYSDATE)  OR (ev.fromDate IN (SELECT MAX (evn.fromDate)  FROM EmployeeView  evn    WHERE evn.id = ev.id AND NOT EXISTS  (SELECT evn2.id FROM EmployeeView evn2 WHERE evn2.id = ev.id AND  ((evn2.toDate  IS NULL AND evn2.fromDate <= SYSDATE) OR (evn2.fromDate <= SYSDATE AND evn2.toDate > SYSDATE)) )))) " : (status != 0 || designationId == 0 ? mainStr + "  ((ev.toDate IS NULL AND ev.fromDate <= SYSDATE) OR (ev.fromDate <= SYSDATE AND ev.toDate > SYSDATE)  OR (ev.fromDate IN (SELECT MAX (evn.fromDate)  FROM EmployeeView  evn    WHERE evn.id = ev.id AND NOT EXISTS  (SELECT evn2.id FROM EmployeeView evn2 WHERE evn2.id = ev.id AND  ((evn2.toDate  IS NULL AND evn2.fromDate <= SYSDATE) OR (evn2.fromDate <= SYSDATE AND evn2.toDate > SYSDATE)) )))) " : mainStr + " ((ev.toDate is null and ev.fromDate <= SYSDATE ) OR (ev.fromDate <= SYSDATE AND ev.toDate > SYSDATE)) ")));
            Query qry = null;
            qry = this.getCurrentSession().createQuery(mainStr);
            LOGGER.info((Object)("qryqryqryqry" + qry.toString()));
            if (code != null && !code.equals("")) {
                qry.setString("employeeCode", code.trim().toUpperCase());
            }
            if (departmentId != 0) {
                qry.setInteger("deptId", departmentId.intValue());
            }
            if (designationId != 0) {
                qry.setInteger("designationId", designationId.intValue());
            }
            if (functionaryId != 0) {
                qry.setInteger("functionaryId", functionaryId.intValue());
            }
            if (status != 0) {
                qry.setInteger("employeeStatus", status.intValue());
            }
            employeeList = qry.list();
        }
        catch (HibernateException he) {
            LOGGER.error((Object)he);
            throw new ApplicationRuntimeException("Exception:" + he.getMessage(), (Throwable)he);
        }
        catch (Exception he) {
            LOGGER.error((Object)he);
            throw new ApplicationRuntimeException("Exception:" + he.getMessage(), (Throwable)he);
        }
        return employeeList;
    }

    @Override
    public List<EmployeeView> searchEmployee(Integer designationId, String code, String name, Integer status, Integer empType, Map<String, Integer> finParams) throws Exception {
        List<EmployeeView> employeeList = new ArrayList<EmployeeView>();
        Integer departmentId = finParams.get("departmentId") == null ? Integer.valueOf(0) : finParams.get("departmentId");
        Integer functionaryId = finParams.get("functionaryId") == null ? Integer.valueOf(0) : finParams.get("functionaryId");
        Integer functionId = finParams.get("functionId") == null ? Integer.valueOf(0) : finParams.get("functionId");
        Integer userId = finParams.get("userId") == null ? Integer.valueOf(0) : finParams.get("userId");
        Integer isActive = finParams.get("isActive") == null ? Integer.valueOf(0) : finParams.get("isActive");
        try {
            Query qry = null;
            if (code != null && !code.equals("")) {
                logger.info((Object)(" Search by Code " + code));
                List list = this.persistenceService.findAllBy(" from EmployeeView ev where upper(ev.employeeCode) like ? ", new Object[]{code});
                Iterator itr = list.iterator();
                EmployeeView ev = null;
                EmployeeView ev12 = null;
                Assignment ass = null;
                java.util.Date date = new java.util.Date();
                PersonalInformation emp = null;
                if (itr.hasNext()) {
                    ev = (EmployeeView)itr.next();
                    emp = this.getEmloyeeById(ev.getId().intValue());
                }
                for (EmployeeView ev12 : list) {
                    if (ass == null || !((Object)((Object)ev12.getAssignment())).equals((Object)ass)) continue;
                    logger.info((Object)("ev.assId=" + ev12.getAssignment().getId()));
                    logger.info((Object)("ass.assId=" + ass.getId()));
                    logger.info((Object)("emp " + ev12.getName() + " : " + ev12.getPosition().getName() + " : " + ev12.getPrimary()));
                    break;
                }
                if (ev12 != null) {
                    employeeList.add(ev12);
                }
            } else {
                logger.info((Object)" Search by other params ");
                String mainStr = "from EmployeeView ev where ";
                if (departmentId != 0) {
                    mainStr = mainStr + " ev.deptId.id= :deptId and ";
                }
                if (designationId != 0) {
                    mainStr = mainStr + " ev.desigId.designationId = :designationId and ";
                }
                if (functionaryId != 0) {
                    mainStr = mainStr + " ev.functionary.id = :functionaryId and ";
                }
                if (functionId != null && functionId != 0) {
                    mainStr = mainStr + " ev.functionId.id = :functionId and ";
                }
                if (name != null && !name.equals("")) {
                    mainStr = mainStr + " trim(upper(ev.employeeName))  like '%" + name.trim().toUpperCase() + "%' and ";
                }
                if (status != 0) {
                    mainStr = mainStr + " ev.employeeStatus.id = :employeeStatus and ";
                }
                if (empType != 0) {
                    mainStr = mainStr + " ev.employeeType.id=:employeeType and ";
                }
                if (isActive != 0) {
                    mainStr = mainStr + " ev.userMaster.active=:isActive  and ";
                }
                if (userId != 0) {
                    mainStr = mainStr + " ev.userMaster.id= :userId and ";
                }
                mainStr = mainStr + " upper(ev.isPrimary)='Y' AND ((  ev.toDate IS NULL AND ev.fromDate <= TO_DATE(SYSDATE,'dd-MM-yyy')) OR ( ev.fromDate <= TO_DATE(SYSDATE,'dd-MM-yyy') AND ev.toDate >= TO_DATE(SYSDATE,'dd-MM-yyy'))  OR (ev.fromDate IN (SELECT MAX (evn.fromDate)  FROM EmployeeView  evn    WHERE evn.id = ev.id  AND NOT EXISTS  (SELECT evn2.id FROM EmployeeView evn2 WHERE evn2.id = ev.id AND  ((evn2.toDate  IS NULL AND evn2.fromDate <= TO_DATE(SYSDATE,'dd-MM-yyy')) OR (evn2.fromDate <= TO_DATE(SYSDATE,'dd-MM-yyy') AND evn2.toDate >= TO_DATE(SYSDATE,'dd-MM-yyy'))) )))) ";
                qry = this.getCurrentSession().createQuery(mainStr);
                if (departmentId != 0) {
                    qry.setInteger("deptId", departmentId.intValue());
                }
                if (designationId != 0) {
                    qry.setInteger("designationId", designationId.intValue());
                }
                if (functionaryId != 0) {
                    qry.setInteger("functionaryId", functionaryId.intValue());
                }
                if (status != 0) {
                    qry.setInteger("employeeStatus", status.intValue());
                }
                if (empType != 0) {
                    qry.setInteger("employeeType", empType.intValue());
                }
                if (isActive != 0) {
                    qry.setInteger("isActive", isActive.intValue());
                }
                if (userId != 0) {
                    qry.setInteger("userId", userId.intValue());
                }
                employeeList = qry.list();
            }
        }
        catch (HibernateException he) {
            LOGGER.error((Object)he);
            throw new ApplicationRuntimeException("Exception:" + he.getMessage(), (Throwable)he);
        }
        catch (Exception he) {
            LOGGER.error((Object)he);
            throw new ApplicationRuntimeException("Exception:" + he.getMessage(), (Throwable)he);
        }
        return employeeList;
    }

    @Override
    @Deprecated
    public List searchEmployee(Integer departmentId, Integer designationId, Integer functionaryId, String code, String name, Integer status, Integer empType) throws Exception {
        List employeeList = null;
        try {
            String mainStr = "from EmployeeView ev where ";
            if (code != null && !code.equals("")) {
                mainStr = mainStr + " upper(trim(ev.employeeCode)) = :employeeCode and ";
                name = "";
            }
            if (departmentId != 0) {
                mainStr = mainStr + " ev.deptId.id= :deptId and ";
            }
            if (designationId != 0) {
                mainStr = mainStr + " ev.desigId.designationId = :designationId and ";
            }
            if (functionaryId != 0) {
                mainStr = mainStr + " ev.functionary.id = :functionaryId and ";
            }
            if (name != null && !name.equals("")) {
                mainStr = mainStr + " trim(upper(ev.employeeName))  like :empName and ";
            }
            if (status != 0) {
                mainStr = mainStr + " ev.employeeStatus.id = :employeeStatus and ";
            }
            if (empType != 0) {
                mainStr = mainStr + " ev.employeeType.id=:employeeType and ";
            }
            mainStr = mainStr + "  ((ev.toDate IS NULL AND ev.fromDate <= TO_DATE(SYSDATE,'dd-MM-yyy')) OR (upper(ev.isPrimary)='Y' and ev.fromDate <= TO_DATE(SYSDATE,'dd-MM-yyy') AND ev.toDate >= TO_DATE(SYSDATE,'dd-MM-yyy'))  OR (ev.fromDate IN (SELECT MAX (evn.fromDate)  FROM EmployeeView  evn    WHERE evn.id = ev.id AND upper(ev.isPrimary)='Y' AND NOT EXISTS  (SELECT evn2.id FROM EmployeeView evn2 WHERE evn2.id = ev.id AND  ((evn2.toDate  IS NULL AND evn2.fromDate <= TO_DATE(SYSDATE,'dd-MM-yyy')) OR (evn2.fromDate <= TO_DATE(SYSDATE,'dd-MM-yyy') AND evn2.toDate >= TO_DATE(SYSDATE,'dd-MM-yyy'))) )))) ";
            Query qry = null;
            qry = this.getCurrentSession().createQuery(mainStr);
            LOGGER.info((Object)("qryqryqryqry" + qry.toString()));
            if (code != null && !code.equals("")) {
                qry.setString("employeeCode", code.trim().toUpperCase());
            }
            if (departmentId != 0) {
                qry.setInteger("deptId", departmentId.intValue());
            }
            if (name != null && !name.equals("")) {
                qry.setString("empName", "%" + name.trim().toUpperCase() + "%");
            }
            if (designationId != 0) {
                qry.setInteger("designationId", designationId.intValue());
            }
            if (functionaryId != 0) {
                qry.setInteger("functionaryId", functionaryId.intValue());
            }
            if (status != 0) {
                qry.setInteger("employeeStatus", status.intValue());
            }
            if (empType != 0) {
                qry.setInteger("employeeType", empType.intValue());
            }
            employeeList = qry.list();
        }
        catch (HibernateException he) {
            LOGGER.error((Object)he);
            throw new ApplicationRuntimeException("Exception:" + he.getMessage(), (Throwable)he);
        }
        catch (Exception he) {
            LOGGER.error((Object)he);
            throw new ApplicationRuntimeException("Exception:" + he.getMessage(), (Throwable)he);
        }
        return employeeList;
    }

    @Override
    public List<EmployeeView> searchEmployeeByGrouping(LinkedList<String> groupingByOrder) throws Exception {
        List employeeList = null;
        try {
            String mainStr = "from EmployeeView ev where ";
            String orderByStr = "";
            for (int i = 0; i < groupingByOrder.size(); ++i) {
                if (groupingByOrder.get(i).toString().equals("FundCode")) {
                    if (!orderByStr.equals("")) {
                        orderByStr = orderByStr + ", ";
                    }
                    orderByStr = orderByStr + " ev.assignment.fundId.code";
                    continue;
                }
                if (groupingByOrder.get(i).toString().equals("FunctionCode")) {
                    if (!orderByStr.equals("")) {
                        orderByStr = orderByStr + ", ";
                    }
                    orderByStr = orderByStr + " ev.assignment.functionId.code";
                    continue;
                }
                if (!groupingByOrder.get(i).toString().equals("DeptCode")) continue;
                if (!orderByStr.equals("")) {
                    orderByStr = orderByStr + ", ";
                }
                orderByStr = orderByStr + " ev.assignment.deptId.deptCode";
            }
            if (!orderByStr.equals("")) {
                orderByStr = " order by " + orderByStr;
            }
            mainStr = mainStr + " ((ev.toDate is null and ev.fromDate <= SYSDATE ) OR (ev.fromDate <= SYSDATE AND ev.toDate > SYSDATE)) and ev.assignment.isPrimary='Y' ";
            mainStr = mainStr + orderByStr;
            Query qry = null;
            qry = this.getCurrentSession().createQuery(mainStr);
            LOGGER.info((Object)("Query in search Employee by grouping==" + qry.toString()));
            employeeList = qry.list();
        }
        catch (HibernateException he) {
            LOGGER.error((Object)("Exception ===" + he.getMessage()));
            throw new ApplicationRuntimeException("Exception:" + he.getMessage(), (Throwable)he);
        }
        catch (Exception e) {
            LOGGER.error((Object)("Exception ===" + e.getMessage()));
            throw new ApplicationRuntimeException("Exception:" + e.getMessage(), (Throwable)e);
        }
        return employeeList;
    }

    @Override
    public List searchEmployee(Integer empId) throws Exception {
        ArrayList<SearchEmpDTO> dataElCol = new ArrayList<SearchEmpDTO>();
        List employeeList = null;
        try {
            String mainStr = "select ev.employeeCode,ev.employeeName,ev.id,ev.desigId.designationId, ev.deptId.id ,ev.fromDate,ev.toDate from EmployeeView ev where ev.id = :empId";
            Query qry = this.getCurrentSession().createQuery(mainStr);
            if (empId != 0) {
                qry.setInteger("empId", empId.intValue());
            }
            employeeList = qry.list();
            for (Object[] objArray : employeeList) {
                this.addEmployee(objArray, dataElCol);
            }
        }
        catch (HibernateException he) {
            LOGGER.error((Object)he);
            throw new ApplicationRuntimeException("Exception:" + he.getMessage(), (Throwable)he);
        }
        catch (Exception he) {
            LOGGER.error((Object)he);
            throw new ApplicationRuntimeException("Exception:" + he.getMessage(), (Throwable)he);
        }
        return dataElCol;
    }

    private void addEmployee(Object[] objArray, ArrayList<SearchEmpDTO> dataElColt) {
        try {
            int len = objArray.length;
            Integer id = 0;
            String empCode = "";
            String fName = "";
            Integer desid = null;
            Integer deptId = null;
            Date fromDate = null;
            Date toDate = null;
            for (int i = 0; i < len; ++i) {
                if (i == 0) {
                    empCode = (String)objArray[i];
                } else if (i == 1) {
                    fName = (String)objArray[i];
                } else if (i == 2) {
                    id = (Integer)objArray[i];
                } else if (i == 3) {
                    desid = (Integer)objArray[i];
                } else if (i == 4) {
                    deptId = (Integer)objArray[i];
                } else if (i == 5) {
                    fromDate = (Date)objArray[i];
                } else if (i == 6) {
                    toDate = (Date)objArray[i];
                }
                if (i != 6) continue;
                dataElColt.add(new SearchEmpDTO(desid, deptId, empCode, fName, id, fromDate, toDate));
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
            throw new ApplicationRuntimeException("Exception:" + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public Assignment getAssignmentByEmpAndDate(java.util.Date date, Integer empId) {
        Assignment assignment = null;
        try {
            if (empId != null) {
                String mainStr = " select \tev.assignment  from EmployeeView ev  where ev.assignment.isPrimary = 'Y' and ev.id = :empId and ((ev.toDate is null and ev.fromDate <= :date1 ) OR (ev.fromDate <= :date2 AND ev.toDate >= :date3 ))";
                Query qry = this.getCurrentSession().createQuery(mainStr);
                qry.setInteger("empId", empId.intValue());
                qry.setDate("date1", (java.util.Date)new Date(date.getTime()));
                qry.setDate("date2", (java.util.Date)new Date(date.getTime()));
                qry.setDate("date3", (java.util.Date)new Date(date.getTime()));
                if (qry.list() != null && !qry.list().isEmpty()) {
                    assignment = (Assignment)((Object)qry.list().get(0));
                }
            }
        }
        catch (HibernateException he) {
            LOGGER.error((Object)he);
            throw new ApplicationRuntimeException("Exception:" + he.getMessage(), (Throwable)he);
        }
        catch (Exception he) {
            LOGGER.error((Object)he);
            throw new ApplicationRuntimeException("Exception:" + he.getMessage(), (Throwable)he);
        }
        return assignment;
    }

    @Override
    public Assignment getLatestAssignmentForEmployee(Integer empId) {
        java.util.Date currDate = new java.util.Date();
        Assignment assignment2 = null;
        try {
            String mainStr = "";
            mainStr = " select ev.assignment from EmployeeView ev where ev.assignment.isPrimary = 'Y' and ev.id = :empId and ((ev.toDate is null and ev.fromDate <= :sysDate ) OR (ev.fromDate <= :sysDate AND ev.toDate >= :sysDate))";
            Query qry = this.getCurrentSession().createQuery(mainStr);
            if (empId != null) {
                qry.setInteger("empId", empId.intValue());
                qry.setDate("sysDate", (java.util.Date)new Date(currDate.getTime()));
            }
            if (qry.list() != null && !qry.list().isEmpty()) {
                for (Assignment assignment2 : qry.list()) {
                }
            }
        }
        catch (HibernateException he) {
            LOGGER.error((Object)he);
            throw new ApplicationRuntimeException("Exception:" + he.getMessage(), (Throwable)he);
        }
        catch (Exception he) {
            LOGGER.error((Object)he);
            throw new ApplicationRuntimeException("Exception:" + he.getMessage(), (Throwable)he);
        }
        return assignment2;
    }

    @Override
    public PersonalInformation getEmployeeforPosition(Position pos) {
        Object uerImpl = null;
        PersonalInformation personalInformation = new PersonalInformation();
        try {
            String mainStr = "";
            mainStr = " select \tid  from EG_EIS_EMPLOYEEINFO ev  where ev.POS_ID = :pos and ((ev.to_Date is null and ev.from_Date <= SYSDATE ) OR (ev.from_Date <= SYSDATE AND ev.to_Date > SYSDATE))";
            SQLQuery qry = this.getCurrentSession().createSQLQuery(mainStr).addScalar("id", (Type)IntegerType.INSTANCE);
            if (pos != null) {
                qry.setEntity("pos", (Object)pos);
            }
            if (qry.list() != null && !qry.list().isEmpty()) {
                for (Integer id : qry.list()) {
                    personalInformation = EisManagersUtill.getEmployeeService().getEmloyeeById(id);
                }
            }
        }
        catch (HibernateException he) {
            LOGGER.error((Object)he);
            throw new ApplicationRuntimeException("Exception:" + he.getMessage(), (Throwable)he);
        }
        catch (Exception he) {
            LOGGER.error((Object)he);
            throw new ApplicationRuntimeException("Exception:" + he.getMessage(), (Throwable)he);
        }
        return personalInformation;
    }

    @Override
    public Position getPositionforEmp(Integer empId) {
        Position position = null;
        List list = null;
        try {
            String mainStr = "";
            mainStr = " select \tPOS_ID  from EG_EIS_EMPLOYEEINFO ev  where ev.ID = :empId and ((ev.to_Date is null and ev.from_Date <= SYSDATE ) OR (ev.from_Date <= SYSDATE AND ev.to_Date >= SYSDATE))";
            SQLQuery qry = this.getCurrentSession().createSQLQuery(mainStr).addScalar("POS_ID", (Type)IntegerType.INSTANCE);
            if (empId != null) {
                qry.setInteger("empId", empId.intValue());
            }
            if ((list = qry.list()) != null && !list.isEmpty()) {
                for (Integer id : qry.list()) {
                    if (id == null) continue;
                    position = EisManagersUtill.getEisCommonsService().getPositionById(id);
                }
            }
        }
        catch (HibernateException he) {
            LOGGER.error((Object)he);
            throw new ApplicationRuntimeException("Exception:" + he.getMessage(), (Throwable)he);
        }
        catch (Exception he) {
            LOGGER.error((Object)he);
            throw new ApplicationRuntimeException("Exception:" + he.getMessage(), (Throwable)he);
        }
        return position;
    }

    @Override
    public boolean checkDuplication(String name, String className) {
        boolean b = false;
        try {
            Query qry = this.getCurrentSession().createQuery("from " + className + " CA where trim(upper(CA.name)) = :name ");
            qry.setString("name", name);
            Iterator iter = qry.iterate();
            if (iter.hasNext()) {
                b = true;
            }
        }
        catch (HibernateException he) {
            LOGGER.error((Object)he);
            throw new ApplicationRuntimeException("Exception:" + he.getMessage(), (Throwable)he);
        }
        catch (Exception he) {
            LOGGER.error((Object)he);
            throw new ApplicationRuntimeException("Exception:" + he.getMessage(), (Throwable)he);
        }
        return b;
    }

    @Override
    public PersonalInformation getEmpForUserId(Long userId) {
        return this.personalInformationDAO.getPersonalInformationByUserId(userId);
    }

    public void createAssignment(Assignment egEmpAssignment) {
        try {
            this.assignmentDAO.create(egEmpAssignment);
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
            throw new ApplicationRuntimeException("Exception:" + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public PersonalInformation createEmloyee(PersonalInformation egpimsPersonalInformation) {
        try {
            if (egpimsPersonalInformation != null) {
                this.personalInformationDAO.create(egpimsPersonalInformation);
                Accountdetailtype accountdetailtype = this.accountdetailtypeHibernateDAO.getAccountdetailtypeByName("Employee");
                Accountdetailkey adk = new Accountdetailkey();
                adk.setAccountdetailtype(accountdetailtype);
                adk.setGroupid(Integer.valueOf(1));
                adk.setDetailkey(egpimsPersonalInformation.getIdPersonalInformation());
                adk.setDetailname(accountdetailtype.getAttributename());
                this.accountdetailkeyHibernateDAO.create(adk);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
            throw new ApplicationRuntimeException("Exception:" + e.getMessage(), (Throwable)e);
        }
        return egpimsPersonalInformation;
    }

    @Override
    public void updateEmloyee(PersonalInformation egpimsPersonalInformation) {
        try {
            if (egpimsPersonalInformation != null) {
                this.personalInformationDAO.update(egpimsPersonalInformation);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
            throw new ApplicationRuntimeException("Exception:" + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public PersonalInformation getEmloyeeById(Integer employeeId) {
        PersonalInformation egpimsPersonalInformation = null;
        egpimsPersonalInformation = this.personalInformationDAO.getPersonalInformationByID(employeeId);
        return egpimsPersonalInformation;
    }

    @Override
    public GenericMaster getGenericMaster(Integer masterId, String masterName) {
        GenericMaster genericMaster = null;
        genericMaster = this.genericMasterDAO.getGenericMaster(masterId, masterName);
        return genericMaster;
    }

    @Override
    public Assignment getAssignmentById(Integer assignmentId) {
        Assignment assignment = null;
        assignment = this.assignmentDAO.getAssignmentById(assignmentId);
        return assignment;
    }

    @Override
    public void updateAssignment(Assignment assignment) {
        try {
            if (assignment != null) {
                this.assignmentDAO.update(assignment);
            }
        }
        catch (RuntimeException e) {
            LOGGER.error((Object)e);
            throw new ApplicationRuntimeException("Exception:" + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void addLangKnown(PersonalInformation personalInformation, LangKnown langKnown) {
        try {
            personalInformation.addLangKnown(langKnown);
        }
        catch (RuntimeException e) {
            LOGGER.error((Object)e);
            throw new ApplicationRuntimeException("Exception:" + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public List getListOfEmpforDept(Integer deptId) {
        PersonalInformation personalInformation = null;
        ArrayList<PersonalInformation> listOfEmpOfSameDept = new ArrayList<PersonalInformation>();
        try {
            List employeeList = this.searchEmployee(deptId, (Integer)0, "", "", "false");
            if (!employeeList.isEmpty()) {
                for (EmployeeView cataEl : employeeList) {
                    personalInformation = this.getEmloyeeById(cataEl.getId().intValue());
                    listOfEmpOfSameDept.add(personalInformation);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
            throw new ApplicationRuntimeException("Exception:" + e.getMessage(), (Throwable)e);
        }
        return listOfEmpOfSameDept;
    }

    @Override
    public List getListOfEmpforDesignation(Integer desigId) {
        PersonalInformation personalInformation = null;
        ArrayList<PersonalInformation> listOfEmpOfSameDesig = new ArrayList<PersonalInformation>();
        try {
            List employeeList = this.searchEmployee((Integer)0, desigId, "", "", "false");
            if (!employeeList.isEmpty()) {
                for (EmployeeView cataEl : employeeList) {
                    personalInformation = this.getEmloyeeById(cataEl.getId().intValue());
                    listOfEmpOfSameDesig.add(personalInformation);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
            throw new ApplicationRuntimeException("Exception:" + e.getMessage(), (Throwable)e);
        }
        return listOfEmpOfSameDesig;
    }

    @Override
    public EmployeeNamePoJo getNameOfEmployee(Integer empId) {
        try {
            EmployeeNamePoJo employeeNamePoJo = null;
            PersonalInformation personalInformation = this.getEmloyeeById((int)empId);
            String fn = "";
            String mn = "";
            String ln = "";
            if (personalInformation.getEmployeeFirstName() != null) {
                fn = personalInformation.getEmployeeFirstName();
            }
            if (personalInformation.getEmployeeMiddleName() != null) {
                mn = personalInformation.getEmployeeMiddleName();
            }
            if (personalInformation.getEmployeeLastName() != null) {
                ln = personalInformation.getEmployeeLastName();
            }
            employeeNamePoJo = new EmployeeNamePoJo(fn, mn, ln);
            return employeeNamePoJo;
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
            throw new ApplicationRuntimeException("Exception:" + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public Map getAllPIMap() {
        return this.personalInformationDAO.getAllPIMap();
    }

    @Override
    public Map getMapForList(List list) {
        LinkedHashMap<Integer, String> retMap = new LinkedHashMap<Integer, String>();
        try {
            for (Object object : list) {
                Class<?> classObj = object.getClass();
                Field id = classObj.getField("id");
                Field name = classObj.getField("name");
                retMap.put((Integer)id.get(object), (String)name.get(object));
            }
        }
        catch (NoSuchFieldException nfe) {
            throw new ApplicationRuntimeException("Exception:" + nfe.getMessage(), (Throwable)nfe);
        }
        catch (IllegalAccessException iac) {
            throw new ApplicationRuntimeException("Exception:" + iac.getMessage(), (Throwable)iac);
        }
        return retMap;
    }

    @Override
    public Map getMapForList(List list, String fieldName1, String fieldName2) {
        LinkedHashMap<Integer, String> retMap = new LinkedHashMap<Integer, String>();
        try {
            String id = null;
            String name = null;
            Object longObj = null;
            for (Object object : list) {
                id = BeanUtils.getProperty(object, (String)fieldName1);
                name = BeanUtils.getProperty(object, (String)fieldName2);
                if (id == null) continue;
                retMap.put(Integer.valueOf(id), name);
            }
        }
        catch (IllegalAccessException iac) {
            throw new ApplicationRuntimeException("Exception:" + iac.getMessage(), (Throwable)iac);
        }
        catch (InvocationTargetException e) {
            LOGGER.error((Object)e);
            throw new ApplicationRuntimeException("Exception:" + e.getMessage(), (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            LOGGER.error((Object)e);
            throw new ApplicationRuntimeException("Exception:" + e.getMessage(), (Throwable)e);
        }
        return retMap;
    }

    @Override
    public void deleteLangKnownForEmp(PersonalInformation personalInformation) {
        try {
            this.personalInformationDAO.deleteLangKnownForEmp(personalInformation);
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
            throw new ApplicationRuntimeException("Exception:" + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public Integer getNextVal() {
        Integer id = 0;
        try {
            SQLQuery qry = this.getCurrentSession().createSQLQuery("SELECT SEQ_DIS_APP.nextval as id from dual").addScalar("id", (Type)IntegerType.INSTANCE);
            if (qry.list() != null && !qry.list().isEmpty()) {
                Integer obj = null;
                Iterator iter = qry.list().iterator();
                while (iter.hasNext()) {
                    id = obj = (Integer)iter.next();
                }
            }
        }
        catch (HibernateException he) {
            LOGGER.error((Object)he);
            throw new ApplicationRuntimeException("Exception:" + he.getMessage(), (Throwable)he);
        }
        catch (Exception he) {
            LOGGER.error((Object)he);
            throw new ApplicationRuntimeException("Exception:" + he.getMessage(), (Throwable)he);
        }
        return id;
    }

    private String getNextValForCode() {
        Integer id = 0;
        try {
            SQLQuery qry = this.getCurrentSession().createSQLQuery("SELECT CODE AS id FROM EG_EMPLOYEE emp  WHERE emp.CODE =(SELECT MAX(code) FROM EG_EMPLOYEE )  FOR UPDATE ").addScalar("id", (Type)IntegerType.INSTANCE);
            if (qry.list() != null && !qry.list().isEmpty()) {
                Integer obj2 = null;
                for (Integer obj2 : qry.list()) {
                    if (obj2 == null) {
                        id = 1;
                        continue;
                    }
                    id = obj2 + 1;
                }
            }
        }
        catch (HibernateException he) {
            LOGGER.error((Object)he);
            throw new ApplicationRuntimeException("Exception:" + he.getMessage(), (Throwable)he);
        }
        catch (Exception he) {
            LOGGER.error((Object)he);
            throw new ApplicationRuntimeException("Exception:" + he.getMessage(), (Throwable)he);
        }
        return String.valueOf(id);
    }

    @Override
    public String getEmployeeCode() {
        LOGGER.info((Object)("getNextValForCode" + this.getNextValForCode()));
        return this.getNextValForCode();
    }

    @Override
    public boolean checkPos(Integer posId, java.util.Date fromDate, java.util.Date toDate, Integer empId, String isPrimary) {
        boolean b = false;
        try {
            Query qry = null;
            if (fromDate != null && toDate != null) {
                String main = "from Assignment ev  where ev.isPrimary =:isPrimary and ev.position.id = :posId and ";
                if (empId != null) {
                    main = main + "ev.employee.idPersonalInformation <>:empId and ";
                }
                main = main + "((ev.toDate is null ) or  (ev.fromDate <= :fromDate and ev.toDate >= :toDate) or  (ev.toDate <= :toDate and ev.toDate >= :fromDate) or  (ev.fromDate >= :fromDate and ev.fromDate <= :toDate))  ";
                qry = this.getCurrentSession().createQuery(main);
            } else if (fromDate != null && toDate == null) {
                qry = this.getCurrentSession().createQuery("from Assignment ev  where ev.position.id = :posId and ((ev.toDate is null ) or (ev.fromDate <= :fromDate AND ev.toDate >= :fromDate))");
            }
            if (posId != null) {
                qry.setInteger("posId", posId.intValue());
            }
            if (empId != null) {
                qry.setInteger("empId", empId.intValue());
            }
            if (isPrimary != null) {
                qry.setCharacter("isPrimary", Character.valueOf(isPrimary.charAt(0)).charValue());
            }
            if (fromDate != null && toDate != null) {
                qry.setDate("fromDate", (java.util.Date)new Date(fromDate.getTime()));
                qry.setDate("toDate", (java.util.Date)new Date(toDate.getTime()));
            } else if (fromDate != null && toDate == null) {
                qry.setDate("fromDate", (java.util.Date)new Date(fromDate.getTime()));
            }
            if (qry.list() != null && !qry.list().isEmpty()) {
                b = true;
            }
        }
        catch (HibernateException he) {
            LOGGER.error((Object)he);
            throw new ApplicationRuntimeException("Exception:" + he.getMessage(), (Throwable)he);
        }
        catch (Exception he) {
            LOGGER.error((Object)he);
            throw new ApplicationRuntimeException("Exception:" + he.getMessage(), (Throwable)he);
        }
        return b;
    }

    @Override
    public List getListOfPersonalInformationByEmpIdsList(List empIdsList) {
        List list = null;
        try {
            if (empIdsList != null && !empIdsList.isEmpty()) {
                list = this.personalInformationDAO.getListOfPersonalInformationByEmpIdsList(empIdsList);
            }
        }
        catch (HibernateException he) {
            LOGGER.error((Object)he);
            throw new ApplicationRuntimeException("Exception:" + he.getMessage(), (Throwable)he);
        }
        catch (Exception he) {
            LOGGER.error((Object)he);
            throw new ApplicationRuntimeException("Exception:" + he.getMessage(), (Throwable)he);
        }
        return list;
    }

    @Override
    public List getListOfEmployeeWithoutAssignment(java.util.Date fromdate) {
        List list = null;
        try {
            list = this.assignmentDAO.getListOfEmployeeWithoutAssignment(fromdate);
        }
        catch (HibernateException he) {
            LOGGER.error((Object)he);
            throw new ApplicationRuntimeException("Exception:" + he.getMessage(), (Throwable)he);
        }
        catch (Exception he) {
            LOGGER.error((Object)he);
            throw new ApplicationRuntimeException("Exception:" + he.getMessage(), (Throwable)he);
        }
        return list;
    }

    @Override
    public Assignment getLatestAssignmentForEmployeeByToDate(Integer empId, java.util.Date todate) throws Exception {
        Assignment assignment = null;
        try {
            assignment = this.assignmentDAO.getLatestAssignmentForEmployeeByToDate(empId, todate);
        }
        catch (HibernateException he) {
            LOGGER.error((Object)he);
            throw new ApplicationRuntimeException("Exception:" + he.getMessage(), (Throwable)he);
        }
        catch (Exception he) {
            LOGGER.error((Object)he);
            throw new ApplicationRuntimeException("Exception:" + he.getMessage(), (Throwable)he);
        }
        return assignment;
    }

    @Override
    public PersonalInformation getEmployee(Integer deptId, Integer designationId, Long Boundaryid) throws TooManyValuesException, NoSuchObjectException {
        PersonalInformation personalInformation = null;
        try {
            if (deptId != 0 && deptId != null && designationId != 0 && designationId != null && Boundaryid != 0L && Boundaryid != null) {
                personalInformation = this.personalInformationDAO.getEmployee(deptId, designationId, Boundaryid);
            }
        }
        catch (Exception e) {
            throw new ApplicationRuntimeException("system.error", (Throwable)e);
        }
        return personalInformation;
    }

    @Override
    public PersonalInformation getEmployeeByFunctionary(Long deptId, Long designationId, Long Boundaryid, Integer functionaryId) throws TooManyValuesException, NoSuchObjectException {
        PersonalInformation personalInformation = null;
        try {
            if (deptId != 0L && deptId != null && designationId != 0L && designationId != null && Boundaryid != 0L && Boundaryid != null && functionaryId != 0 && functionaryId != null) {
                personalInformation = this.personalInformationDAO.getEmployeeByFunctionary(deptId, designationId, Boundaryid, functionaryId);
            }
        }
        catch (Exception e) {
            throw new ApplicationRuntimeException("system.error", (Throwable)e);
        }
        return personalInformation;
    }

    @Override
    public Assignment getLastAssignmentByEmp(Integer empId) {
        Assignment assignment = null;
        try {
            Iterator iter;
            String mainStr = "";
            mainStr = "select ev.assignment from EmployeeView ev  where ev.id = :empId and nvl(ev.toDate,sysdate) in(select max(nvl(ev1.toDate,sysdate)) from EmployeeView ev1 where ev1.id = :empId)";
            Query qry = this.getCurrentSession().createQuery(mainStr);
            if (empId != null) {
                qry.setInteger("empId", empId.intValue());
            }
            if (qry.list() != null && !qry.list().isEmpty() && (iter = qry.list().iterator()).hasNext()) {
                assignment = (Assignment)((Object)iter.next());
            }
        }
        catch (HibernateException he) {
            LOGGER.error((Object)he);
            throw new ApplicationRuntimeException("Exception:" + he.getMessage(), (Throwable)he);
        }
        catch (Exception he) {
            LOGGER.error((Object)he);
            throw new ApplicationRuntimeException("Exception:" + he.getMessage(), (Throwable)he);
        }
        return assignment;
    }

    @Override
    public ServiceHistory getServiceId(Integer id) {
        Query qry = this.getCurrentSession().createQuery("from ServiceHistory S where S.idService =:id ");
        qry.setInteger("id", id.intValue());
        return (ServiceHistory)qry.uniqueResult();
    }

    @Override
    public List<PersonalInformation> getAllEmpByGrade(Integer gradeId) {
        List<PersonalInformation> empList = null;
        try {
            empList = this.personalInformationDAO.getAllEmpByGrade(gradeId);
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
            throw new ApplicationRuntimeException("Exception:" + e.getMessage(), (Throwable)e);
        }
        return empList;
    }

    @Override
    public PersonalInformation getEmpForPositionAndDate(java.util.Date dateEntered, Integer posId) throws Exception {
        PersonalInformation personalInformation = null;
        try {
            Query qry = null;
            if (dateEntered != null) {
                qry = this.getCurrentSession().createQuery("select ev.id from EmployeeView ev  where ev.position = :posId and ((ev.toDate is null ) or (ev.fromDate <= :fromDate AND ev.toDate >= :fromDate))");
            } else if (dateEntered == null) {
                qry = this.getCurrentSession().createQuery("select ev.id from EmployeeView ev  where ev.position = :posId and ((ev.toDate is null ) or (ev.fromDate <=  TO_DATE(SYSDATE,'dd-MM-yyy') AND ev.toDate >=  TO_DATE(SYSDATE,'dd-MM-yyy')))");
            }
            if (posId != null) {
                qry.setInteger("posId", posId.intValue());
            }
            if (dateEntered != null) {
                qry.setDate("fromDate", (java.util.Date)new Date(dateEntered.getTime()));
            }
            if (qry.list() != null && !qry.list().isEmpty()) {
                for (Integer id : qry.list()) {
                    personalInformation = EisManagersUtill.getEmployeeService().getEmloyeeById(id);
                }
            }
        }
        catch (HibernateException he) {
            LOGGER.error((Object)he);
            throw new ApplicationRuntimeException("Exception:" + he.getMessage(), (Throwable)he);
        }
        catch (Exception he) {
            LOGGER.error((Object)he);
            throw new ApplicationRuntimeException("Exception:" + he.getMessage(), (Throwable)he);
        }
        return personalInformation;
    }

    @Override
    public List<PersonalInformation> getEmpListForPositionAndDate(java.util.Date dateEntered, Integer posId) throws Exception {
        PersonalInformation personalInformation = null;
        ArrayList<PersonalInformation> empList = null;
        try {
            Query qry = null;
            if (dateEntered != null) {
                qry = this.getCurrentSession().createQuery("select distinct ev.id from EmployeeView ev  where ev.position = :posId and ((ev.toDate is null ) or (ev.fromDate <= :fromDate AND ev.toDate >= :fromDate))");
            } else if (dateEntered == null) {
                qry = this.getCurrentSession().createQuery("select distinct ev.id from EmployeeView ev  where ev.position = :posId and ((ev.toDate is null ) or (ev.fromDate <=  TO_DATE(SYSDATE,'dd-MM-yyy') AND ev.toDate >=  TO_DATE(SYSDATE,'dd-MM-yyy')))");
            }
            if (posId != null) {
                qry.setInteger("posId", posId.intValue());
            }
            if (dateEntered != null) {
                qry.setDate("fromDate", (java.util.Date)new Date(dateEntered.getTime()));
            }
            if (qry.list() != null && !qry.list().isEmpty()) {
                empList = new ArrayList<PersonalInformation>();
                for (Integer id : qry.list()) {
                    personalInformation = EisManagersUtill.getEmployeeService().getEmloyeeById(id);
                    empList.add(personalInformation);
                }
            }
        }
        catch (HibernateException he) {
            LOGGER.error((Object)he);
            throw new ApplicationRuntimeException("Exception:" + he.getMessage(), (Throwable)he);
        }
        catch (Exception he) {
            LOGGER.error((Object)he);
            throw new ApplicationRuntimeException("Exception:" + he.getMessage(), (Throwable)he);
        }
        return empList;
    }

    @Override
    public List getAllDesignationByDept(Integer deptId) {
        Integer departmentId = deptId;
        List<Object> designationMstrObj = new ArrayList();
        designationMstrObj = this.eisService.getAllDesignationByDept(departmentId, new java.util.Date());
        return designationMstrObj;
    }

    @Override
    public List getAllActiveUsersByGivenDesg(Integer DesgId) throws Exception {
        List userList = null;
        try {
            if (DesgId != null && DesgId != 0) {
                userList = this.personalInformationDAO.getAllActiveUsersByGivenDesg(DesgId);
            }
        }
        catch (Exception e) {
            throw new ApplicationRuntimeException("system.error", (Throwable)e);
        }
        return userList;
    }

    @Override
    public List<EmployeeView> getEmployeeWithTempAssignment(java.util.Date givenDate, Integer posId) {
        List<EmployeeView> list = null;
        try {
            list = this.assignmentDAO.getEmployeeWithTempAssignment(givenDate, posId);
        }
        catch (HibernateException he) {
            throw new ApplicationRuntimeException("Exception:" + he.getMessage(), (Throwable)he);
        }
        catch (Exception he) {
            throw new ApplicationRuntimeException("Exception:" + he.getMessage(), (Throwable)he);
        }
        return list;
    }

    @Override
    public List<EmployeeView> getEmployeeWithTempAssignment(String code, java.util.Date givenDate, Integer posId) {
        List<EmployeeView> list = null;
        try {
            list = this.assignmentDAO.getEmployeeWithTempAssignment(code, givenDate, posId);
        }
        catch (HibernateException he) {
            throw new ApplicationRuntimeException("Exception:" + he.getMessage(), (Throwable)he);
        }
        catch (Exception he) {
            throw new ApplicationRuntimeException("Exception:" + he.getMessage(), (Throwable)he);
        }
        return list;
    }

    @Override
    public List getEmpTempAssignment(String code, java.util.Date givenDate, Integer posId) {
        List assignment = null;
        try {
            String mainStr = "";
            mainStr = "from Assignment ev  where ev.isPrimary='N'";
            if (code != null && !code.equals("")) {
                mainStr = mainStr + "and ev.employee.employeeCode =:code ";
            }
            if (givenDate != null) {
                mainStr = mainStr + " and ev.fromDate <= :givenDate and ev.toDate >=:givenDate";
            }
            if (posId != null && posId != 0) {
                mainStr = mainStr + " and ev.position.id =:posId ";
            }
            Query qry = this.getCurrentSession().createQuery(mainStr);
            if (code != null && !code.equals("")) {
                qry.setString("code", code);
            }
            if (givenDate != null) {
                qry.setDate("givenDate", givenDate);
            }
            if (posId != null && posId != 0) {
                qry.setInteger("posId", posId.intValue());
            }
            assignment = qry.list();
        }
        catch (HibernateException he) {
            LOGGER.error((Object)he);
            throw new ApplicationRuntimeException("Exception:" + he.getMessage(), (Throwable)he);
        }
        catch (Exception he) {
            LOGGER.error((Object)he);
            throw new ApplicationRuntimeException("Exception:" + he.getMessage(), (Throwable)he);
        }
        return assignment;
    }

    @Override
    public List<Integer> getAssignmentsForEmp(Integer empId, java.util.Date givenDate) throws ApplicationException {
        Object list = null;
        SQLQuery query = null;
        try {
            StringBuffer stringbuffer = new StringBuffer(" select \tASS_ID  from EG_EIS_EMPLOYEEINFO ev  where ev.ID = :empId");
            if (empId == null) {
                throw new ApplicationException("EmployeeId  Not provided");
            }
            if (givenDate == null) {
                stringbuffer.append(" and ((ev.to_Date is null and ev.from_Date <= SYSDATE ) OR (ev.from_Date <= SYSDATE AND ev.to_Date >= SYSDATE))");
            } else {
                stringbuffer.append(" and  ev.from_Date <= :givenDate AND ev.to_Date >= :givenDate");
            }
            query = this.getCurrentSession().createSQLQuery(stringbuffer.toString()).addScalar("ASS_ID", (Type)IntegerType.INSTANCE);
            if (query.getQueryString().contains(":givenDate")) {
                query.setDate("givenDate", givenDate);
            }
            query.setInteger("empId", empId.intValue());
        }
        catch (HibernateException hibException) {
            LOGGER.error((Object)hibException.getMessage());
            throw new ApplicationException("HibernateException:" + hibException.getMessage(), (Throwable)hibException);
        }
        return query.list();
    }

    @Override
    public List<Position> getPositionsForUser(User user, java.util.Date date) throws ApplicationException {
        ArrayList<Position> positionList = new ArrayList<Position>();
        Integer pos2 = null;
        try {
            String mainStr = "";
            mainStr = "select a.position.id from Assignment a where a.employee.userMaster.id =:userId";
            mainStr = date != null ? mainStr + " and ((a.toDate is null and a.fromDate<= :date) or (a.fromDate <= :date and a.toDate >= :date))" : mainStr + " and ((a.toDate is null and a.fromDate<= TO_DATE(SYSDATE,'dd-MM-yyy')) or (a.fromDate <= TO_DATE(SYSDATE,'dd-MM-yyy') and a.toDate >= TO_DATE(SYSDATE,'dd-MM-yyy')))";
            Query qry = this.getCurrentSession().createQuery(mainStr);
            if (user != null) {
                qry.setLong("userId", user.getId().longValue());
            }
            if (date != null) {
                qry.setDate("date", date);
            }
            if (qry.list() != null && !qry.list().isEmpty()) {
                for (Integer pos2 : qry.list()) {
                    Position position = EisManagersUtill.getEisCommonsService().getPositionById(pos2);
                    positionList.add(position);
                }
            }
        }
        catch (HibernateException he) {
            LOGGER.error((Object)he);
            throw new ApplicationRuntimeException("Exception:" + he.getMessage(), (Throwable)he);
        }
        catch (Exception he) {
            LOGGER.error((Object)he);
            throw new ApplicationRuntimeException("Exception:" + he.getMessage(), (Throwable)he);
        }
        return positionList;
    }

    @Override
    public List getEmpPrimaryAssignment(String code, java.util.Date givenDate, Integer posId) {
        List assignment = null;
        try {
            String mainStr = "";
            mainStr = "from Assignment ev  where ev.isPrimary='Y'";
            if (code != null && !code.equals("")) {
                mainStr = mainStr + "and ev.employee.employeeCode =:code ";
            }
            if (givenDate != null) {
                mainStr = mainStr + " and ev.fromDate <= :givenDate and ev.toDate >=:givenDate";
            }
            if (posId != null && posId != 0) {
                mainStr = mainStr + " and ev.position.id =:posId ";
            }
            Query qry = this.getCurrentSession().createQuery(mainStr);
            if (code != null && !code.equals("")) {
                qry.setString("code", code);
            }
            if (givenDate != null) {
                qry.setDate("givenDate", givenDate);
            }
            if (posId != null && posId != 0) {
                qry.setInteger("posId", posId.intValue());
            }
            assignment = qry.list();
        }
        catch (HibernateException he) {
            LOGGER.error((Object)he);
            throw new ApplicationRuntimeException("Exception:" + he.getMessage(), (Throwable)he);
        }
        catch (Exception he) {
            LOGGER.error((Object)he);
            throw new ApplicationRuntimeException("Exception:" + he.getMessage(), (Throwable)he);
        }
        return assignment;
    }

    @Override
    public List searchEmployee(Integer status, java.util.Date fromDate, java.util.Date toDate) throws Exception {
        List employeeList = new ArrayList();
        String mainStr = "";
        try {
            EgwStatus statusType = this.egwStatusHibernateDAO.findById(status, false);
            if (statusType.getModuletype().equals("Employee") && statusType.getDescription().equals("Employed")) {
                if (status != 0) {
                    mainStr = "from Assignment ev where ev.employee.StatusMaster.id =:employeeStatus";
                }
                if (fromDate != null && toDate != null) {
                    mainStr = mainStr + " and ev.dateOfFirstAppointment >= :fromDate  and ev.dateOfFirstAppointment <= :toDate  and ((ev.fromDate<=sysdate and ev.toDate >=sysdate)  or (ev.fromDate in (select max(prd.fromDate) from Assignment prd where ev.employee.idPersonalInformation = prd.employee.idPersonalInformation  and not exists (select prd1.id from Assignment prd1 where prd1.employee.idPersonalInformation=ev.assignment.employee.idPersonalInformation  and ( prd1.dateOfFirstAppointment >= :fromDate and prd1.dateOfFirstAppointment <= :toDate and prd1.fromDate<= sysdate and prd1.toDate >= sysdate) )))) ";
                }
            } else if (statusType.getModuletype().equals("Employee") && statusType.getDescription().equals("Retired")) {
                if (status != 0) {
                    mainStr = "from Assignment ev where ev.employee.StatusMaster.id =:employeeStatus";
                }
                if (fromDate != null && toDate != null) {
                    mainStr = mainStr + " and ev.assignmentPrd.employeeId.retirementDate >= :fromDate  and ev.employee.retirementDate <= :toDate  and ((ev.fromDate<=sysdate and ev.toDate >=sysdate)  or (ev.fromDate in (select max(prd.fromDate) from Assignment prd where ev.employee.idPersonalInformation = prd.employee.idPersonalInformation  and not exists (select prd1.id from Assignment prd1 where prd1.employee.idPersonalInformation=ev.employee.idPersonalInformation  and ( prd1.employee.retirementDate >= :fromDate and prd1.employee.retirementDate <= :toDate and prd1.fromDate<= sysdate and prd1.toDate >= sysdate) )))) ";
                }
            } else if (statusType.getModuletype().equals("Employee") && statusType.getDescription().equals("Deceased")) {
                if (status != 0) {
                    mainStr = "from Assignment ev where ev.employee.StatusMaster.id =:employeeStatus";
                }
                if (fromDate != null && toDate != null) {
                    mainStr = mainStr + " and ev.employee.deathDate >= :fromDate  and ev.employee.deathDate <= :toDate  and ((ev.fromDate<=sysdate and ev.toDate >=sysdate)  or (ev.fromDate in (select max(prd.fromDate) from Assignment prd where ev.employee.idPersonalInformation = prd.employee.idPersonalInformation  and not exists (select prd1.id from Assignment prd1 where prd1.employee.idPersonalInformation=ev.employee.idPersonalInformation  and ( prd1.employee.deathDate >= :fromDate and prd1.employee.deathDate <= :toDate and prd1.fromDate<= sysdate and prd1.toDate >= sysdate) )))) ";
                }
            }
            Query qry = null;
            qry = this.getCurrentSession().createQuery(mainStr);
            logger.info((Object)("Query----" + qry.toString()));
            if (status != 0) {
                qry.setInteger("employeeStatus", status.intValue());
            }
            if (fromDate != null) {
                qry.setDate("fromDate", (java.util.Date)new Date(fromDate.getTime()));
            }
            if (toDate != null) {
                qry.setDate("toDate", (java.util.Date)new Date(toDate.getTime()));
            }
            employeeList = qry.list();
        }
        catch (HibernateException he) {
            throw new ApplicationRuntimeException("Exception:" + he.getMessage(), (Throwable)he);
        }
        catch (Exception he) {
            throw new ApplicationRuntimeException("Exception:" + he.getMessage(), (Throwable)he);
        }
        return employeeList;
    }

    @Override
    public List getListOfDeptBasedOnUserDept(String userName) {
        ArrayList<Department> deptList = new ArrayList<Department>();
        try {
            Query qry = null;
            if (userName != null) {
                qry = this.getCurrentSession().createQuery("from Department where id in (select deptId.id from Assignment where userName=:userName  and fromDate <= sysdate and toDate >= sysdate )");
            }
            if (userName != null) {
                qry.setString("userName", userName);
            }
            if (qry != null && qry.list() != null && !qry.list().isEmpty()) {
                for (Department deptImpl : qry.list()) {
                    deptList.add(deptImpl);
                }
            }
        }
        catch (Exception e) {
            throw new ApplicationRuntimeException("Exception:" + e.getMessage(), (Throwable)e);
        }
        return deptList;
    }

    @Override
    public boolean isFilterByDept() {
        boolean isFilterByDept = false;
        String filterByDept = "NO";
        AppConfigValues configValue = this.appConfigValuesService.getAppConfigValueByDate("EIS-PAYROLL", "FILTERBYDEPT", new java.util.Date());
        if (null != configValue) {
            filterByDept = configValue.getValue();
            filterByDept = filterByDept.toUpperCase();
        }
        if ("YES".equals(filterByDept)) {
            isFilterByDept = true;
        }
        return isFilterByDept;
    }

    @Override
    public List<EmployeeView> getEmployeeInfoBasedOnDeptAndDesg(Integer deptId, Integer desgId) {
        ArrayList employeeList = new ArrayList();
        Criteria criteria = this.getCurrentSession().createCriteria(EmployeeView.class).createAlias("deptId", "department").createAlias("desigId", "designation").add((Criterion)Restrictions.eq((String)"department.id", (Object)deptId)).add((Criterion)Restrictions.eq((String)"designation.designationId", (Object)desgId)).add((Criterion)Restrictions.and((Criterion)Restrictions.le((String)"fromDate", (Object)new java.util.Date()), (Criterion)Restrictions.ge((String)"toDate", (Object)new java.util.Date()))).add((Criterion)Restrictions.eq((String)"isPrimary", (Object)Character.valueOf('Y'))).add((Criterion)Restrictions.eq((String)"isActive", (Object)1));
        return criteria.list();
    }

    @Override
    public List<EmployeeView> getEmployeeInfoBasedOnDeptAndDate(Integer deptId, java.util.Date date) {
        if (date == null) {
            date = new java.util.Date();
        }
        ArrayList employeeList = new ArrayList();
        Criteria criteria = this.getCurrentSession().createCriteria(EmployeeView.class).createAlias("deptId", "department").add((Criterion)Restrictions.eq((String)"department.id", (Object)deptId)).add((Criterion)Restrictions.eq((String)"isActive", (Object)1)).add((Criterion)Restrictions.and((Criterion)Restrictions.le((String)"fromDate", (Object)date), (Criterion)Restrictions.ge((String)"toDate", (Object)date)));
        criteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
        return criteria.list();
    }

    @Override
    public List<PersonalInformation> getAllEmployees() {
        return this.getCurrentSession().createQuery("select distinct employee from EmployeeView empview  where (sysdate between empview.fromDate  and empview.toDate or  (empview.toDate is null and empview.fromDate<=sysdate))").list();
    }

    @Override
    public List getListOfUsersNotMappedToEmp() {
        List empUserMapList = null;
        try {
            empUserMapList = this.personalInformationDAO.getListOfUsersNotMappedToEmp();
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
            throw new ApplicationRuntimeException("Exception:" + e.getMessage(), (Throwable)e);
        }
        return empUserMapList;
    }

    @Override
    public Designation getPresentDesignation(Integer idPersonalInformation) {
        Assignment assignment = this.getLatestAssignmentForEmployee(idPersonalInformation);
        return assignment.getDesignation();
    }

    public EisUtilService getEisService() {
        return this.eisService;
    }

    public void setEisService(EisUtilService eisService) {
        this.eisService = eisService;
    }

    public PersonalInformationDAO getPersonalInformationDAO() {
        return this.personalInformationDAO;
    }

    public void setPersonalInformationDAO(PersonalInformationDAO personalInformationDAO) {
        this.personalInformationDAO = personalInformationDAO;
    }

    public AssignmentDAO getAssignmentDAO() {
        return this.assignmentDAO;
    }

    public void setAssignmentDAO(AssignmentDAO assignmentDAO) {
        this.assignmentDAO = assignmentDAO;
    }

    public AppConfigValueService getAppConfigValuesService() {
        return this.appConfigValuesService;
    }

    public void setAppConfigValuesService(AppConfigValueService appConfigValuesService) {
        this.appConfigValuesService = appConfigValuesService;
    }
}

