/*
 * Decompiled with CFR 0.152.
 */
package org.egov.eis.entity;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.egov.commons.EgwStatus;
import org.egov.commons.utils.EntityType;
import org.egov.eis.entity.Assignment;
import org.egov.eis.entity.EmployeeType;
import org.egov.eis.entity.Jurisdiction;
import org.egov.eis.entity.enums.EmployeeStatus;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.persistence.entity.enums.UserType;
import org.egov.infra.persistence.validator.annotation.Unique;
import org.hibernate.envers.AuditOverride;
import org.hibernate.envers.AuditOverrides;
import org.hibernate.envers.Audited;
import org.hibernate.envers.NotAudited;
import org.hibernate.envers.RelationTargetAuditMode;
import org.hibernate.validator.constraints.SafeHtml;
import org.joda.time.DateTime;

@Entity
@Table(name="egeis_employee")
@Unique(fields={"code"}, enableDfltMsg=true)
@Audited(targetAuditMode=RelationTargetAuditMode.NOT_AUDITED)
@AuditOverrides(value={@AuditOverride(forClass=User.class, name="name"), @AuditOverride(forClass=User.class, name="mobileNumber"), @AuditOverride(forClass=User.class, name="emailId")})
public class Employee
extends User
implements EntityType {
    private static final long serialVersionUID = -1105585841211211215L;
    @NotNull
    @SafeHtml
    @Column(name="code", unique=true)
    @Pattern(regexp="[0-9a-zA-Z]+")
    @NotAudited
    private String code;
    @Temporal(value=TemporalType.DATE)
    @NotAudited
    private Date dateOfAppointment;
    @Temporal(value=TemporalType.DATE)
    @NotAudited
    private Date dateOfRetirement;
    @Enumerated(value=EnumType.STRING)
    @NotAudited
    private EmployeeStatus employeeStatus;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="employeetype")
    @NotAudited
    private EmployeeType employeeType;
    @OneToMany(mappedBy="employee", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    @OrderBy(value=" primary desc,toDate DESC ")
    @NotAudited
    private final List<Assignment> assignments = new ArrayList<Assignment>(0);
    @OneToMany(mappedBy="employee", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    @OrderBy(value="id DESC ")
    @NotAudited
    private final List<Jurisdiction> jurisdictions = new ArrayList<Jurisdiction>(0);

    public Employee() {
        this.setType(UserType.EMPLOYEE);
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public DateTime getDateOfAppointment() {
        return null == this.dateOfAppointment ? null : new DateTime((Object)this.dateOfAppointment);
    }

    public void setDateOfAppointment(DateTime dateOfAppointment) {
        this.dateOfAppointment = null == dateOfAppointment ? null : dateOfAppointment.toDate();
    }

    public DateTime getDateOfRetirement() {
        return null == this.dateOfRetirement ? null : new DateTime((Object)this.dateOfRetirement);
    }

    public void setDateOfRetirement(DateTime dateOfRetirement) {
        this.dateOfRetirement = null == dateOfRetirement ? null : dateOfRetirement.toDate();
    }

    public EmployeeStatus getEmployeeStatus() {
        return this.employeeStatus;
    }

    public void setEmployeeStatus(EmployeeStatus employeeStatus) {
        this.employeeStatus = employeeStatus;
    }

    public EmployeeType getEmployeeType() {
        return this.employeeType;
    }

    public void setEmployeeType(EmployeeType employeeType) {
        this.employeeType = employeeType;
    }

    public List<Assignment> getAssignments() {
        return this.assignments;
    }

    public void setAssignments(List<Assignment> assignments) {
        this.assignments.clear();
        if (assignments != null) {
            this.assignments.addAll(assignments);
        }
    }

    public List<Jurisdiction> getJurisdictions() {
        return this.jurisdictions;
    }

    public void setJurisdictions(List<Jurisdiction> jurisdictions) {
        this.jurisdictions.clear();
        if (jurisdictions != null) {
            this.jurisdictions.addAll(jurisdictions);
        }
    }

    public String getBankname() {
        return null;
    }

    public String getBankaccount() {
        return null;
    }

    public String getPanno() {
        return null;
    }

    public String getTinno() {
        return null;
    }

    public String getIfsccode() {
        return null;
    }

    public String getModeofpay() {
        return null;
    }

    public Integer getEntityId() {
        return this.getId().intValue();
    }

    public String getEntityDescription() {
        return this.getName();
    }

    public EgwStatus getEgwStatus() {
        return null;
    }
}

