/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pims.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.log4j.Logger;
import org.egov.commons.exception.NoSuchObjectException;
import org.egov.eis.entity.EmployeeView;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.pims.dao.PersonalInformationHibernateDAO;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.springframework.stereotype.Service;

@Service
public class SearchPositionService {
    private static final Logger logger = Logger.getLogger(SearchPositionService.class);
    @PersistenceContext
    private EntityManager entityManager;

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    public List<EmployeeView> getPositionBySearchParameters(String beginsWith, Integer desId, Integer deptId, Long jurdId, Integer roleId, Date userDate, Integer maxResults) throws NoSuchObjectException {
        ArrayList<EmployeeView> posList = new ArrayList();
        logger.debug((Object)("inside getPositionBySearchParameters method ***********" + desId));
        String searchQuery = "";
        List userListInJur = null;
        String myBeginsWith = beginsWith;
        if (myBeginsWith == null) {
            myBeginsWith = "";
        }
        if (jurdId != null) {
            PersonalInformationHibernateDAO personalInformationHibernateDAO = new PersonalInformationHibernateDAO();
        }
        try {
            searchQuery = "Select EV from EmployeeView EV,Position P where EV.position.id=P.id  and trim(upper(P.name))  like '" + myBeginsWith.trim().toUpperCase() + "%' and " + " ((EV.toDate IS NULL AND EV.fromDate <= :userDate)OR(EV.fromDate <= :userDate AND EV.toDate >= :userDate))and EV.userActive ='1'";
            if (userListInJur != null && !userListInJur.isEmpty()) {
                searchQuery = searchQuery + "and EV.userMaster in (:bndryObjList)    ";
            }
            if (desId != null && desId != 0) {
                searchQuery = searchQuery + " and EV.designation.id = :desId  ";
            }
            if (deptId != null && deptId != 0) {
                searchQuery = searchQuery + " and EV.department.id= :deptId ";
            }
            if (roleId != null && roleId != null) {
                searchQuery = searchQuery + " and EV.employee.id IN ( Select U.user.id from UserRole U where U.role.id=:roleId and U.isHistory='N'and ((U.toDate IS NULL AND U.fromDate <= :userDate)OR(U.fromDate <= :userDate AND U.toDate > :userDate)))";
            }
            Query query = this.getCurrentSession().createQuery(searchQuery);
            logger.info((Object)("quey >>>" + query.toString()));
            if (userListInJur != null && !userListInJur.isEmpty()) {
                query.setParameterList("bndryObjList", (Collection)userListInJur);
            }
            if (desId != null && desId != 0) {
                query.setInteger("desId", desId.intValue());
            }
            if (deptId != null && deptId != 0) {
                query.setInteger("deptId", deptId.intValue());
            }
            if (userDate != null) {
                query.setDate("userDate", userDate);
            }
            if (roleId != null && roleId != null) {
                query.setInteger("roleId", roleId.intValue());
            }
            posList = query.list();
        }
        catch (HibernateException h) {
            throw new ApplicationRuntimeException("Exception:" + h.getMessage(), (Throwable)h);
        }
        return posList;
    }
}

