/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pims.dao;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.log4j.Logger;
import org.egov.eis.entity.Assignment;
import org.egov.eis.entity.EmployeeView;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.pims.dao.AssignmentDAO;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.springframework.transaction.annotation.Transactional;

public class AssignmentHibernateDAO
implements AssignmentDAO {
    private static final Logger LOGGER = Logger.getLogger(AssignmentHibernateDAO.class.getClass());
    @PersistenceContext
    private EntityManager entityManager;
    private static final String STR_EXCEPTION = "Exception:";

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    @Override
    public Assignment getAssignmentById(Integer id) {
        return (Assignment)((Object)this.getCurrentSession().get(Assignment.class, (Serializable)id));
    }

    @Override
    public List getListOfEmployeeWithoutAssignment(Date fromdate) {
        List employeeAssignList = null;
        try {
            StringBuffer query = new StringBuffer(" select distinct ev.id from EmployeeView ev where ev.isActive=1 and  (ev.fromDate > :fromdate OR ev.toDate < :fromdate) AND (ev.dateOfFirstAppointment <= :fromdate) and (ev.id not in (select ev.id from  ev where (ev.fromDate <= :fromdate and ev.toDate >=:fromdate)))");
            Query qry = this.getCurrentSession().createQuery(query.toString());
            qry.setDate("fromdate", fromdate);
            employeeAssignList = qry.list();
        }
        catch (HibernateException he) {
            LOGGER.error((Object)he.getMessage());
            throw new ApplicationRuntimeException(STR_EXCEPTION + he.getMessage(), (Throwable)he);
        }
        catch (Exception he) {
            LOGGER.error((Object)he.getMessage());
            throw new ApplicationRuntimeException(STR_EXCEPTION + he.getMessage(), (Throwable)he);
        }
        return employeeAssignList;
    }

    @Override
    public Assignment getLatestAssignmentForEmployeeByToDate(Integer empId, Date todate) throws Exception {
        Assignment assignment = null;
        try {
            StringBuffer query = new StringBuffer(" select  ev.assignment from EmployeeView ev where ev.assignment.isPrimary = 'Y' and ev.id = :empid and ev.fromDate <= :todate and rownum=1 order by ev.toDate desc ");
            Query qry = this.getCurrentSession().createQuery(query.toString());
            qry.setDate("todate", todate);
            qry.setInteger("empid", empId.intValue());
            assignment = (Assignment)((Object)qry.uniqueResult());
        }
        catch (HibernateException he) {
            LOGGER.error((Object)he.getMessage());
            throw new ApplicationRuntimeException(STR_EXCEPTION + he.getMessage(), (Throwable)he);
        }
        catch (Exception he) {
            LOGGER.error((Object)he.getMessage());
            throw new ApplicationRuntimeException(STR_EXCEPTION + he.getMessage(), (Throwable)he);
        }
        return assignment;
    }

    @Override
    public List<EmployeeView> getEmployeeWithTempAssignment(Date givenDate, Integer posId) {
        List employeeAssignList = null;
        try {
            StringBuffer query = null;
            query = new StringBuffer("from EmployeeView ev where ev.isActive=1 and ev.assignment.isPrimary='N'");
            if (givenDate != null) {
                query.append(" and ev.fromDate <= :givenDate and ev.toDate >=:givenDate");
            }
            if (posId != null && posId != 0) {
                query.append(" and ev.position.id =:posId ");
            }
            Query qry = this.getCurrentSession().createQuery(query.toString());
            if (givenDate != null) {
                qry.setDate("givenDate", givenDate);
            }
            if (posId != null && posId != 0) {
                qry.setInteger("posId", posId.intValue());
            }
            employeeAssignList = qry.list();
        }
        catch (HibernateException he) {
            LOGGER.error((Object)he.getMessage());
            throw new ApplicationRuntimeException(STR_EXCEPTION + he.getMessage(), (Throwable)he);
        }
        catch (Exception he) {
            LOGGER.error((Object)he.getMessage());
            throw new ApplicationRuntimeException(STR_EXCEPTION + he.getMessage(), (Throwable)he);
        }
        return employeeAssignList;
    }

    @Override
    public List<EmployeeView> getEmployeeWithTempAssignment(String code, Date givenDate, Integer posId) {
        List employeeAssignList = null;
        try {
            StringBuffer query = null;
            query = new StringBuffer("from EmployeeView ev where ev.isActive=true and ev.assignment.isPrimary='N'");
            if (code != null && !code.equals("")) {
                query.append(" and upper(trim(ev.employeeCode)) = :code");
            }
            if (givenDate == null && posId == 0) {
                query.append(" and ((ev.toDate IS NULL AND ev.fromDate <= SYSDATE) OR (ev.fromDate <= SYSDATE AND ev.toDate > SYSDATE)OR (ev.fromDate IN (SELECT MAX (evn.fromDate)  FROM EmployeeView  evn WHERE evn.id = ev.id  and evn.assignment.isPrimary='N'))) ");
            } else {
                if (givenDate != null) {
                    query.append(" and ev.fromDate <= :givenDate and ev.toDate >=:givenDate");
                }
                if (posId != null && posId != 0) {
                    query.append(" and ev.position.id =:posId ");
                }
            }
            Query qry = this.getCurrentSession().createQuery(query.toString());
            if (givenDate != null) {
                qry.setDate("givenDate", givenDate);
            }
            if (posId != null && posId != 0) {
                qry.setInteger("posId", posId.intValue());
            }
            if (code != null && !code.equals("")) {
                qry.setString("code", code);
            }
            employeeAssignList = qry.list();
        }
        catch (HibernateException he) {
            LOGGER.error((Object)he.getMessage());
            throw new ApplicationRuntimeException(STR_EXCEPTION + he.getMessage(), (Throwable)he);
        }
        catch (Exception he) {
            LOGGER.error((Object)he.getMessage());
            throw new ApplicationRuntimeException(STR_EXCEPTION + he.getMessage(), (Throwable)he);
        }
        return employeeAssignList;
    }

    @Override
    @Transactional
    public void create(Assignment egEmpAssignment) {
        this.getCurrentSession().save((Object)egEmpAssignment);
    }

    @Override
    @Transactional
    public void update(Assignment assignment) {
        this.getCurrentSession().update((Object)assignment);
    }
}

