/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pims.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infstr.utils.EgovMasterDataCaching;
import org.egov.pims.service.EmployeeServiceOld;
import org.springframework.beans.factory.annotation.Autowired;

public class BeforeGenericMasterAction
extends DispatchAction {
    public static final Logger LOGGER = Logger.getLogger(BeforeGenericMasterAction.class.getClass());
    private EmployeeServiceOld employeeService;
    @Autowired
    private EgovMasterDataCaching masterDataCache;
    private static final String STR_VIEWMODE = "viewMode";
    private static final String STR_CLASSNAME = "className";
    private static final String STR_EXCEPTION = "Exception:";
    private static final String STR_ERROR = "error";

    public ActionForward beforeCreate(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        String target = "";
        try {
            this.saveToken(req);
            this.populate(req);
            req.getSession().setAttribute(STR_VIEWMODE, (Object)"create");
            String className = "";
            className = req.getParameter(STR_CLASSNAME).trim();
            req.getSession().setAttribute(STR_CLASSNAME, (Object)className);
            LOGGER.debug((Object)(">>> inside beforCreate" + className));
            target = "createScreen";
            LOGGER.debug((Object)(">>> inside beforCreate" + target));
        }
        catch (Exception e) {
            target = STR_ERROR;
            LOGGER.error((Object)e.getMessage());
            throw new ApplicationRuntimeException(STR_EXCEPTION + e.getMessage(), (Throwable)e);
        }
        return mapping.findForward(target);
    }

    public ActionForward beforeModify(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        String target = "";
        try {
            LOGGER.debug((Object)(">>> inside beforeModify" + req.getParameter("submitType")));
            this.populate(req);
            String className = "";
            className = req.getParameter(STR_CLASSNAME).trim();
            req.getSession().setAttribute(STR_CLASSNAME, (Object)className);
            target = "modify";
            req.getSession().setAttribute("mode", (Object)"modify");
        }
        catch (Exception e) {
            target = STR_ERROR;
            LOGGER.error((Object)e.getMessage());
            throw new ApplicationRuntimeException(STR_EXCEPTION + e.getMessage(), (Throwable)e);
        }
        return mapping.findForward(target);
    }

    public ActionForward beforeView(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        String target = "";
        try {
            this.populate(req);
            String className = "";
            className = req.getParameter(STR_CLASSNAME).trim();
            req.getSession().setAttribute(STR_CLASSNAME, (Object)className);
            target = "view";
            req.getSession().setAttribute("mode", (Object)"view");
        }
        catch (Exception e) {
            target = STR_ERROR;
            LOGGER.error((Object)e.getMessage());
            throw new ApplicationRuntimeException(STR_EXCEPTION + e.getMessage(), (Throwable)e);
        }
        return mapping.findForward(target);
    }

    public ActionForward beforeDelete(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        String target = "";
        try {
            String className = "";
            className = req.getParameter(STR_CLASSNAME).trim();
            req.getSession().setAttribute(STR_CLASSNAME, (Object)className);
            target = "delete";
            this.populate(req);
            req.getSession().setAttribute("mode", (Object)"delete");
        }
        catch (Exception e) {
            target = STR_ERROR;
            LOGGER.error((Object)e.getMessage());
            throw new ApplicationRuntimeException(STR_EXCEPTION + e.getMessage(), (Throwable)e);
        }
        return mapping.findForward(target);
    }

    public ActionForward setIdForDetails(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        String target = "";
        try {
            LOGGER.debug((Object)(">>> req.getParameter(Id) " + req.getParameter("Id") + " mode  " + req.getParameter(STR_VIEWMODE)));
            req.getSession().setAttribute("Id", (Object)req.getParameter("Id"));
            req.getSession().setAttribute(STR_VIEWMODE, (Object)req.getParameter(STR_VIEWMODE));
            String className = "";
            className = req.getParameter(STR_CLASSNAME).trim();
            req.getSession().setAttribute(STR_CLASSNAME, (Object)className);
            target = "createScreenSubmit";
        }
        catch (Exception e) {
            target = STR_ERROR;
            LOGGER.error((Object)e.getMessage());
            throw new ApplicationRuntimeException(STR_EXCEPTION + e.getMessage(), (Throwable)e);
        }
        return mapping.findForward(target);
    }

    private void populate(HttpServletRequest req) {
        try {
            HashMap<String, Map> genericMap = new HashMap<String, Map>();
            ArrayList statusMasterList = (ArrayList)this.masterDataCache.get("egEmp-EmployeeStatusMaster");
            genericMap.put("EmployeeStatusMaster", this.employeeService.getMapForList(statusMasterList));
            ArrayList gradeMasterList = (ArrayList)this.masterDataCache.get("egEmp-GradeMaster");
            genericMap.put("GradeMaster", this.employeeService.getMapForList(gradeMasterList));
            ArrayList bloodGroupList = (ArrayList)this.masterDataCache.get("egEmp-BloodGroupMaster");
            genericMap.put("BloodGroupMaster", this.employeeService.getMapForList(bloodGroupList));
            ArrayList catMasterList = (ArrayList)this.masterDataCache.get("egEmp-CategoryMaster");
            genericMap.put("CategoryMaster", this.employeeService.getMapForList(catMasterList));
            ArrayList commMasterList = (ArrayList)this.masterDataCache.get("egEmp-CommunityMaster");
            genericMap.put("CommunityMaster", this.employeeService.getMapForList(commMasterList));
            ArrayList langKnownMasterList = (ArrayList)this.masterDataCache.get("egEmp-LanguagesKnownMaster");
            genericMap.put("LanguagesKnownMaster", this.employeeService.getMapForList(langKnownMasterList));
            ArrayList langQualiMasterList = (ArrayList)this.masterDataCache.get("egEmp-LanguagesQulifiedMaster");
            genericMap.put("LanguagesQulifiedMaster", this.employeeService.getMapForList(langQualiMasterList));
            ArrayList recruimentMasterMasterList = (ArrayList)this.masterDataCache.get("egEmp-RecruimentMaster");
            genericMap.put("RecruimentMaster", this.employeeService.getMapForList(recruimentMasterMasterList));
            ArrayList religionMasterList = (ArrayList)this.masterDataCache.get("egEmp-ReligionMaster");
            genericMap.put("ReligionMaster", this.employeeService.getMapForList(religionMasterList));
            ArrayList typeOfRecMasterList = (ArrayList)this.masterDataCache.get("egEmp-TypeOfRecruimentMaster");
            genericMap.put("TypeOfRecruimentMaster", this.employeeService.getMapForList(typeOfRecMasterList));
            genericMap.put("genericTable", this.getMap());
            genericMap.put("genericName", this.getNameMap());
            req.getSession().setAttribute("genericMap", genericMap);
        }
        catch (ApplicationRuntimeException e) {
            LOGGER.error((Object)e.getMessage());
            throw new ApplicationRuntimeException(STR_EXCEPTION + e.getMessage(), (Throwable)e);
        }
    }

    private Map getMap() {
        try {
            HashMap<String, String> m = new HashMap<String, String>();
            m.put("ReligionMaster", "EGEIS_RELIGION_MSTR");
            m.put("LanguagesQulifiedMaster", "EGEIS_LOCAL_LANG_QUL_MSTR");
            m.put("LanguagesKnownMaster", "EGEIS_LANGUAGES_KNOWN_MSTR");
            m.put("CommunityMaster", "EGEIS_COMMUNITY_MSTR");
            m.put("CategoryMaster", "EGEIS_CATEGORY_MSTR");
            m.put("BloodGroupMaster", "EGEIS_BLOODGROUP");
            m.put("GradeMaster", "EGEIS_GRADE_MSTR");
            m.put("TypeOfRecruimentMaster", "EGEIS_RECRUITMENT_TYPE_MSTR");
            m.put("RecruimentMaster", "EGEIS_MODE_OF_RECRUIMENT_MSTR");
            m.put("EmployeeStatusMaster", "EGEIS_STATUS_MASTER");
            return m;
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage());
            throw new ApplicationRuntimeException(STR_EXCEPTION + e.getMessage(), (Throwable)e);
        }
    }

    private Map getNameMap() {
        try {
            HashMap<String, String> m = new HashMap<String, String>();
            m.put("ReligionMaster", "Religion");
            m.put("LanguagesQulifiedMaster", "Local Languages Qualified");
            m.put("LanguagesKnownMaster", "Languages Known");
            m.put("CommunityMaster", "Community");
            m.put("CategoryMaster", "Category");
            m.put("BloodGroupMaster", "Blood Group");
            m.put("GradeMaster", "Grade");
            m.put("TypeOfRecruimentMaster", "AttendenceType Of Recruiment");
            m.put("RecruimentMaster", "Mode Of Recruiment");
            m.put("EmployeeStatusMaster", "Employee Status");
            return m;
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage());
            throw new ApplicationRuntimeException(STR_EXCEPTION + e.getMessage(), (Throwable)e);
        }
    }

    public EmployeeServiceOld getEmployeeService() {
        return this.employeeService;
    }

    public void setEmployeeService(EmployeeServiceOld employeeService) {
        this.employeeService = employeeService;
    }
}

