/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pims.client;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infstr.utils.EgovMasterDataCaching;
import org.egov.pims.client.GenericForm;
import org.egov.pims.dao.GenericMasterDAO;
import org.egov.pims.model.GenericMaster;
import org.egov.pims.service.EmployeeServiceOld;
import org.hibernate.exception.ConstraintViolationException;
import org.springframework.beans.factory.annotation.Autowired;

public class AfterGenericMasterAction
extends DispatchAction {
    public static final Logger LOGGER = Logger.getLogger(AfterGenericMasterAction.class.getClass());
    private EmployeeServiceOld employeeService;
    @Autowired
    private EgovMasterDataCaching masterDataCache;
    @Autowired
    private GenericMasterDAO genericMasterDAO;
    private static final String ERROR = "error";
    private static final String EXCEPTION = "Exception:";
    private static final String STR_VIEWMODE = "viewMode";

    public ActionForward saveDetails(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        String target = null;
        String alertMessage = null;
        String className = req.getParameter("className").trim();
        GenericMaster genericMaster = null;
        try {
            String code;
            GenericForm genericForm = (GenericForm)form;
            genericMaster = (GenericMaster)Class.forName("org.egov.pims.model." + className).newInstance();
            if (genericForm.getName() != null && !genericForm.getName().equals("") && this.employeeService.checkDuplication(code = genericForm.getName().trim().toUpperCase(), className)) {
                throw new ApplicationRuntimeException("duplicate " + className);
            }
            if (genericForm.getFromDate() != null && !genericForm.getFromDate().equals("")) {
                genericMaster.setFromDate(this.getDateString(genericForm.getFromDate()));
            }
            if (genericForm.getToDate() != null && !genericForm.getToDate().equals("")) {
                genericMaster.setToDate(this.getDateString(genericForm.getToDate()));
            }
            if (genericForm.getName() != null && !genericForm.getName().equals("")) {
                genericMaster.setName(genericForm.getName());
            }
            this.genericMasterDAO.create(genericMaster);
            this.removeFromCache(className);
            target = "success";
            alertMessage = "Executed successfully";
        }
        catch (ApplicationRuntimeException e) {
            target = ERROR;
            LOGGER.error((Object)e.getMessage());
            ApplicationRuntimeException er = new ApplicationRuntimeException(e.getMessage());
            er.initCause((Throwable)e);
        }
        catch (ClassNotFoundException e) {
            target = ERROR;
            LOGGER.error((Object)e.getMessage());
            ApplicationRuntimeException er = new ApplicationRuntimeException("class not found Exception : " + e.getMessage());
            er.initCause((Throwable)e);
        }
        catch (Exception ex) {
            target = ERROR;
            LOGGER.error((Object)ex.getMessage());
            throw new ApplicationRuntimeException(EXCEPTION + ex.getMessage(), (Throwable)ex);
        }
        req.setAttribute("alertMessage", alertMessage);
        return mapping.findForward(target);
    }

    public ActionForward modifyDetails(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        String target = null;
        String alertMessage = null;
        try {
            GenericForm genericForm = (GenericForm)form;
            String className = req.getParameter("className").trim();
            GenericMaster genericMastr = this.genericMasterDAO.getGenericMaster(Integer.valueOf(genericForm.getId()), className);
            if (genericForm.getFromDate() != null && !genericForm.getFromDate().equals("")) {
                genericMastr.setFromDate(this.getDateString(genericForm.getFromDate()));
            }
            if (genericForm.getToDate() != null && !genericForm.getToDate().equals("")) {
                genericMastr.setToDate(this.getDateString(genericForm.getToDate()));
            }
            if (genericForm.getName() != null && !genericForm.getName().equals("")) {
                genericMastr.setName(genericForm.getName());
            }
            this.genericMasterDAO.update(genericMastr);
            this.removeFromCache(className);
            req.getSession().removeAttribute("Id");
            target = "success";
            alertMessage = "Executed successfully";
        }
        catch (Exception ex) {
            LOGGER.error((Object)ex.getMessage());
            throw new ApplicationRuntimeException(EXCEPTION + ex.getMessage(), (Throwable)ex);
        }
        req.setAttribute("alertMessage", (Object)alertMessage);
        req.getSession().setAttribute(STR_VIEWMODE, (Object)"create");
        return mapping.findForward(target);
    }

    public ActionForward deleteDetails(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        String target = null;
        String alertMessage = null;
        try {
            GenericForm genericForm = (GenericForm)form;
            String className = req.getParameter("className").trim();
            GenericMaster genericMaster = this.genericMasterDAO.getGenericMaster(Integer.valueOf(genericForm.getId()), className);
            this.genericMasterDAO.remove(genericMaster);
            this.removeFromCache(className);
            req.getSession().removeAttribute("Id");
            target = "success";
            alertMessage = "Executed deleting successfully";
        }
        catch (ConstraintViolationException ex) {
            target = ERROR;
            alertMessage = "This data can't be deleted as it is being used";
            LOGGER.error((Object)ex.getMessage());
        }
        catch (Exception ex) {
            LOGGER.error((Object)ex.getMessage());
            throw new ApplicationRuntimeException(EXCEPTION + ex.getMessage(), (Throwable)ex);
        }
        req.setAttribute("alertMessage", (Object)alertMessage);
        req.getSession().setAttribute(STR_VIEWMODE, (Object)"create");
        return mapping.findForward(target);
    }

    private void removeFromCache(String className) {
        try {
            String tagName = "egEmp-" + className.trim();
            EgovMasterDataCaching.removeFromCache((String)tagName);
        }
        catch (ApplicationRuntimeException e) {
            LOGGER.error((Object)e.getMessage());
            throw new ApplicationRuntimeException(EXCEPTION + e.getMessage(), (Throwable)e);
        }
    }

    private Date getDateString(String dateString) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy", Locale.getDefault());
        Date d = null;
        try {
            d = dateFormat.parse(dateString);
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage());
            throw new ApplicationRuntimeException(EXCEPTION + e.getMessage(), (Throwable)e);
        }
        return d;
    }

    public EmployeeServiceOld getEmployeeService() {
        return this.employeeService;
    }

    public void setEmployeeService(EmployeeServiceOld employeeService) {
        this.employeeService = employeeService;
    }
}

