/*
 * Decompiled with CFR 0.152.
 */
package org.egov.eis.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.egov.eis.entity.Assignment;
import org.egov.eis.entity.Employee;
import org.egov.eis.entity.HeadOfDepartments;
import org.egov.eis.repository.AssignmentRepository;
import org.egov.eis.repository.HeadOfDepartmentsRepository;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.Role;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.BoundaryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class AssignmentService {
    private final AssignmentRepository assignmentRepository;
    private final HeadOfDepartmentsRepository employeeDepartmentRepository;
    @Autowired
    private BoundaryService boundaryService;

    @Autowired
    public AssignmentService(AssignmentRepository assignmentRepository, HeadOfDepartmentsRepository employeeDepartmentRepository) {
        this.assignmentRepository = assignmentRepository;
        this.employeeDepartmentRepository = employeeDepartmentRepository;
    }

    public Assignment getAssignmentById(Long Id2) {
        return (Assignment)((Object)this.assignmentRepository.findOne(Id2));
    }

    public List<Assignment> getAllAssignmentsByEmpId(Long empId) {
        return this.assignmentRepository.getAllAssignmentsByEmpId(empId);
    }

    public List<Assignment> getAllActiveEmployeeAssignmentsByEmpId(Long empId) {
        return this.assignmentRepository.getAllActiveAssignmentsByEmpId(empId);
    }

    public List<Assignment> getAssignmentsForPosition(Long posId, Date givenDate) {
        return this.assignmentRepository.getAssignmentsForPosition(posId, givenDate);
    }

    public Assignment getPrimaryAssignmentForPositon(Long posId) {
        return this.assignmentRepository.getPrimaryAssignmentForPosition(posId);
    }

    @Transactional
    public void createAssignment(Assignment assignment) {
        this.assignmentRepository.save((Object)assignment);
    }

    @Transactional
    public void updateAssignment(Assignment assignment) {
        this.assignmentRepository.save((Object)assignment);
    }

    public Assignment getPrimaryAssignmentForUser(Long userId) {
        return this.assignmentRepository.getPrimaryAssignmentForUser(userId);
    }

    public Assignment getPrimaryAssignmentForEmployee(Long empId) {
        return this.assignmentRepository.getPrimaryAssignmentForEmployee(empId);
    }

    public Assignment getPrimaryAssignmentForEmployeeByToDate(Long empId, Date toDate) {
        return this.assignmentRepository.getAssignmentByEmpAndDate(empId, toDate);
    }

    public List<Assignment> getAssignmentsForPosition(Long posId) {
        return this.assignmentRepository.getAssignmentsForPosition(posId);
    }

    public Boolean isHod(Long assignId) {
        List<HeadOfDepartments> hodList = this.employeeDepartmentRepository.getAllHodDepartments(assignId);
        return !hodList.isEmpty();
    }

    public Assignment getPrimaryAssignmentForPositionAndDate(Long posId, Date givenDate) {
        return this.assignmentRepository.getPrimaryAssignmentForPositionAndDate(posId, givenDate);
    }

    public Assignment getPrimaryAssignmentForGivenRange(Long empId, Date fromDate, Date toDate) {
        return this.assignmentRepository.getPrimaryAssignmentForGivenRange(empId, fromDate, toDate);
    }

    public List<Assignment> getPositionsByDepartmentAndDesignationForGivenRange(Long departmentId, Long designationId, Date givenDate) {
        if (departmentId != null && designationId != null) {
            return this.assignmentRepository.getPrimaryAssignmentForDepartmentAndDesignation(departmentId, designationId, givenDate);
        }
        if (designationId != null && departmentId == null) {
            return this.assignmentRepository.getPrimaryAssignmentForDesignation(designationId, givenDate);
        }
        if (designationId == null && departmentId != null) {
            return this.assignmentRepository.getPrimaryAssignmentForDepartment(departmentId, givenDate);
        }
        return new ArrayList<Assignment>();
    }

    public List<Assignment> getAllPositionsByDepartmentAndDesignationForGivenRange(Long departmentId, Long designationId, Date givenDate) {
        if (departmentId != null && designationId != null) {
            return this.assignmentRepository.getAllAssignmentForDepartmentAndDesignation(departmentId, designationId, givenDate);
        }
        if (designationId != null && departmentId == null) {
            return this.assignmentRepository.getAllAssignmentForDesignation(designationId, givenDate);
        }
        if (designationId == null && departmentId != null) {
            return this.assignmentRepository.getAllAssignmentForDepartment(departmentId, givenDate);
        }
        return new ArrayList<Assignment>();
    }

    public List<Assignment> getAssignmentsByDeptDesigAndDates(Long deptId, Long desigId, Date fromDate, Date toDate) {
        return this.assignmentRepository.findByDeptDesigAndDates(deptId, desigId, fromDate, toDate);
    }

    public List<Assignment> findAllAssignmentsByDeptDesigAndDates(Long deptId, Long desigId, Date givenDate) {
        return this.assignmentRepository.findAllAssignmentsByDeptDesigAndGivenDate(deptId, desigId, givenDate);
    }

    public List<Assignment> findByEmployeeAndGivenDate(Long empId, Date givenDate) {
        return this.assignmentRepository.findByEmployeeAndGivenDate(empId, givenDate);
    }

    public List<Assignment> findPrimaryAssignmentForDesignationName(String name) {
        return this.assignmentRepository.findPrimaryAssignmentForDesignationName(name);
    }

    public List<Assignment> findByDesignationAndBoundary(Long desigId, Long boundaryId) {
        return this.assignmentRepository.findByDesignationAndBoundary(desigId, this.getBoundaries(boundaryId));
    }

    public List<Assignment> findByDepartmentDesignationAndBoundary(Long deptId, Long desigId, Long boundaryId) {
        List<Assignment> assignments = null;
        assignments = null == deptId ? this.assignmentRepository.findByDesignationAndBoundary(desigId, this.getRequiredBoundaries(boundaryId)) : (null == desigId ? this.assignmentRepository.findByDepartmentAndBoundary(deptId, this.getRequiredBoundaries(boundaryId)) : this.assignmentRepository.findByDepartmentDesignationAndBoundary(deptId, desigId, this.getRequiredBoundaries(boundaryId)));
        return assignments;
    }

    private Set<Long> getBoundaries(Long boundaryId) {
        HashSet<Long> bndIds = new HashSet<Long>();
        List boundaries = this.boundaryService.findActiveChildrenWithParent(boundaryId);
        boundaries.forEach(bndry -> bndIds.add(bndry.getId()));
        return bndIds;
    }

    public Set<Long> getRequiredBoundaries(Long boundaryId) {
        HashSet<Long> bndIds = new HashSet<Long>();
        Boundary childBndry = this.boundaryService.getBoundaryById(boundaryId);
        String childmpath = childBndry.getMaterializedPath();
        HashSet<String> mpathStr = new HashSet<String>();
        mpathStr.add(childBndry.getMaterializedPath());
        for (int i = 0; i < childmpath.length(); ++i) {
            childmpath = childmpath.substring(0, childmpath.lastIndexOf("."));
            mpathStr.add(childmpath);
        }
        List boundaries = this.boundaryService.findActiveBoundariesForMpath(mpathStr);
        boundaries.forEach(bndry -> bndIds.add(bndry.getId()));
        return bndIds;
    }

    public List<Assignment> getAllActiveAssignments(Long designationId) {
        return this.assignmentRepository.getAllActiveAssignments(designationId);
    }

    @Transactional
    public Employee removeDeletedAssignments(Employee employee, String removedAssignIds) {
        if (null != removedAssignIds) {
            for (String id : removedAssignIds.split(",")) {
                employee.getAssignments().remove(this.assignmentRepository.findOne(Long.valueOf(id)));
            }
        }
        return employee;
    }

    public Set<User> getUsersByDesignations(String[] designationNames) {
        return this.assignmentRepository.getUsersByDesignations(designationNames);
    }

    public Set<Role> getRolesForExpiredAssignmentsByEmpId(Long empId) {
        return this.assignmentRepository.getRolesForExpiredAssignmentsByEmpId(empId);
    }

    public Set<Role> getRolesForActiveAssignmentsByEmpId(Long empId) {
        return this.assignmentRepository.getRolesForActiveAssignmentsByEmpId(empId);
    }
}

