/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.web.controller.common;

import org.egov.infra.aadhaar.webservice.client.AadhaarInfoServiceClient;
import org.egov.infra.web.rest.error.ErrorResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/aadhaar"})
public class AadhaarInfoController {
    private static final Logger LOG = LoggerFactory.getLogger(AadhaarInfoController.class);
    @Autowired
    private AadhaarInfoServiceClient aadhaarInfoServiceClient;

    @RequestMapping(value={"/{uid}"}, produces={"application/json"})
    public ResponseEntity<?> aadhaarInfo(@PathVariable String uid) throws Exception {
        return new ResponseEntity((Object)this.aadhaarInfoServiceClient.getAadhaarInfo(uid).toJSON(), HttpStatus.OK);
    }

    @ExceptionHandler(value={Exception.class})
    public ResponseEntity<ErrorResponse> exceptionHandler(Exception ex) {
        LOG.error("Error occurred while contacting SRDH web service", (Throwable)ex);
        return new ResponseEntity((Object)new ErrorResponse("INFRA-001", "Detail not found in uidai server for the given aadhaar no", HttpStatus.NOT_FOUND), HttpStatus.NOT_FOUND);
    }
}

