/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.web.controller.admin.masters.department;

import javax.validation.Valid;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.service.DepartmentService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/department/create"})
public class CreateDepartmentController {
    private final DepartmentService departmentService;

    @Autowired
    public CreateDepartmentController(DepartmentService departmentService) {
        this.departmentService = departmentService;
    }

    @ModelAttribute
    public Department departmentModel() {
        return new Department();
    }

    @RequestMapping(method={RequestMethod.GET})
    public String createDepartmentForm(Model model) {
        return "department-form";
    }

    @RequestMapping(method={RequestMethod.POST})
    public String createDepartment(@Valid @ModelAttribute Department department, BindingResult errors, RedirectAttributes redirectAttrs) {
        if (errors.hasErrors()) {
            return "department-form";
        }
        this.departmentService.createDepartment(department);
        redirectAttrs.addFlashAttribute("message", (Object)"msg.dept.create.success");
        return "redirect:/department/view/" + department.getName();
    }
}

