/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.web.controller.admin.masters.crosshierarchy;

import java.util.List;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.BoundaryType;
import org.egov.infra.admin.master.entity.CrossHierarchy;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.admin.master.service.BoundaryTypeService;
import org.egov.infra.admin.master.service.CrossHierarchyService;
import org.egov.infra.web.controller.admin.masters.crosshierarchy.CrossHierarchyGenerator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/crosshierarchy/update/{nameArray}"})
public class ModifyCrossHierarchyController {
    @Autowired
    private CrossHierarchyService crossHierarchyService;
    @Autowired
    private BoundaryService boundaryService;
    @Autowired
    private BoundaryTypeService boundaryTypeService;

    @ModelAttribute
    public CrossHierarchyGenerator crossHierarchyGenerator() {
        return new CrossHierarchyGenerator();
    }

    @RequestMapping(method={RequestMethod.GET})
    public String crosshierarchyFormForUpdate(@ModelAttribute CrossHierarchyGenerator crossHierarchyGenerator, @PathVariable String[] nameArray, Model model) {
        Boundary boundary = null;
        BoundaryType boundaryType = null;
        if (nameArray.length > 1) {
            boundary = this.boundaryService.getBoundaryById(Long.valueOf(Long.parseLong(nameArray[0])));
            boundaryType = this.boundaryTypeService.getBoundaryTypeById(Long.valueOf(Long.parseLong(nameArray[1])));
        }
        List boundaryList = this.crossHierarchyService.getBoundaryByBoundaryType();
        List mappedBoundary = this.crossHierarchyService.getActiveChildBoundariesByBoundaryId(Long.valueOf(Long.parseLong(nameArray[0])));
        boundaryList.remove(mappedBoundary);
        model.addAttribute("boundary", (Object)boundary);
        model.addAttribute("boundaryType", (Object)boundaryType);
        model.addAttribute("boundaryList", (Object)boundaryList);
        model.addAttribute("mappedBoundary", (Object)mappedBoundary);
        return "crossHierarchy-editform";
    }

    @RequestMapping(method={RequestMethod.POST})
    public String crosshierarchyFormForUpdate(@ModelAttribute CrossHierarchyGenerator crossHierarchyGenerator, BindingResult errors, RedirectAttributes redirectAttrs, Model model) {
        if (errors.hasErrors()) {
            return "crossHierarchy-editform";
        }
        Boundary boundary = crossHierarchyGenerator.getBoundary();
        BoundaryType boundaryType = this.boundaryTypeService.getBoundaryTypeById(crossHierarchyGenerator.getBoundaryType().getId());
        List mappedBoundaries = this.crossHierarchyService.getActiveChildBoundariesByBoundaryId(boundary.getId());
        List selectedBoundaries = crossHierarchyGenerator.getBoundaries();
        if (!mappedBoundaries.isEmpty()) {
            mappedBoundaries.remove(selectedBoundaries);
            for (Boundary mappedBoundary : mappedBoundaries) {
                CrossHierarchy existingCrossHierarchy = this.crossHierarchyService.findAllByParentAndChildBoundary(boundary.getId(), mappedBoundary.getId());
                if (existingCrossHierarchy == null) continue;
                this.crossHierarchyService.delete(existingCrossHierarchy);
            }
        }
        if (!selectedBoundaries.isEmpty()) {
            for (Boundary mappedBoundary : crossHierarchyGenerator.getBoundaries()) {
                CrossHierarchy crossHierarchy = new CrossHierarchy();
                CrossHierarchy existingCrossHierarchy = this.crossHierarchyService.findAllByParentAndChildBoundary(boundary.getId(), mappedBoundary.getId());
                if (existingCrossHierarchy != null) continue;
                crossHierarchy.setChild(mappedBoundary);
                crossHierarchy.setParent(boundary);
                crossHierarchy.setParentType(boundaryType);
                crossHierarchy.setChildType(mappedBoundary.getBoundaryType());
                this.crossHierarchyService.create(crossHierarchy);
            }
        }
        model.addAttribute("message", (Object)"msg.crosshierarchy.update.success");
        return "crossHierarchy-success";
    }
}

