/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.web.controller.admin.masters.city;

import java.io.IOException;
import javax.validation.Valid;
import org.egov.infra.admin.master.entity.City;
import org.egov.infra.admin.master.entity.CityPreferences;
import org.egov.infra.admin.master.service.CityService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.filestore.service.FileStoreService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/city/setup"})
public class CitySetupController {
    @Autowired
    private CityService cityService;
    @Autowired
    @Qualifier(value="fileStoreService")
    protected FileStoreService fileStoreService;

    @ModelAttribute
    public City city() {
        City city = this.cityService.getCityByCode(ApplicationThreadLocals.getCityCode());
        if (city.getPreferences() == null) {
            city.setPreferences(new CityPreferences());
        }
        return city;
    }

    @RequestMapping(value={"/view"})
    public String showCitySetup() {
        return "city-setup";
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public String updateCitySetup(@Valid @ModelAttribute City city, BindingResult bindResult, @RequestParam(required=false) MultipartFile logo, RedirectAttributes redirectAttrs) throws IOException {
        if (bindResult.hasErrors()) {
            return "city-setup";
        }
        if (!logo.isEmpty()) {
            city.getPreferences().setMunicipalityLogo(this.fileStoreService.store(logo.getInputStream(), logo.getOriginalFilename(), logo.getContentType(), ApplicationThreadLocals.getCityCode()));
        }
        this.cityService.updateCity(city);
        redirectAttrs.addFlashAttribute("message", (Object)"msg.city.update.success");
        return "redirect:/city/setup/view";
    }
}

