/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.web.controller;

import java.util.List;
import org.egov.infra.admin.common.service.IdentityRecoveryService;
import org.egov.infra.admin.master.entity.Location;
import org.egov.infra.admin.master.service.LocationService;
import org.egov.infra.validation.ValidatorUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/login"})
public class LoginController {
    @Autowired
    private IdentityRecoveryService identityRecoveryService;
    @Autowired
    private LocationService locationService;
    @Autowired
    private ValidatorUtils validatorUtils;
    @Value(value="${user.pwd.strength}")
    private String passwordStrength;

    @PostMapping(value={"password/recover"})
    public String sendPasswordRecoveryURL(@RequestParam String identity, @RequestParam String originURL, @RequestParam boolean byOTP, RedirectAttributes redirectAttrib) {
        redirectAttrib.addAttribute("recovered", (Object)this.identityRecoveryService.generateAndSendUserPasswordRecovery(identity, originURL + "/egi/login/password/reset?token=", byOTP));
        redirectAttrib.addAttribute("byOTP", (Object)byOTP);
        return "redirect:/login/secure";
    }

    @GetMapping(value={"password/reset"}, params={"token"})
    public String viewPasswordReset(@RequestParam String token, Model model) {
        model.addAttribute("valid", (Object)this.identityRecoveryService.tokenValid(token));
        return "password/reset";
    }

    @PostMapping(value={"password/reset"})
    public String validateAndSendNewPassword(@RequestParam String token, @RequestParam String newPassword, @RequestParam String confirmPwd, RedirectAttributes redirectAttrib) {
        if (!newPassword.equals(confirmPwd)) {
            redirectAttrib.addAttribute("error", (Object)"err.login.pwd.mismatch");
            return "redirect:/login/password/reset?token=" + token;
        }
        if (!this.validatorUtils.isValidPassword(newPassword)) {
            redirectAttrib.addAttribute("error", (Object)("usr.pwd.strength.msg." + this.passwordStrength));
            return "redirect:/login/password/reset?token=" + token;
        }
        return "redirect:/login/secure?reset=" + this.identityRecoveryService.validateAndResetPassword(token, newPassword);
    }

    @GetMapping(value={"requiredlocations"})
    @ResponseBody
    public List<Location> requiredLocations(@RequestParam String username) {
        return this.locationService.getLocationRequiredByUserName(username);
    }
}

