/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.web.controller;

import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.egov.infra.microservice.utils.MicroserviceUtils;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.web.support.ui.Inbox;
import org.egov.infra.workflow.entity.State;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.infra.workflow.entity.StateHistory;
import org.egov.infra.workflow.entity.WorkflowTypes;
import org.egov.infra.workflow.inbox.InboxRenderServiceDeligate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/inbox"})
public class InboxController {
    @Autowired
    private InboxRenderServiceDeligate<StateAware> inboxRenderServiceDeligate;
    @Autowired
    private MicroserviceUtils microserviceUtils;

    @GetMapping(produces={"text/plain"})
    @ResponseBody
    public String showInbox() {
        return this.createInboxData(this.inboxRenderServiceDeligate.getInboxItems());
    }

    @GetMapping(value={"/draft"}, produces={"text/plain"})
    @ResponseBody
    public String showInboxDraft() {
        return this.createInboxData(this.inboxRenderServiceDeligate.getInboxDraftItems());
    }

    @GetMapping(value={"/history"}, produces={"text/plain"})
    @ResponseBody
    public String showInboxHistory(@RequestParam Long stateId) {
        return this.createInboxHistoryData(this.inboxRenderServiceDeligate.getWorkflowHistory(stateId));
    }

    private String createInboxData(List<StateAware> inboxStates) {
        List<Object> inboxItems = new ArrayList();
        for (StateAware stateAware : inboxStates) {
            State state = stateAware.getCurrentState();
            WorkflowTypes workflowTypes = this.inboxRenderServiceDeligate.getWorkflowType(stateAware.getStateType());
            Inbox inboxItem = new Inbox();
            inboxItem.setId(workflowTypes.isGrouped() ? "" : state.getId() + "#" + workflowTypes.getId());
            inboxItem.setDate(DateUtils.toDefaultDateTimeFormat((Date)state.getCreatedDate()));
            inboxItem.setSender(state.getSenderName());
            inboxItem.setTask(StringUtils.isBlank((CharSequence)state.getNatureOfTask()) ? workflowTypes.getDisplayName() : state.getNatureOfTask());
            String nextAction = this.inboxRenderServiceDeligate.getNextAction(state);
            inboxItem.setStatus(state.getValue() + (StringUtils.isBlank((CharSequence)nextAction) ? "" : " - " + nextAction));
            inboxItem.setDetails(StringUtils.isBlank((CharSequence)stateAware.getStateDetails()) ? "" : stateAware.getStateDetails());
            inboxItem.setLink(workflowTypes.getLink().replace(":ID", stateAware.myLinkId()));
            inboxItem.setCreatedDate(state.getCreatedDate());
            inboxItems.add(inboxItem);
        }
        inboxItems.addAll(this.microserviceUtils.getInboxItems());
        inboxItems = inboxItems.stream().sorted(Comparator.comparing(Inbox::getCreatedDate).reversed()).collect(Collectors.toList());
        return "{ \"data\":" + new GsonBuilder().create().toJson(inboxItems) + "}";
    }

    private String createInboxHistoryData(List<StateHistory> stateHistories) {
        LinkedList<Inbox> inboxHistoryItems = new LinkedList<Inbox>();
        for (StateHistory stateHistory : stateHistories) {
            WorkflowTypes workflowTypes = this.inboxRenderServiceDeligate.getWorkflowType(stateHistory.getState().getType());
            Inbox inboxHistoryItem = new Inbox();
            inboxHistoryItem.setId(stateHistory.getState().getId().toString());
            inboxHistoryItem.setDate(DateUtils.toDefaultDateTimeFormat((Date)stateHistory.getLastModifiedDate()));
            inboxHistoryItem.setSender(stateHistory.getSenderName());
            inboxHistoryItem.setTask(StringUtils.isBlank((CharSequence)stateHistory.getNatureOfTask()) ? workflowTypes.getDisplayName() : stateHistory.getNatureOfTask());
            inboxHistoryItem.setStatus(stateHistory.getValue() + (StringUtils.isBlank((CharSequence)stateHistory.getNextAction()) ? "" : "-" + stateHistory.getNextAction()));
            inboxHistoryItem.setDetails(StringUtils.isBlank((CharSequence)stateHistory.getComments()) ? "" : org.egov.infra.utils.StringUtils.escapeSpecialChars((String)stateHistory.getComments()));
            inboxHistoryItem.setLink("");
            inboxHistoryItems.add(inboxHistoryItem);
        }
        return "{ \"data\":" + new GsonBuilder().disableHtmlEscaping().create().toJson(inboxHistoryItems) + "}";
    }
}

