/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.web.controller;

import com.google.gson.GsonBuilder;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.egov.infra.admin.common.entity.Favourites;
import org.egov.infra.admin.common.entity.MenuLink;
import org.egov.infra.admin.common.service.FavouritesService;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.CityService;
import org.egov.infra.admin.master.service.ModuleService;
import org.egov.infra.admin.master.service.UserService;
import org.egov.infra.persistence.entity.enums.UserType;
import org.egov.infra.persistence.utils.PersistenceUtils;
import org.egov.infra.validation.ValidatorUtils;
import org.egov.infra.web.support.ui.Menu;
import org.egov.infra.web.utils.WebUtils;
import org.joda.time.Days;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import org.springframework.web.servlet.view.RedirectView;

@Controller
@RequestMapping(value={"/home"})
public class HomeController {
    private static final String FEEDBACK_MSG_FORMAT = "%s\n\n%s\n%s";
    private static final String NON_EMPLOYE_PORTAL_HOME = "/portal/home";
    @Autowired
    private ModuleService moduleService;
    @Autowired
    private FavouritesService favouritesService;
    @Autowired
    private UserService userService;
    @Autowired
    private PasswordEncoder passwordEncoder;
    @Autowired
    private CityService cityService;
    @Autowired
    private ValidatorUtils validatorUtils;
    @Value(value="${employee.portal.access.role}")
    private String portalAccessibleRole;
    @Value(value="${user.pwd.expiry.days}")
    private Integer userPasswordExpiryInDays;
    @Value(value="${app.version}")
    private String appVersion;
    @Value(value="${app.build.no}")
    private String appBuild;
    @Value(value="${app.core.build.no}")
    private String appCoreBuild;
    @Value(value="${issue.report.url}")
    private String issueReportingUrl;
    @Value(value="${dev.mode}")
    private boolean devMode;

    @GetMapping
    public ModelAndView showHome(HttpServletRequest request, HttpServletResponse response, ModelMap modelData) {
        User user = this.userService.getCurrentUser();
        WebUtils.setUserLocale((User)user, (HttpServletRequest)request, (HttpServletResponse)response);
        if (user.getType().equals((Object)UserType.EMPLOYEE) || user.getType().equals((Object)UserType.SYSTEM) || user.hasRole(this.portalAccessibleRole)) {
            return new ModelAndView(this.prepareOfficialHomePage(user, modelData), (Map)modelData);
        }
        return new ModelAndView((View)new RedirectView(NON_EMPLOYE_PORTAL_HOME, false));
    }

    @ResponseBody
    @PostMapping(value={"favourite/add"})
    public boolean addFavourite(@Valid @ModelAttribute Favourites favourites, BindingResult bindResult) {
        return !bindResult.hasErrors() && this.favouritesService.addToCurrentUserFavourite(favourites).getId() != null;
    }

    @ResponseBody
    @GetMapping(value={"favourite/remove"})
    public boolean removeFavourite(@RequestParam Integer actionId) {
        return this.favouritesService.removeFromCurrentUserFavourite(actionId);
    }

    @ResponseBody
    @GetMapping(value={"password/update"})
    public String changePassword(@RequestParam String currentPwd, @RequestParam String newPwd, @RequestParam String retypeNewPwd) {
        User user = this.userService.getCurrentUser();
        if (this.passwordEncoder.matches((CharSequence)currentPwd, user.getPassword())) {
            if (!this.validatorUtils.isValidPassword(newPwd)) {
                return "NEWPWD_INVALID";
            }
            if (newPwd.equals(retypeNewPwd)) {
                user.setPassword(this.passwordEncoder.encode((CharSequence)newPwd));
                user.updateNextPwdExpiryDate(this.userPasswordExpiryInDays);
                this.userService.updateUser(user);
                return "SUCCESS";
            }
            return "NEWPWD_UNMATCH";
        }
        return "CURRPWD_UNMATCH";
    }

    @ResponseBody
    @GetMapping(value={"feedback/sent"})
    public boolean sendFeedback(@RequestParam String subject, @RequestParam String message) {
        this.cityService.sentFeedBackMail(this.cityService.getContactEmail(), subject, String.format(FEEDBACK_MSG_FORMAT, message, "Regards", this.user().getName()));
        return true;
    }

    @ModelAttribute(value="user")
    public User user() {
        return (User)PersistenceUtils.unproxy((Object)this.userService.getCurrentUser());
    }

    @GetMapping(value={"profile/edit"})
    public String editProfile() {
        return "profile-edit";
    }

    @PostMapping(value={"profile/edit"})
    public String saveProfile(@Valid @ModelAttribute User user, BindingResult binder, HttpServletRequest request, HttpServletResponse response, RedirectAttributes redirAttrib) {
        if (binder.hasErrors()) {
            return "profile-edit";
        }
        this.userService.updateUser(user);
        WebUtils.setUserLocale((User)user, (HttpServletRequest)request, (HttpServletResponse)response);
        redirAttrib.addFlashAttribute("message", (Object)"msg.profile.update.success");
        return "redirect:/home/profile/edit";
    }

    @InitBinder
    public void initBinder(WebDataBinder binder) {
        binder.setDisallowedFields(new String[]{"id", "username"});
    }

    private String prepareOfficialHomePage(User user, ModelMap modelData) {
        modelData.addAttribute("menu", (Object)this.prepareApplicationMenu(this.moduleService.getMenuLinksForRoles(user.getRoles()), user));
        modelData.addAttribute("userName", (Object)(user.getName() == null ? "Anonymous" : user.getName()));
        modelData.addAttribute("app_version", (Object)this.appVersion);
        modelData.addAttribute("app_buildno", (Object)this.appBuild);
        if (!this.devMode) {
            modelData.addAttribute("app_core_build_no", (Object)this.appCoreBuild);
            modelData.addAttribute("dflt_pwd_reset_req", (Object)this.checkDefaultPasswordResetRequired(user));
            int daysToExpirePwd = this.daysToExpirePassword(user);
            modelData.addAttribute("pwd_expire_in_days", (Object)daysToExpirePwd);
            modelData.addAttribute("warn_pwd_expire", (Object)(daysToExpirePwd <= 5 ? 1 : 0));
        }
        modelData.addAttribute("issue_report_url", (Object)this.issueReportingUrl);
        return "home";
    }

    private List<MenuLink> getEmployeeSelfService(List<MenuLink> menuLinks, User user) {
        return menuLinks.parallelStream().filter(menuLink -> "EmployeeSelfService".equals(menuLink.getName())).findFirst().map(menuLink -> this.moduleService.getMenuLinksByParentModuleId(menuLink.getId(), user.getId())).orElse(Collections.emptyList());
    }

    private String prepareApplicationMenu(List<MenuLink> menuLinks, User user) {
        Menu menu = new Menu();
        menu.setId("menuID");
        menu.setTitle(" ");
        menu.setIcon("fa fa-reply-all");
        menu.setItems(new LinkedList());
        List favourites = this.moduleService.getUserFavouritesMenuLinks(user.getId());
        this.createApplicationMenu(menuLinks, favourites, user, menu);
        List essMenus = this.getEmployeeSelfService(menuLinks, user);
        if (!essMenus.isEmpty()) {
            this.createSelfServiceMenu(essMenus, menu);
        }
        this.createFavouritesMenu(favourites, menu);
        return "[" + new GsonBuilder().create().toJson((Object)menu) + "]";
    }

    private void createApplicationMenu(List<MenuLink> menuLinks, List<MenuLink> favourites, User user, Menu menu) {
        Menu applicationMenu = this.createSubmenu("apps", "Applications", "Applications", "javascript:void(0);", "fa fa-th floatLeft", menu);
        menuLinks.stream().filter(menuLink -> !"EmployeeSelfService".equals(menuLink.getName())).forEach(menuLink -> this.createSubmenuRoot(menuLink.getId(), menuLink.getDisplayName(), favourites, user, applicationMenu));
    }

    private void createFavouritesMenu(List<MenuLink> favourites, Menu menu) {
        Menu favouritesMenu = this.createSubmenu("favMenu", "Favourites", "Favourites", "javascript:void(0);", "fa fa-star floatLeft", menu);
        favourites.stream().forEach(favourite -> {
            Menu appLinks = new Menu();
            appLinks.setId("fav-" + favourite.getId());
            appLinks.setName(favourite.getName());
            appLinks.setLink("/" + favourite.getUrl());
            appLinks.setIcon("fa fa-times-circle remove-favourite");
            favouritesMenu.getItems().add(appLinks);
        });
    }

    private void createSelfServiceMenu(List<MenuLink> selfServices, Menu menu) {
        Menu selfServiceMenu = this.createSubmenu("ssMenu", "Self Service", "Self Service", "javascript:void(0);", "fa fa-ellipsis-h floatLeft", menu);
        selfServices.stream().forEach(selfService -> {
            Menu appLinks = new Menu();
            appLinks.setName(selfService.getName());
            appLinks.setLink("/" + selfService.getContextRoot() + selfService.getUrl());
            selfServiceMenu.getItems().add(appLinks);
        });
    }

    private void createApplicationLink(MenuLink childMenuLink, List<MenuLink> favourites, User user, Menu parentMenu) {
        if (childMenuLink.isEnabled()) {
            Menu appLink = new Menu();
            appLink.setId(childMenuLink.getId().toString());
            appLink.setIcon("fa fa-star floatLeft" + (favourites.contains(childMenuLink) ? " added-as-fav" : " add-to-favourites"));
            appLink.setName(childMenuLink.getName());
            appLink.setLink("/" + childMenuLink.getContextRoot() + childMenuLink.getUrl());
            parentMenu.getItems().add(appLink);
        } else {
            this.createSubmenuRoot(childMenuLink.getId(), childMenuLink.getName(), favourites, user, parentMenu);
        }
    }

    private void createSubmenuRoot(Long menuId, String menuName, List<MenuLink> favourites, User user, Menu parentMenu) {
        List submodules = this.moduleService.getMenuLinksByParentModuleId(menuId, user.getId());
        if (!submodules.isEmpty()) {
            Menu submenu = this.createSubmenu(String.valueOf(menuId), menuName, menuName, "javascript:void(0);", "", parentMenu);
            submodules.stream().forEach(submodule -> this.createApplicationLink(submodule, favourites, user, submenu));
        }
    }

    private Menu createSubmenu(String id, String name, String title, String link, String icon, Menu parent) {
        Menu submenuItem = new Menu();
        submenuItem.setId(id);
        submenuItem.setName(name);
        submenuItem.setIcon(icon);
        submenuItem.setLink(link);
        submenuItem.setItems(new LinkedList());
        parent.getItems().add(submenuItem);
        Menu submenu = new Menu();
        submenu.setTitle(title);
        submenu.setIcon("");
        submenu.setItems(new LinkedList());
        submenuItem.getItems().add(submenu);
        return submenu;
    }

    private boolean checkDefaultPasswordResetRequired(User user) {
        return this.passwordEncoder.matches((CharSequence)"12345678", user.getPassword()) || this.passwordEncoder.matches((CharSequence)"demo", user.getPassword());
    }

    private int daysToExpirePassword(User user) {
        return Days.daysBetween((ReadablePartial)new LocalDate(), (ReadablePartial)user.getPwdExpiryDate().toLocalDate()).getDays();
    }
}

