/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.web.controller.common;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.egov.infra.admin.master.service.CityService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.utils.FileStoreUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/downloadfile"})
public class FileDownloadController {
    @Autowired
    private FileStoreUtils fileStoreUtils;
    @Autowired
    private CityService cityService;

    @GetMapping
    @ResponseBody
    public ResponseEntity download(@RequestParam String fileStoreId, @RequestParam String moduleName, @RequestParam(defaultValue="false") boolean toSave) {
        return this.fileStoreUtils.fileAsResponseEntity(fileStoreId, moduleName, toSave);
    }

    @GetMapping(value={"/logo"})
    public void getLogo(HttpServletResponse response) throws IOException {
        IOUtils.write((byte[])this.cityService.getCityLogoAsBytes(), (OutputStream)response.getOutputStream());
    }

    @GetMapping(value={"/gis"})
    public void getKML(HttpServletResponse response) throws IOException {
        try (InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream("gis/" + ApplicationThreadLocals.getTenantID() + "/wards.kml");
             ServletOutputStream out = response.getOutputStream();){
            if (in != null) {
                response.setHeader("Content-Disposition", "inline;filename=wards.kml");
                response.setContentType("application/vnd.google-earth.kml+xml");
                IOUtils.write((byte[])IOUtils.toByteArray((InputStream)in), (OutputStream)out);
            }
        }
    }
}

