/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.web.controller.admin.masters.userrole;

import java.util.List;
import org.egov.infra.admin.master.entity.Role;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.RoleService;
import org.egov.infra.admin.master.service.UserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/userrole/update/{userId}"})
public class UpdateUserRoleController {
    private final UserService userService;
    private final RoleService roleService;

    @Autowired
    public UpdateUserRoleController(UserService userService, RoleService roleService) {
        this.userService = userService;
        this.roleService = roleService;
    }

    @ModelAttribute
    public User user(@PathVariable Long userId) {
        return this.userService.getUserById(userId);
    }

    @ModelAttribute(value="roles")
    public List<Role> roles() {
        return this.roleService.getNonInternalRoles();
    }

    @GetMapping
    public String updateUserRoleView() {
        return "userrole-update";
    }

    @PostMapping
    public String updateUserRoles(@ModelAttribute User user, BindingResult errors, RedirectAttributes redirectAttrs) {
        if (errors.hasErrors()) {
            return "/userrole/update/" + user.getId();
        }
        this.userService.updateUser(user);
        redirectAttrs.addFlashAttribute("message", (Object)"msg.usr.role.update.success");
        return "redirect:/userrole/view/" + user.getId();
    }
}

