/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.web.controller.admin.masters.user;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.UserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"user"})
public class UserController {
    @Autowired
    private UserService userService;

    @GetMapping(value={"username-like/{name}"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String userNames(@PathVariable String name) {
        return this.toJson(this.userService.getUsersByNameLike(name));
    }

    @GetMapping(value={"employee-name-like/"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String users(@RequestParam String employeeName) {
        return this.toJson(this.userService.getAllEmployeeNameLike(employeeName));
    }

    private String toJson(List<User> users) {
        JsonArray userInfos = new JsonArray();
        users.forEach(user -> {
            JsonObject userInfo = new JsonObject();
            userInfo.addProperty("name", user.getName());
            userInfo.addProperty("userName", user.getUsername());
            userInfo.addProperty("id", (Number)user.getId());
            userInfos.add((JsonElement)userInfo);
        });
        return userInfos.toString();
    }
}

