/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.web.controller.admin.masters.user;

import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.UserService;
import org.egov.infra.config.core.EnvironmentSettings;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"user"})
public class ResetPasswordController {
    @Autowired
    private UserService userService;
    @Autowired
    private PasswordEncoder passwordEncoder;
    @Autowired
    private EnvironmentSettings environmentSettings;

    @GetMapping(value={"reset-password"})
    public String showResetPassword() {
        return "reset-password";
    }

    @PostMapping(value={"reset-password"})
    public String resetPassword(@RequestParam Long userId, @RequestParam String password, RedirectAttributes redirAttrib) {
        User user = this.userService.getUserById(userId);
        user.setPassword(this.passwordEncoder.encode((CharSequence)password));
        user.updateNextPwdExpiryDate(this.environmentSettings.userPasswordExpiryInDays());
        this.userService.updateUser(user);
        redirAttrib.addFlashAttribute("message", (Object)"lbl.pwd.reset.success");
        redirAttrib.addFlashAttribute("name", (Object)user.getName());
        return "redirect:/user/reset-password";
    }
}

