/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.web.controller.admin.masters.crosshierarchy;

import java.util.List;
import org.egov.infra.admin.master.contracts.CrossHierarchyRequest;
import org.egov.infra.admin.master.entity.BoundaryType;
import org.egov.infra.admin.master.service.CrossHierarchyService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/crosshierarchy/update"})
public class SearchCrossHierarchyController {
    private static final String CROSS_HIERARCHY_UPDATE_VIEW = "redirect:/crosshierarchy/update/%s/%s";
    @Autowired
    private CrossHierarchyService crossHierarchyService;

    @ModelAttribute
    public CrossHierarchyRequest crossHierarchyRequest() {
        return new CrossHierarchyRequest();
    }

    @ModelAttribute(value="boundaryTypes")
    public List<BoundaryType> boundaryTypes() {
        return this.crossHierarchyService.getCrossHierarchyBoundaryTypes();
    }

    @GetMapping
    public String showCrossHierarchySearchForm() {
        return "cross-hierarchy-search";
    }

    @PostMapping
    public String searchCrossHierarchy(@ModelAttribute CrossHierarchyRequest crossHierarchyRequest, BindingResult errors) {
        if (errors.hasErrors()) {
            return "cross-hierarchy-search";
        }
        return String.format(CROSS_HIERARCHY_UPDATE_VIEW, crossHierarchyRequest.getBoundaryType().getId(), crossHierarchyRequest.getBoundary().getId());
    }
}

