/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.web.controller.admin.masters.crosshierarchy;

import java.util.List;
import org.egov.infra.admin.master.contracts.CrossHierarchyRequest;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.admin.master.service.BoundaryTypeService;
import org.egov.infra.admin.master.service.CrossHierarchyService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/crosshierarchy/update/{boundaryTypeId}/{boundaryId}"})
public class ModifyCrossHierarchyController {
    @Autowired
    private CrossHierarchyService crossHierarchyService;
    @Autowired
    private BoundaryService boundaryService;
    @Autowired
    private BoundaryTypeService boundaryTypeService;

    @ModelAttribute
    public CrossHierarchyRequest crossHierarchyRequest() {
        return new CrossHierarchyRequest();
    }

    @GetMapping
    public String showCrossHierarchyUpdateForm(@ModelAttribute CrossHierarchyRequest crossHierarchyGenerator, @PathVariable Long boundaryTypeId, @PathVariable Long boundaryId, Model model) {
        List boundaries = this.crossHierarchyService.getBoundaryByBoundaryType();
        List mappedBoundary = this.crossHierarchyService.getActiveChildBoundariesByParentId(boundaryId);
        boundaries.removeAll(mappedBoundary);
        model.addAttribute("boundary", (Object)this.boundaryService.getBoundaryById(boundaryId));
        model.addAttribute("boundaryType", (Object)this.boundaryTypeService.getBoundaryTypeById(boundaryTypeId));
        model.addAttribute("boundaries", (Object)boundaries);
        model.addAttribute("mappedBoundary", (Object)mappedBoundary);
        return "cross-hierarchy-edit";
    }

    @PostMapping
    public String updateCrossHierarchy(@ModelAttribute CrossHierarchyRequest crossHierarchyRequest, BindingResult bindResult, RedirectAttributes redirectAttrs) {
        if (bindResult.hasErrors()) {
            return "cross-hierarchy-edit";
        }
        this.crossHierarchyService.addOrRemoveCrossHierarchy(crossHierarchyRequest);
        redirectAttrs.addFlashAttribute("message", (Object)"msg.crosshierarchy.update.success");
        return "redirect:/crosshierarchy/update";
    }
}

