/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.web.controller.admin.masters.boundary;

import java.util.List;
import java.util.Optional;
import javax.validation.Valid;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.HierarchyType;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.admin.master.service.HierarchyTypeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"boundary/update"})
public class UpdateBoundaryController {
    private static final String BOUNDARY_UPDATE_VIEW = "boundary-update";
    @Autowired
    private BoundaryService boundaryService;
    @Autowired
    private HierarchyTypeService hierarchyTypeService;

    @ModelAttribute
    public Boundary boundary(@PathVariable Optional<Long> id) {
        return id.isPresent() ? this.boundaryService.getBoundaryById(id.get()) : new Boundary();
    }

    @ModelAttribute(value="hierarchyTypes")
    public List<HierarchyType> hierarchyTypes() {
        return this.hierarchyTypeService.getAllHierarchyTypes();
    }

    @GetMapping(value={"/"})
    public String showUpdateBoundarySearchForm(Model model) {
        model.addAttribute("search", (Object)true);
        return BOUNDARY_UPDATE_VIEW;
    }

    @GetMapping(value={"{id}"})
    public String showUpdateBoundaryForm(Model model) {
        model.addAttribute("search", (Object)false);
        return BOUNDARY_UPDATE_VIEW;
    }

    @PostMapping(value={"{id}"})
    public String updateBoundary(@Valid @ModelAttribute Boundary boundary, BindingResult bindingResult, RedirectAttributes redirectAttributes, Model model) {
        if (bindingResult.hasErrors()) {
            model.addAttribute("boundaryType", (Object)boundary.getBoundaryType());
            model.addAttribute("parentBoundary", (Object)this.boundaryService.getActiveBoundariesByBoundaryTypeId(boundary.getBoundaryType().getParent().getId()));
            return BOUNDARY_UPDATE_VIEW;
        }
        this.boundaryService.updateBoundary(boundary);
        redirectAttributes.addFlashAttribute("message", (Object)"msg.bndry.update.success");
        redirectAttributes.addFlashAttribute("edit", (Object)true);
        return "redirect:/boundary/view/" + boundary.getId();
    }
}

