/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.web.controller.admin.masters.boundary;

import java.util.Collection;
import java.util.List;
import org.egov.infra.admin.master.contracts.BoundarySearchRequest;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.HierarchyType;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.admin.master.service.HierarchyTypeService;
import org.egov.infra.utils.JsonUtils;
import org.egov.infra.web.support.json.adapter.BoundaryAdapter;
import org.egov.infra.web.support.json.adapter.BoundaryDatatableAdapter;
import org.egov.infra.web.support.ui.DataTable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"boundary/search"})
public class SearchBoundaryController {
    @Autowired
    private HierarchyTypeService hierarchyTypeService;
    @Autowired
    private BoundaryService boundaryService;

    @ModelAttribute(value="hierarchyTypes")
    public List<HierarchyType> hierarchyTypes() {
        return this.hierarchyTypeService.getAllHierarchyTypes();
    }

    @GetMapping
    public String showBoundarySearchForm() {
        return "boundary-search";
    }

    @PostMapping(produces={"text/plain"})
    @ResponseBody
    public String searchBoundary(BoundarySearchRequest searchRequest) {
        return new DataTable(this.boundaryService.getPageOfBoundaries(searchRequest), (long)searchRequest.draw()).toJson(BoundaryDatatableAdapter.class);
    }

    @GetMapping(value={"wards-by-zone"}, produces={"application/json"})
    @ResponseBody
    public List<Boundary> getWardByZone(@RequestParam Long zoneId) {
        return this.boundaryService.getActiveChildBoundariesByBoundaryId(zoneId);
    }

    @GetMapping(value={"by-boundarytype"}, produces={"application/json"})
    @ResponseBody
    public String boundaryByBoundaryType(@RequestParam Long boundaryTypeId) {
        return JsonUtils.toJSON((Collection)this.boundaryService.getActiveBoundariesByBoundaryTypeId(boundaryTypeId), Boundary.class, BoundaryAdapter.class).toString();
    }
}

