/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.web.controller.admin.masters.boundary;

import java.util.List;
import javax.validation.Valid;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.BoundaryType;
import org.egov.infra.admin.master.entity.HierarchyType;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.admin.master.service.BoundaryTypeService;
import org.egov.infra.admin.master.service.HierarchyTypeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"boundary/create"})
public class CreateBoundaryController {
    private static final String BOUNDARY_CREATE_VIEW = "boundary-create";
    @Autowired
    private BoundaryService boundaryService;
    @Autowired
    private BoundaryTypeService boundaryTypeService;
    @Autowired
    private HierarchyTypeService hierarchyTypeService;

    @ModelAttribute
    public Boundary boundary() {
        return new Boundary();
    }

    @ModelAttribute(value="hierarchyTypes")
    public List<HierarchyType> hierarchyTypes() {
        return this.hierarchyTypeService.getAllHierarchyTypes();
    }

    @GetMapping
    public String showCreateBoundarySearchForm(Model model) {
        model.addAttribute("search", (Object)true);
        return BOUNDARY_CREATE_VIEW;
    }

    @GetMapping(value={"{boundaryTypeId}"})
    public String showCreateBoundaryForm(@PathVariable Long boundaryTypeId, Model model, RedirectAttributes redirectAttributes) {
        BoundaryType boundaryType = this.boundaryTypeService.getBoundaryTypeById(boundaryTypeId);
        if (this.boundaryService.validateBoundary(boundaryType).booleanValue()) {
            redirectAttributes.addFlashAttribute("warning", (Object)"err.root.bndry.exists");
            return "redirect:/boundary/create";
        }
        model.addAttribute("boundaryType", (Object)boundaryType);
        if (boundaryType.getParent() != null) {
            model.addAttribute("parentBoundary", (Object)this.boundaryService.getActiveBoundariesByBoundaryTypeId(boundaryType.getParent().getId()));
        }
        model.addAttribute("search", (Object)false);
        return BOUNDARY_CREATE_VIEW;
    }

    @PostMapping
    public String createBoundary(@Valid @ModelAttribute Boundary boundary, BindingResult errors, RedirectAttributes redirectAttributes, Model model) {
        if (errors.hasErrors()) {
            BoundaryType boundaryType = boundary.getBoundaryType();
            model.addAttribute("boundaryType", (Object)boundaryType);
            model.addAttribute("parentBoundary", (Object)this.boundaryService.getActiveBoundariesByBoundaryTypeId(boundaryType.getParent().getId()));
            return BOUNDARY_CREATE_VIEW;
        }
        this.boundaryService.createBoundary(boundary);
        redirectAttributes.addFlashAttribute("message", (Object)"msg.bndry.create.success");
        redirectAttributes.addFlashAttribute("create", (Object)true);
        return "redirect:/boundary/view/" + boundary.getId();
    }
}

