/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.web.controller.admin.masters;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.BoundaryType;
import org.egov.infra.admin.master.entity.Role;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.admin.master.service.BoundaryTypeService;
import org.egov.infra.admin.master.service.CrossHierarchyService;
import org.egov.infra.admin.master.service.UserService;
import org.egov.infra.persistence.entity.enums.UserType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class GenericMasterAjaxController {
    private static final String BLOCK = "Block";
    private static final String REVENUE_HIERARCHY_TYPE = "REVENUE";
    private static final String DISPLAY_KEY = "Text";
    private static final String VALUE_KEY = "Value";
    @Autowired
    private BoundaryTypeService boundaryTypeService;
    @Autowired
    private BoundaryService boundaryService;
    @Autowired
    private UserService userService;
    @Autowired
    private CrossHierarchyService crossHierarchyService;

    @RequestMapping(value={"/boundarytype/ajax/boundarytypelist-for-hierarchy"}, method={RequestMethod.GET})
    @ResponseBody
    public void getBoundaryTypeByHierarchyType(@RequestParam Long hierarchyTypeId, HttpServletResponse response) throws IOException {
        List boundaryTypes = this.boundaryTypeService.getAllBoundarTypesByHierarchyTypeId(hierarchyTypeId);
        response.setContentType("application/json");
        IOUtils.write((String)this.buildJSONString(boundaryTypes), (Writer)response.getWriter());
    }

    @RequestMapping(value={"/boundaries-by-boundaryType"}, method={RequestMethod.GET})
    @ResponseBody
    public void getBoundariesByBoundaryType(@RequestParam Long boundaryTypeId, HttpServletResponse response) throws IOException {
        BoundaryType boundaryType = this.boundaryTypeService.getBoundaryTypeById(boundaryTypeId);
        List boundaries = this.boundaryService.getAllBoundariesOrderByBoundaryNumAsc(boundaryType);
        JsonArray jsonArray = new JsonArray();
        for (Boundary boundary : boundaries) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty(DISPLAY_KEY, boundary.getLocalName());
            jsonObject.addProperty(VALUE_KEY, (Number)boundary.getId());
            jsonArray.add((JsonElement)jsonObject);
        }
        response.setContentType("application/json");
        IOUtils.write((String)jsonArray.toString(), (Writer)response.getWriter());
    }

    @RequestMapping(value={"/check-is-root"}, method={RequestMethod.GET})
    @ResponseBody
    public boolean isRootBoundary(@RequestParam Long boundaryTypeId, @RequestParam Long hierarchyTypeId) {
        BoundaryType boundaryType = this.boundaryTypeService.getBoundaryTypeByIdAndHierarchyType(boundaryTypeId, hierarchyTypeId);
        return boundaryType.getParent() != null && boundaryType.getParent().getId() == 0L;
    }

    private String buildJSONString(List<BoundaryType> boundaryTypes) {
        JsonArray jsonArray = new JsonArray();
        for (BoundaryType boundaryType : boundaryTypes) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty(DISPLAY_KEY, boundaryType.getName());
            jsonObject.addProperty(VALUE_KEY, (Number)boundaryType.getId());
            jsonArray.add((JsonElement)jsonObject);
        }
        return jsonArray.toString();
    }

    @RequestMapping(value={"/boundarytype/ajax/checkchild"}, method={RequestMethod.GET})
    @ResponseBody
    public boolean isChildBoundaryTypePresent(@RequestParam Long parentId) {
        BoundaryType boundaryType = this.boundaryTypeService.getBoundaryTypeByParent(parentId);
        return boundaryType != null;
    }

    @RequestMapping(value={"/userRole/ajax/rolelist-for-user"}, method={RequestMethod.GET})
    @ResponseBody
    public void getRolesByUserName(@RequestParam String username, HttpServletResponse response) throws IOException {
        if (username != null) {
            Set roles = this.userService.getRolesByUsername(username);
            response.setContentType("application/json");
            IOUtils.write((String)this.buildRoles(roles), (Writer)response.getWriter());
        }
    }

    private String buildRoles(Set<Role> roles) {
        JsonArray jsonArray = new JsonArray();
        for (Role role : roles) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty(VALUE_KEY, (Number)role.getId());
            jsonObject.addProperty(DISPLAY_KEY, role.getName());
            jsonArray.add((JsonElement)jsonObject);
        }
        return jsonArray.toString();
    }

    @RequestMapping(value={"/userRole/ajax/userlist"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public void getAllActiveUserByNameLike(@RequestParam String userName, HttpServletResponse response) throws IOException {
        List userList = this.userService.findAllByMatchingUserNameForType(userName, UserType.EMPLOYEE);
        response.setContentType("application/json");
        IOUtils.write((String)this.buildUser(userList), (Writer)response.getWriter());
    }

    private String buildUser(List<User> users) {
        JsonArray jsonArray = new JsonArray();
        for (User user : users) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty(VALUE_KEY, (Number)user.getId());
            jsonObject.addProperty(DISPLAY_KEY, user.getUsername());
            jsonArray.add((JsonElement)jsonObject);
        }
        return jsonArray.toString();
    }

    @RequestMapping(value={"/boundary/ajaxBoundary-blockByLocality", "/public/boundary/ajaxBoundary-blockByLocality"}, method={RequestMethod.GET})
    public void blockByLocality(@RequestParam Long locality, HttpServletResponse response) throws IOException {
        BoundaryType blockType = this.boundaryTypeService.getBoundaryTypeByNameAndHierarchyTypeName(BLOCK, REVENUE_HIERARCHY_TYPE);
        List blocks = this.crossHierarchyService.getParentBoundaryByChildBoundaryAndParentBoundaryType(locality, blockType.getId());
        List streets = this.boundaryService.getActiveChildBoundariesByBoundaryId(locality);
        ArrayList<JsonObject> wardJsonObjs = new ArrayList<JsonObject>();
        ArrayList<Long> boundaries = new ArrayList<Long>();
        for (Object block : blocks) {
            Boundary ward = block.getParent();
            JsonObject jsonObject = new JsonObject();
            if (!boundaries.contains(ward.getId())) {
                jsonObject.addProperty("wardId", (Number)ward.getId());
                jsonObject.addProperty("wardName", ward.getName());
            }
            jsonObject.addProperty("blockId", (Number)block.getId());
            jsonObject.addProperty("blockName", block.getName());
            wardJsonObjs.add(jsonObject);
            boundaries.add(ward.getId());
        }
        ArrayList<JsonObject> streetJsonObjs = new ArrayList<JsonObject>();
        for (Boundary street : streets) {
            JsonObject streetObj = new JsonObject();
            streetObj.addProperty("streetId", (Number)street.getId());
            streetObj.addProperty("streetName", street.getName());
            streetJsonObjs.add(streetObj);
        }
        HashMap<String, ArrayList<JsonObject>> map = new HashMap<String, ArrayList<JsonObject>>();
        map.put("boundaries", wardJsonObjs);
        map.put("streets", streetJsonObjs);
        JsonObject bj = new JsonObject();
        bj.add("results", new Gson().toJsonTree(map));
        response.setContentType("application/json");
        IOUtils.write((String)bj.toString(), (Writer)response.getWriter());
    }

    @RequestMapping(value={"/boundary/ajaxBoundary-blockByWard", "/public/boundary/ajaxBoundary-blockByWard"}, method={RequestMethod.GET})
    public void blockByWard(@RequestParam Long wardId, HttpServletResponse response) throws IOException {
        List blocks = this.boundaryService.getActiveChildBoundariesByBoundaryId(wardId);
        ArrayList<JsonObject> jsonObjects = new ArrayList<JsonObject>();
        for (Boundary block : blocks) {
            JsonObject jsonObj = new JsonObject();
            jsonObj.addProperty("blockId", (Number)block.getId());
            jsonObj.addProperty("blockName", block.getName());
            jsonObjects.add(jsonObj);
        }
        IOUtils.write((String)((Object)jsonObjects).toString(), (Writer)response.getWriter());
    }
}

