/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.web.controller.admin.auditing.report;

import java.util.Arrays;
import java.util.List;
import org.egov.infra.persistence.entity.enums.UserType;
import org.egov.infra.security.audit.contract.LoginAuditReportRequest;
import org.egov.infra.security.audit.entity.LoginAudit;
import org.egov.infra.security.audit.service.LoginAuditService;
import org.egov.infra.web.support.ui.DataTable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/audit/report/login"})
public class LoginAuditReportController {
    @Autowired
    private LoginAuditService loginAuditService;

    @ModelAttribute(value="userTypes")
    public List<UserType> userTypes() {
        return Arrays.asList(UserType.values());
    }

    @ModelAttribute
    public LoginAuditReportRequest loginAuditReportRequest() {
        return new LoginAuditReportRequest();
    }

    @GetMapping
    public String loginAuditReportSearchView() {
        return "login-audit-report";
    }

    @PostMapping(produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public DataTable<LoginAudit> loginAuditReport(@ModelAttribute LoginAuditReportRequest loginAuditReportRequest) {
        return new DataTable(this.loginAuditService.getLoginAudits(loginAuditReportRequest), (long)loginAuditReportRequest.draw());
    }
}

