/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.web.controller;

import java.util.List;
import org.egov.infra.web.support.ui.Inbox;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.infra.workflow.inbox.InboxRenderServiceDelegate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/inbox"})
public class InboxController {
    @Autowired
    private InboxRenderServiceDelegate<StateAware> inboxRenderServiceDelegate;

    @GetMapping(produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public List<Inbox> showInbox() {
        return this.inboxRenderServiceDelegate.getCurrentUserInboxItems();
    }

    @GetMapping(value={"/draft"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public List<Inbox> showDraft() {
        return this.inboxRenderServiceDelegate.getCurrentUserDraftItems();
    }

    @GetMapping(value={"/history"}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public List<Inbox> showInboxHistory(@RequestParam Long stateId) {
        return this.inboxRenderServiceDelegate.getWorkflowHistoryItems(stateId);
    }
}

