/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.web.contract.response;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.egov.infra.admin.master.entity.Role;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.UserService;
import org.egov.infra.config.persistence.auditing.BaseRevisionEntity;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.utils.StringUtils;
import org.egov.infra.web.support.json.adapter.DataTableJsonAdapter;
import org.egov.infra.web.support.ui.DataTable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.history.Revision;
import org.springframework.stereotype.Component;

@Component
public class UserRoleChangeAuditReportAdapter
implements DataTableJsonAdapter<Revision<Integer, User>> {
    @Autowired
    private UserService userService;

    public JsonElement serialize(DataTable<Revision<Integer, User>> revisionDataTable, Type type, JsonSerializationContext jsonSerializationContext) {
        List userRevisions = revisionDataTable.getData();
        JsonArray userRevisionData = new JsonArray();
        AtomicReference previousChange = new AtomicReference();
        userRevisions.forEach(userRevision -> {
            String roleChange = StringUtils.join((Collection)((User)userRevision.getEntity()).getRoles().stream().map(Role::getName).collect(Collectors.toList()), (String)",");
            if (!roleChange.equalsIgnoreCase((String)previousChange.get())) {
                previousChange.set(roleChange);
                JsonObject userRevisionJSON = new JsonObject();
                BaseRevisionEntity baseRevisionEntity = (BaseRevisionEntity)userRevision.getMetadata().getDelegate();
                userRevisionJSON.addProperty("changedBy", this.userService.getUserById(baseRevisionEntity.getUserId()).getName());
                userRevisionJSON.addProperty("ipAddress", baseRevisionEntity.getIpAddress());
                userRevisionJSON.addProperty("modifiedTime", DateUtils.toDefaultDateTimeFormat((Date)baseRevisionEntity.getRevisionDate()));
                userRevisionJSON.addProperty("roles", roleChange);
                userRevisionData.add((JsonElement)userRevisionJSON);
            }
        });
        return this.enhance((JsonElement)userRevisionData, revisionDataTable);
    }
}

