/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.web.contract.response;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.egov.infra.admin.master.entity.Feature;
import org.egov.infra.admin.master.entity.Role;
import org.egov.infra.admin.master.service.UserService;
import org.egov.infra.config.persistence.auditing.BaseRevisionEntity;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.utils.StringUtils;
import org.egov.infra.web.support.json.adapter.DataTableJsonAdapter;
import org.egov.infra.web.support.ui.DataTable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.history.Revision;
import org.springframework.stereotype.Component;

@Component
public class FeatureRoleChangeAuditReportAdapter
implements DataTableJsonAdapter<Revision<Integer, Feature>> {
    @Autowired
    private UserService userService;

    public JsonElement serialize(DataTable<Revision<Integer, Feature>> revisionDataTable, Type type, JsonSerializationContext jsonSerializationContext) {
        List featureRevisions = revisionDataTable.getData();
        JsonArray featureRevisionData = new JsonArray();
        AtomicReference previousChange = new AtomicReference();
        featureRevisions.forEach(featureRevision -> {
            String roleChange = StringUtils.join((Collection)((Feature)featureRevision.getEntity()).getRoles().stream().map(Role::getName).collect(Collectors.toList()), (String)",");
            if (!roleChange.equalsIgnoreCase((String)previousChange.get())) {
                previousChange.set(roleChange);
                JsonObject featureRevisionJSON = new JsonObject();
                featureRevisionJSON.addProperty("roles", roleChange);
                BaseRevisionEntity baseRevisionEntity = (BaseRevisionEntity)featureRevision.getMetadata().getDelegate();
                featureRevisionJSON.addProperty("changedBy", this.userService.getUserById(baseRevisionEntity.getUserId()).getName());
                featureRevisionJSON.addProperty("ipAddress", baseRevisionEntity.getIpAddress());
                featureRevisionJSON.addProperty("modifiedTime", DateUtils.toDefaultDateTimeFormat((Date)baseRevisionEntity.getRevisionDate()));
                featureRevisionData.add((JsonElement)featureRevisionJSON);
            }
        });
        return this.enhance((JsonElement)featureRevisionData, revisionDataTable);
    }
}

