/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.web.contract.response;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.List;
import org.egov.infra.admin.master.entity.AppConfig;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.web.support.json.adapter.DataTableJsonAdapter;
import org.egov.infra.web.support.ui.DataTable;

public class AppConfigJsonAdapter
implements DataTableJsonAdapter<AppConfig> {
    public JsonElement serialize(DataTable<AppConfig> appConfigTableData, Type type, JsonSerializationContext jsc) {
        List appConfigs = appConfigTableData.getData();
        JsonArray appConfigData = new JsonArray();
        appConfigs.forEach(appConfig -> {
            JsonObject appConfigJSON = new JsonObject();
            appConfigJSON.addProperty("keyName", appConfig.getKeyName());
            appConfigJSON.addProperty("description", appConfig.getDescription());
            appConfigJSON.addProperty("module", appConfig.getModule().getName());
            appConfigJSON.addProperty("id", (Number)appConfig.getId());
            JsonArray configValues = new JsonArray();
            appConfig.getConfValues().forEach(configValue -> {
                JsonObject configValueJSON = new JsonObject();
                configValueJSON.addProperty("Effective Date", DateUtils.getDefaultFormattedDate((Date)configValue.getEffectiveFrom()));
                configValueJSON.addProperty("Value", configValue.getValue());
                configValues.add((JsonElement)configValueJSON);
            });
            appConfigJSON.add("values", (JsonElement)configValues);
            appConfigData.add((JsonElement)appConfigJSON);
        });
        return this.enhance((JsonElement)appConfigData, appConfigTableData);
    }
}

