/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.web.controller.admin.masters.department;

import javax.validation.Valid;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.service.DepartmentService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/department/update/{name}"})
public class UpdateDepartmentController {
    private final DepartmentService departmentService;

    @Autowired
    public UpdateDepartmentController(DepartmentService departmentService) {
        this.departmentService = departmentService;
    }

    @ModelAttribute
    public Department departmentModel(@PathVariable String name) {
        return this.departmentService.getDepartmentByName(name);
    }

    @RequestMapping(method={RequestMethod.GET})
    public String updateDepartmentForm() {
        return "department-updateForm";
    }

    @RequestMapping(method={RequestMethod.POST})
    public String updateDepartment(@ModelAttribute @Valid Department department, BindingResult errors, RedirectAttributes redirectAttributes) {
        if (errors.hasErrors()) {
            return "department-updateForm";
        }
        this.departmentService.updateDepartment(department);
        redirectAttributes.addFlashAttribute("message", (Object)"msg.dept.update.success");
        return "redirect:/department/view/" + department.getName();
    }
}

