/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.web.controller.admin.masters.boundarytype;

import javax.servlet.http.HttpServletRequest;
import org.egov.infra.admin.master.entity.BoundaryType;
import org.egov.infra.admin.master.service.BoundaryTypeService;
import org.egov.infra.admin.master.service.HierarchyTypeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
public class SearchBoundaryTypeController {
    private final HierarchyTypeService hierarchyTypeService;

    @Autowired
    public SearchBoundaryTypeController(BoundaryTypeService boundaryTypeService, HierarchyTypeService hierarchyTypeService) {
        this.hierarchyTypeService = hierarchyTypeService;
    }

    @ModelAttribute
    public BoundaryType boundaryTypeModel() {
        return new BoundaryType();
    }

    @RequestMapping(value={"/boundarytype/view"}, method={RequestMethod.GET})
    public String viewSearch(Model model) {
        model.addAttribute("hierarchyTypes", (Object)this.hierarchyTypeService.getAllHierarchyTypes());
        model.addAttribute("mode", (Object)"view");
        return "boundaryType-search";
    }

    @RequestMapping(value={"/boundarytype/update"}, method={RequestMethod.GET})
    public String updateSearch(Model model) {
        model.addAttribute("hierarchyTypes", (Object)this.hierarchyTypeService.getAllHierarchyTypes());
        model.addAttribute("mode", (Object)"update");
        return "boundaryType-search";
    }

    @RequestMapping(value={"/boundarytype/addchild"}, method={RequestMethod.GET})
    public String addChildSearch(Model model) {
        model.addAttribute("hierarchyTypes", (Object)this.hierarchyTypeService.getAllHierarchyTypes());
        model.addAttribute("mode", (Object)"addChild");
        return "boundaryType-search";
    }

    @RequestMapping(value={"/boundarytype/view", "/boundarytype/update", "/boundarytype/addchild"}, method={RequestMethod.POST})
    public String search(@ModelAttribute BoundaryType boundaryType, BindingResult errors, RedirectAttributes redirectAttrs, HttpServletRequest request) {
        if (errors.hasErrors()) {
            return "boundaryType-form";
        }
        String requestURI = request.getRequestURI();
        String redirectURI = "";
        String[] idSplit = boundaryType.getName().split(",");
        Long boundaryTypeId = Long.valueOf(idSplit[idSplit.length - 1]);
        if (requestURI.contains("view")) {
            redirectURI = "redirect:/boundarytype/view/" + boundaryTypeId;
        } else if (requestURI.contains("update")) {
            redirectURI = "redirect:/boundarytype/update/" + boundaryTypeId;
        } else if (requestURI.contains("addchild")) {
            redirectURI = "redirect:/boundarytype/addchild/" + boundaryTypeId;
        }
        return redirectURI;
    }
}

