/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.web.controller.admin.masters.boundary;

import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.utils.JsonUtils;
import org.egov.infra.web.support.json.adapter.BoundaryAdapter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class PageViewBoundaryController {
    private final BoundaryService boundaryService;

    @Autowired
    public PageViewBoundaryController(BoundaryService boundaryService) {
        this.boundaryService = boundaryService;
    }

    @RequestMapping(value={"/list-boundaries"}, method={RequestMethod.GET})
    @ResponseBody
    public void springPaginationDataTables(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Long boundaryTypeId = Long.valueOf(request.getParameter("boundaryTypeId"));
        List pageOfBoundaries = this.boundaryService.getPageOfBoundaries(boundaryTypeId);
        StringBuilder boundaryJSONData = new StringBuilder("{\"data\":").append(JsonUtils.toJSON((Collection)pageOfBoundaries, Boundary.class, BoundaryAdapter.class)).append("}");
        response.setContentType("application/json");
        IOUtils.write((CharSequence)boundaryJSONData, (Writer)response.getWriter());
    }
}

