/*
 * Decompiled with CFR 0.152.
 */
package org.egov.infra.web.controller.admin.masters.boundary;

import javax.validation.Valid;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.BoundaryType;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.admin.master.service.BoundaryTypeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
public class BoundaryController {
    private static final String REDIRECT_URL_VIEW = "redirect:/view-boundary/";
    private final BoundaryService boundaryService;
    private final BoundaryTypeService boundaryTypeService;

    @Autowired
    public BoundaryController(BoundaryService boundaryService, BoundaryTypeService boundaryTypeService) {
        this.boundaryService = boundaryService;
        this.boundaryTypeService = boundaryTypeService;
    }

    @ModelAttribute
    public void getBoundary(@PathVariable Long[] ids, Model model) {
        int paramLength = ids.length;
        Long boundaryId = null;
        if (paramLength > 2 && ids[2] != null) {
            boundaryId = ids[2];
            model.addAttribute("boundary", (Object)this.boundaryService.getBoundaryById(boundaryId));
        } else if (model.asMap().get("boundary") == null) {
            model.addAttribute("boundary", (Object)new Boundary());
        }
        Long boundaryTypeId = ids[1];
        BoundaryType boundaryType = this.boundaryTypeService.getBoundaryTypeById(boundaryTypeId);
        model.addAttribute("boundaryType", (Object)boundaryType);
        model.addAttribute("hierarchyType", (Object)boundaryType.getHierarchyType());
    }

    @RequestMapping(value={"/view-boundary/{ids}"}, method={RequestMethod.GET})
    public String viewBoundaryDetails() {
        return "boundary-view";
    }

    @RequestMapping(value={"/create-boundary/{ids}"}, method={RequestMethod.POST})
    public String showCreateBoundaryForm(Model model, RedirectAttributes redirectAttributes) {
        model.addAttribute("isUpdate", (Object)false);
        BoundaryType boundaryType = (BoundaryType)model.asMap().get("boundaryType");
        if (this.boundaryService.validateBoundary(boundaryType).booleanValue()) {
            redirectAttributes.addFlashAttribute("warning", (Object)"err.root.bndry.exists");
            return "redirect:/search-boundary";
        }
        if (boundaryType != null && boundaryType.getParent() != null) {
            model.addAttribute("parentBoundary", (Object)this.boundaryService.getActiveBoundariesByBoundaryTypeId(boundaryType.getParent().getId()));
        }
        return "boundary-create";
    }

    @RequestMapping(value={"/update-boundary/{ids}"}, method={RequestMethod.GET})
    public String showUpdateBoundaryForm(Model model) {
        model.addAttribute("isUpdate", (Object)true);
        BoundaryType boundaryType = (BoundaryType)model.asMap().get("boundaryType");
        if (boundaryType != null && boundaryType.getParent() != null) {
            model.addAttribute("parentBoundary", (Object)this.boundaryService.getActiveBoundariesByBoundaryTypeId(boundaryType.getParent().getId()));
        }
        return "boundary-create";
    }

    @RequestMapping(value={"/list-boundaries/{ids}"}, method={RequestMethod.POST})
    public String showPaginationForm() {
        return "view-boundaries";
    }

    @RequestMapping(value={"/update-boundary/{ids}"}, method={RequestMethod.POST})
    public String UpdateBoundary(@Valid @ModelAttribute Boundary boundary, BindingResult errors, RedirectAttributes redirectAttributes, Model model) {
        if (errors.hasErrors()) {
            model.addAttribute("isUpdate", (Object)true);
            model.addAttribute("boundaryType", (Object)boundary.getBoundaryType());
            model.addAttribute("parentBoundary", (Object)this.boundaryService.getActiveBoundariesByBoundaryTypeId(boundary.getBoundaryType().getParent().getId()));
            return "boundary-create";
        }
        this.boundaryService.updateBoundary(boundary);
        redirectAttributes.addFlashAttribute("boundary", (Object)boundary);
        redirectAttributes.addFlashAttribute("message", (Object)"msg.bndry.update.success");
        return REDIRECT_URL_VIEW + boundary.getBoundaryType().getHierarchyType().getId() + "," + boundary.getBoundaryType().getId();
    }
}

